/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.optimize.PublicizerLense;
import com.android.tools.r8.shaking.RootSetBuilder;
import com.android.tools.r8.utils.MethodSignatureEquivalence;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public final class ClassAndMemberPublicizer {
    private final DexApplication application;
    private final AppInfo appInfo;
    private final RootSetBuilder.RootSet rootSet;
    private final GraphLense previuosLense;
    private final PublicizerLense.PublicizedLenseBuilder lenseBuilder;
    private final Equivalence<DexMethod> equivalence = MethodSignatureEquivalence.get();
    private final Set<Equivalence.Wrapper<DexMethod>> methodPool = Sets.newConcurrentHashSet();

    private ClassAndMemberPublicizer(DexApplication application, AppInfo appInfo, RootSetBuilder.RootSet rootSet, GraphLense previousLense) {
        this.application = application;
        this.appInfo = appInfo;
        this.rootSet = rootSet;
        this.previuosLense = previousLense;
        this.lenseBuilder = PublicizerLense.createBuilder();
    }

    public static GraphLense run(ExecutorService executorService, Timing timing, DexApplication application, AppInfo appInfo, RootSetBuilder.RootSet rootSet, GraphLense previousLense) throws ExecutionException {
        return new ClassAndMemberPublicizer(application, appInfo, rootSet, previousLense).run(executorService, timing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GraphLense run(ExecutorService executorService, Timing timing) throws ExecutionException {
        timing.begin("Phase 1: collectMethods");
        try {
            ArrayList futures = new ArrayList();
            this.application.classes().forEach(clazz -> futures.add(executorService.submit(this.collectMethodPerClass((DexClass)clazz))));
            ThreadUtils.awaitFutures(futures);
        }
        finally {
            timing.end();
        }
        timing.begin("Phase 2: promoteToPublic");
        DexType.forAllInterfaces(this.appInfo.dexItemFactory, this::publicizeType);
        this.publicizeType(this.appInfo.dexItemFactory.objectType);
        timing.end();
        return this.lenseBuilder.build(this.appInfo, this.previuosLense);
    }

    private Runnable collectMethodPerClass(DexClass clazz) {
        return () -> clazz.forEachMethod(encodedMethod -> {
            if (!encodedMethod.isPrivateMethod() || encodedMethod.isStaticMethod()) {
                this.methodPool.add(this.equivalence.wrap(encodedMethod.method));
            }
        });
    }

    private void publicizeType(DexType type) {
        DexClass clazz = this.application.definitionFor(type);
        if (clazz != null && clazz.isProgramClass()) {
            clazz.accessFlags.promoteToPublic();
            clazz.forEachField(field -> field.accessFlags.promoteToPublic());
            LinkedHashSet<DexEncodedMethod> privateInstanceEncodedMethods = new LinkedHashSet<DexEncodedMethod>();
            clazz.forEachMethod(encodedMethod -> {
                if (this.publicizeMethod(clazz, (DexEncodedMethod)encodedMethod)) {
                    privateInstanceEncodedMethods.add((DexEncodedMethod)encodedMethod);
                }
            });
            if (!privateInstanceEncodedMethods.isEmpty()) {
                clazz.virtualizeMethods(privateInstanceEncodedMethods);
            }
        }
        type.forAllExtendsSubtypes(this::publicizeType);
    }

    private boolean publicizeMethod(DexClass holder, DexEncodedMethod encodedMethod) {
        MethodAccessFlags accessFlags = encodedMethod.accessFlags;
        if (accessFlags.isPublic()) {
            return false;
        }
        if (this.appInfo.dexItemFactory.isClassConstructor(encodedMethod.method)) {
            return false;
        }
        if (!accessFlags.isPrivate()) {
            accessFlags.unsetProtected();
            accessFlags.setPublic();
            return false;
        }
        assert (accessFlags.isPrivate());
        if (this.appInfo.dexItemFactory.isConstructor(encodedMethod.method)) {
            return false;
        }
        if (!accessFlags.isStatic()) {
            if (this.rootSet.noShrinking.containsKey(encodedMethod)) {
                return false;
            }
            if (holder.isInterface() || accessFlags.isSynthetic()) {
                return false;
            }
            Equivalence.Wrapper<DexMethod> key = this.equivalence.wrap(encodedMethod.method);
            if (this.methodPool.contains(key)) {
                if (this.rootSet.noObfuscation.contains(encodedMethod)) {
                    return false;
                }
                return false;
            }
            this.methodPool.add(key);
            this.lenseBuilder.add(encodedMethod.method);
            accessFlags.unsetPrivate();
            accessFlags.setFinal();
            accessFlags.setPublic();
            encodedMethod.method.setSingleVirtualMethodCache(encodedMethod.method.getHolder(), encodedMethod);
            encodedMethod.markPublicized();
            return true;
        }
        accessFlags.unsetPrivate();
        accessFlags.setPublic();
        return false;
    }
}

