/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.ir.code.Invoke;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class VerticalClassMergerGraphLense
extends GraphLense.NestedGraphLense {
    private final AppInfo appInfo;
    private final Set<DexMethod> mergedMethods;
    private final Map<DexType, Map<DexMethod, DexMethod>> contextualVirtualToDirectMethodMaps;

    public VerticalClassMergerGraphLense(AppInfo appInfo, Map<DexField, DexField> fieldMap, Map<DexMethod, DexMethod> methodMap, Set<DexMethod> mergedMethods, Map<DexType, Map<DexMethod, DexMethod>> contextualVirtualToDirectMethodMaps, GraphLense previousLense) {
        super(ImmutableMap.of(), methodMap, fieldMap, previousLense, appInfo.dexItemFactory);
        this.appInfo = appInfo;
        this.mergedMethods = mergedMethods;
        this.contextualVirtualToDirectMethodMaps = contextualVirtualToDirectMethodMaps;
    }

    public static Builder builder(AppInfo appInfo) {
        return new Builder(appInfo);
    }

    @Override
    public GraphLense.GraphLenseLookupResult lookupMethod(DexMethod method, DexEncodedMethod context, Invoke.Type type) {
        DexMethod directMethod;
        Map<DexMethod, DexMethod> virtualToDirectMethodMap;
        assert (this.isContextFreeForMethod(method) || context != null && type != null);
        GraphLense.GraphLenseLookupResult previous = this.previousLense.lookupMethod(method, context, type);
        if (previous.getType() == Invoke.Type.SUPER && !this.mergedMethods.contains(context.method) && (virtualToDirectMethodMap = this.contextualVirtualToDirectMethodMaps.get(context.method.holder)) != null && (directMethod = virtualToDirectMethodMap.get(previous.getMethod())) != null) {
            return new GraphLense.GraphLenseLookupResult(directMethod, Invoke.Type.DIRECT);
        }
        return super.lookupMethod(previous.getMethod(), context, previous.getType());
    }

    @Override
    protected Invoke.Type mapInvocationType(DexMethod newMethod, DexMethod originalMethod, DexEncodedMethod context, Invoke.Type type) {
        return super.mapVirtualInterfaceInvocationTypes(this.appInfo, newMethod, originalMethod, context, type);
    }

    @Override
    public Set<DexMethod> lookupMethodInAllContexts(DexMethod method) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (DexMethod previous : this.previousLense.lookupMethodInAllContexts(method)) {
            builder.add(this.methodMap.getOrDefault(previous, previous));
            for (Map<DexMethod, DexMethod> virtualToDirectMethodMap : this.contextualVirtualToDirectMethodMaps.values()) {
                DexMethod directMethod = virtualToDirectMethodMap.get(previous);
                if (directMethod == null) continue;
                builder.add(directMethod);
            }
        }
        return builder.build();
    }

    @Override
    public boolean isContextFreeForMethods() {
        return this.contextualVirtualToDirectMethodMaps.isEmpty() && this.previousLense.isContextFreeForMethods();
    }

    @Override
    public boolean isContextFreeForMethod(DexMethod method) {
        if (!this.previousLense.isContextFreeForMethod(method)) {
            return false;
        }
        DexMethod previous = this.previousLense.lookupMethod(method);
        for (Map<DexMethod, DexMethod> virtualToDirectMethodMap : this.contextualVirtualToDirectMethodMaps.values()) {
            if (!virtualToDirectMethodMap.containsKey(previous)) continue;
            return false;
        }
        return true;
    }

    public static class Builder {
        private final AppInfo appInfo;
        private final ImmutableMap.Builder<DexField, DexField> fieldMapBuilder = ImmutableMap.builder();
        private final ImmutableMap.Builder<DexMethod, DexMethod> methodMapBuilder = ImmutableMap.builder();
        private final ImmutableSet.Builder<DexMethod> mergedMethodsBuilder = ImmutableSet.builder();
        private final Map<DexType, Map<DexMethod, DexMethod>> contextualVirtualToDirectMethodMaps = new HashMap<DexType, Map<DexMethod, DexMethod>>();

        private Builder(AppInfo appInfo) {
            this.appInfo = appInfo;
        }

        public GraphLense build(GraphLense previousLense, Map<DexType, DexType> mergedClasses, DexItemFactory dexItemFactory) {
            ImmutableMap<DexField, DexField> fieldMap = this.fieldMapBuilder.build();
            ImmutableMap<DexMethod, DexMethod> methodMap = this.methodMapBuilder.build();
            if (fieldMap.isEmpty() && methodMap.isEmpty() && this.contextualVirtualToDirectMethodMaps.isEmpty()) {
                return previousLense;
            }
            return new VerticalClassMergerGraphLense(this.appInfo, fieldMap, methodMap, this.getMergedMethodSignaturesAfterClassMerging((Set<DexMethod>)((Object)this.mergedMethodsBuilder.build()), mergedClasses, dexItemFactory), this.contextualVirtualToDirectMethodMaps, previousLense);
        }

        private Set<DexMethod> getMergedMethodSignaturesAfterClassMerging(Set<DexMethod> mergedMethods, Map<DexType, DexType> mergedClasses, DexItemFactory dexItemFactory) {
            ImmutableSet.Builder result = ImmutableSet.builder();
            HashMap<DexProto, DexProto> cache = new HashMap<DexProto, DexProto>();
            for (DexMethod signature : mergedMethods) {
                DexType newHolder = mergedClasses.getOrDefault(signature.holder, signature.holder);
                DexProto newProto = dexItemFactory.applyClassMappingToProto(signature.proto, type -> mergedClasses.getOrDefault(type, (DexType)type), cache);
                if (signature.holder.equals(newHolder) && signature.proto.equals(newProto)) {
                    result.add(signature);
                    continue;
                }
                result.add(dexItemFactory.createMethod(newHolder, newProto, signature.name));
            }
            return result.build();
        }

        public boolean hasMappingForSignatureInContext(DexType context, DexMethod signature) {
            Map<DexMethod, DexMethod> virtualToDirectMethodMap = this.contextualVirtualToDirectMethodMaps.get(context);
            if (virtualToDirectMethodMap != null) {
                return virtualToDirectMethodMap.containsKey(signature);
            }
            return false;
        }

        public void markMethodAsMerged(DexMethod method) {
            this.mergedMethodsBuilder.add((Object)method);
        }

        public void map(DexField from, DexField to) {
            this.fieldMapBuilder.put(from, to);
        }

        public void map(DexMethod from, DexMethod to) {
            this.methodMapBuilder.put(from, to);
        }

        public void mapVirtualMethodToDirectInType(DexMethod from, DexMethod to, DexType type) {
            Map virtualToDirectMethodMap = this.contextualVirtualToDirectMethodMaps.computeIfAbsent(type, key -> new HashMap());
            virtualToDirectMethodMap.put(from, to);
        }

        public void merge(Builder builder) {
            this.fieldMapBuilder.putAll(builder.fieldMapBuilder.build());
            this.methodMapBuilder.putAll(builder.methodMapBuilder.build());
            this.mergedMethodsBuilder.addAll((Iterable)builder.mergedMethodsBuilder.build());
            for (DexType context : builder.contextualVirtualToDirectMethodMaps.keySet()) {
                Map<DexMethod, DexMethod> current = this.contextualVirtualToDirectMethodMaps.get(context);
                Map<DexMethod, DexMethod> other = builder.contextualVirtualToDirectMethodMaps.get(context);
                if (current != null) {
                    current.putAll(other);
                    continue;
                }
                this.contextualVirtualToDirectMethodMaps.put(context, other);
            }
        }
    }
}

