/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.multidex;

import com.android.tools.r8.GenerateMainDexList;
import com.android.tools.r8.GenerateMainDexListCommand;
import com.android.tools.r8.origin.Origin;
import com.google.common.collect.ImmutableList;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class D8MainDexList {
    private D8MainDexList() {
    }

    public static List<String> generate(List<String> mainDexRules, List<Path> mainDexRulesFiles, Collection<Path> programFiles, Collection<Path> libraryFiles) throws MainDexListException {
        try {
            GenerateMainDexListCommand.Builder command = (GenerateMainDexListCommand.Builder)GenerateMainDexListCommand.builder().addMainDexRules(mainDexRules, Origin.unknown()).addMainDexRulesFiles(mainDexRulesFiles).addLibraryFiles(libraryFiles);
            for (Path program : programFiles) {
                if (Files.isRegularFile(program, new LinkOption[0])) {
                    command.addProgramFiles(program);
                    continue;
                }
                Stream<Path> classFiles = Files.walk(program, new FileVisitOption[0]);
                Throwable throwable = null;
                try {
                    List<Path> allClasses = classFiles.filter(p -> p.toString().endsWith(".class")).collect(Collectors.toList());
                    command.addProgramFiles(allClasses);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (classFiles == null) continue;
                    if (throwable != null) {
                        try {
                            classFiles.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    classFiles.close();
                }
            }
            return ImmutableList.copyOf(GenerateMainDexList.run((GenerateMainDexListCommand)command.build(), ForkJoinPool.commonPool()));
        }
        catch (ExecutionException e) {
            throw new MainDexListException(e.getCause());
        }
        catch (Exception e) {
            throw new MainDexListException(e);
        }
    }

    public static class MainDexListException
    extends Exception {
        public MainDexListException(Throwable cause) {
            super(cause);
        }
    }
}

