/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.BiMap;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.IndexedDexItem;
import com.android.tools.r8.ir.code.Invoke;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public abstract class GraphLense {
    public static Builder builder() {
        return new Builder();
    }

    public abstract DexField getOriginalFieldSignature(DexField var1);

    public abstract DexMethod getOriginalMethodSignature(DexMethod var1);

    public abstract DexType lookupType(DexType var1);

    public DexMethod lookupMethod(DexMethod method) {
        assert (this.isContextFreeForMethod(method));
        return this.lookupMethod(method, null, null).getMethod();
    }

    public abstract GraphLenseLookupResult lookupMethod(DexMethod var1, DexEncodedMethod var2, Invoke.Type var3);

    public Set<DexMethod> lookupMethodInAllContexts(DexMethod method) {
        assert (this.isContextFreeForMethod(method));
        DexMethod result = this.lookupMethod(method);
        if (result != null) {
            return ImmutableSet.of(result);
        }
        return ImmutableSet.of();
    }

    public abstract DexField lookupField(DexField var1);

    public abstract boolean isContextFreeForMethods();

    public boolean isContextFreeForMethod(DexMethod method) {
        return this.isContextFreeForMethods();
    }

    public static GraphLense getIdentityLense() {
        return new IdentityGraphLense();
    }

    public final boolean isIdentityLense() {
        return this instanceof IdentityGraphLense;
    }

    public boolean assertNotModified(Iterable<DexItem> items) {
        for (DexItem item : items) {
            if (item instanceof DexClass) {
                DexType type = ((DexClass)item).type;
                assert (this.lookupType(type) == type);
                continue;
            }
            if (item instanceof DexEncodedMethod) {
                DexEncodedMethod method = (DexEncodedMethod)item;
                assert (method.accessFlags.isBridge() || this.lookupMethod(method.method) == method.method);
                continue;
            }
            if (item instanceof DexEncodedField) {
                DexField field = ((DexEncodedField)item).field;
                assert (this.lookupField(field) == field);
                continue;
            }
            assert (false);
        }
        return true;
    }

    public static class NestedGraphLense
    extends GraphLense {
        protected final GraphLense previousLense;
        protected final DexItemFactory dexItemFactory;
        protected final Map<DexType, DexType> typeMap;
        private final Map<DexType, DexType> arrayTypeCache = new IdentityHashMap<DexType, DexType>();
        protected final Map<DexMethod, DexMethod> methodMap;
        protected final Map<DexField, DexField> fieldMap;
        private final BiMap<DexField, DexField> originalFieldSignatures;
        private final BiMap<DexMethod, DexMethod> originalMethodSignatures;

        public NestedGraphLense(Map<DexType, DexType> typeMap, Map<DexMethod, DexMethod> methodMap, Map<DexField, DexField> fieldMap, BiMap<DexField, DexField> originalFieldSignatures, BiMap<DexMethod, DexMethod> originalMethodSignatures, GraphLense previousLense, DexItemFactory dexItemFactory) {
            this.typeMap = typeMap.isEmpty() ? null : typeMap;
            this.methodMap = methodMap;
            this.fieldMap = fieldMap;
            this.originalFieldSignatures = originalFieldSignatures;
            this.originalMethodSignatures = originalMethodSignatures;
            this.previousLense = previousLense;
            this.dexItemFactory = dexItemFactory;
        }

        @Override
        public DexField getOriginalFieldSignature(DexField field) {
            DexField originalField = this.originalFieldSignatures != null ? this.originalFieldSignatures.getOrDefault(field, field) : field;
            return this.previousLense.getOriginalFieldSignature(originalField);
        }

        @Override
        public DexMethod getOriginalMethodSignature(DexMethod method) {
            DexMethod originalMethod = this.originalMethodSignatures != null ? this.originalMethodSignatures.getOrDefault(method, method) : method;
            return this.previousLense.getOriginalMethodSignature(originalMethod);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DexType lookupType(DexType type) {
            if (type.isArrayType()) {
                NestedGraphLense nestedGraphLense = this;
                synchronized (nestedGraphLense) {
                    DexType result = this.arrayTypeCache.get(type);
                    if (result == null) {
                        DexType newType;
                        DexType baseType = type.toBaseType(this.dexItemFactory);
                        result = baseType == (newType = this.lookupType(baseType)) ? type : type.replaceBaseType(newType, this.dexItemFactory);
                        this.arrayTypeCache.put(type, result);
                    }
                    return result;
                }
            }
            DexType previous = this.previousLense.lookupType(type);
            return this.typeMap != null ? this.typeMap.getOrDefault(previous, previous) : previous;
        }

        @Override
        public GraphLenseLookupResult lookupMethod(DexMethod method, DexEncodedMethod context, Invoke.Type type) {
            GraphLenseLookupResult previous = this.previousLense.lookupMethod(method, context, type);
            DexMethod newMethod = this.methodMap.get(previous.getMethod());
            if (newMethod == null) {
                return previous;
            }
            return new GraphLenseLookupResult(newMethod, this.mapInvocationType(newMethod, method, context, previous.getType()));
        }

        protected Invoke.Type mapInvocationType(DexMethod newMethod, DexMethod originalMethod, DexEncodedMethod context, Invoke.Type type) {
            return type;
        }

        protected final Invoke.Type mapVirtualInterfaceInvocationTypes(AppInfo appInfo, DexMethod newMethod, DexMethod originalMethod, DexEncodedMethod context, Invoke.Type type) {
            if (type == Invoke.Type.VIRTUAL || type == Invoke.Type.INTERFACE) {
                DexClass newTargetClass = appInfo.definitionFor(newMethod.holder);
                if (newTargetClass == null) {
                    return type;
                }
                DexClass originalTargetClass = appInfo.definitionFor(originalMethod.holder);
                if (originalTargetClass != null && originalTargetClass.isInterface() ^ type == Invoke.Type.INTERFACE) {
                    return newTargetClass.accessFlags.isInterface() ? Invoke.Type.VIRTUAL : Invoke.Type.INTERFACE;
                }
                return newTargetClass.accessFlags.isInterface() ? Invoke.Type.INTERFACE : Invoke.Type.VIRTUAL;
            }
            return type;
        }

        @Override
        public Set<DexMethod> lookupMethodInAllContexts(DexMethod method) {
            HashSet<DexMethod> result = new HashSet<DexMethod>();
            for (DexMethod previous : this.previousLense.lookupMethodInAllContexts(method)) {
                result.add(this.methodMap.getOrDefault(previous, previous));
            }
            return result;
        }

        @Override
        public DexField lookupField(DexField field) {
            DexField previous = this.previousLense.lookupField(field);
            return this.fieldMap.getOrDefault(previous, previous);
        }

        @Override
        public boolean isContextFreeForMethods() {
            return this.previousLense.isContextFreeForMethods();
        }

        @Override
        public boolean isContextFreeForMethod(DexMethod method) {
            return this.previousLense.isContextFreeForMethod(method);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<DexType, DexType> entry : this.typeMap.entrySet()) {
                builder.append(entry.getKey().toSourceString()).append(" -> ");
                builder.append(entry.getValue().toSourceString()).append(System.lineSeparator());
            }
            for (Map.Entry<IndexedDexItem, IndexedDexItem> entry : this.methodMap.entrySet()) {
                builder.append(((DexMethod)entry.getKey()).toSourceString()).append(" -> ");
                builder.append(((DexMethod)entry.getValue()).toSourceString()).append(System.lineSeparator());
            }
            for (Map.Entry<IndexedDexItem, IndexedDexItem> entry : this.fieldMap.entrySet()) {
                builder.append(((DexField)entry.getKey()).toSourceString()).append(" -> ");
                builder.append(((DexField)entry.getValue()).toSourceString()).append(System.lineSeparator());
            }
            builder.append(this.previousLense.toString());
            return builder.toString();
        }
    }

    private static class IdentityGraphLense
    extends GraphLense {
        private IdentityGraphLense() {
        }

        @Override
        public DexField getOriginalFieldSignature(DexField field) {
            return field;
        }

        @Override
        public DexMethod getOriginalMethodSignature(DexMethod method) {
            return method;
        }

        @Override
        public DexType lookupType(DexType type) {
            return type;
        }

        @Override
        public GraphLenseLookupResult lookupMethod(DexMethod method, DexEncodedMethod context, Invoke.Type type) {
            return new GraphLenseLookupResult(method, type);
        }

        @Override
        public DexField lookupField(DexField field) {
            return field;
        }

        @Override
        public boolean isContextFreeForMethods() {
            return true;
        }
    }

    public static class Builder {
        protected final Map<DexType, DexType> typeMap = new IdentityHashMap<DexType, DexType>();
        protected final Map<DexMethod, DexMethod> methodMap = new IdentityHashMap<DexMethod, DexMethod>();
        protected final Map<DexField, DexField> fieldMap = new IdentityHashMap<DexField, DexField>();

        protected Builder() {
        }

        public void map(DexType from, DexType to) {
            this.typeMap.put(from, to);
        }

        public void map(DexMethod from, DexMethod to) {
            this.methodMap.put(from, to);
        }

        public void map(DexField from, DexField to) {
            this.fieldMap.put(from, to);
        }

        public GraphLense build(DexItemFactory dexItemFactory) {
            return this.build(dexItemFactory, new IdentityGraphLense());
        }

        public GraphLense build(DexItemFactory dexItemFactory, GraphLense previousLense) {
            if (this.typeMap.isEmpty() && this.methodMap.isEmpty() && this.fieldMap.isEmpty()) {
                return previousLense;
            }
            return new NestedGraphLense(this.typeMap, this.methodMap, this.fieldMap, null, null, previousLense, dexItemFactory);
        }
    }

    public static class GraphLenseLookupResult {
        private final DexMethod method;
        private final Invoke.Type type;

        public GraphLenseLookupResult(DexMethod method, Invoke.Type type) {
            this.method = method;
            this.type = type;
        }

        public DexMethod getMethod() {
            return this.method;
        }

        public Invoke.Type getType() {
            return this.type;
        }
    }
}

