/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfPosition;
import com.android.tools.r8.com.google.common.base.Suppliers;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexCode;
import com.android.tools.r8.graph.DexDebugEvent;
import com.android.tools.r8.graph.DexDebugEventBuilder;
import com.android.tools.r8.graph.DexDebugEventVisitor;
import com.android.tools.r8.graph.DexDebugInfo;
import com.android.tools.r8.graph.DexDebugPositionState;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.naming.ClassNaming;
import com.android.tools.r8.naming.MemberNaming;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.naming.Range;
import com.android.tools.r8.utils.DescriptorUtils;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class LineNumberOptimizer {
    public static ClassNameMapper run(DexApplication application, NamingLens namingLens, boolean identityMapping) {
        ClassNameMapper.Builder classNameMapperBuilder = ClassNameMapper.builder();
        for (DexProgramClass clazz : application.classes()) {
            if (!clazz.getSynthesizedFrom().isEmpty()) continue;
            IdentityHashMap<DexString, List<DexEncodedMethod>> methodsByName = LineNumberOptimizer.groupMethodsByName(namingLens, clazz);
            DexString renamedClassName = namingLens.lookupDescriptor(clazz.getType());
            com.android.tools.r8.com.google.common.base.Supplier<ClassNaming.Builder> onDemandClassNamingBuilder = Suppliers.memoize(() -> classNameMapperBuilder.classNamingBuilder(DescriptorUtils.descriptorToJavaType(renamedClassName.toString()), clazz.toString()));
            LineNumberOptimizer.addClassToClassNaming(clazz, renamedClassName, onDemandClassNamingBuilder);
            LineNumberOptimizer.addFieldsToClassNaming(namingLens, clazz, onDemandClassNamingBuilder);
            for (List<DexEncodedMethod> methods : methodsByName.values()) {
                if (methods.size() > 1) {
                    LineNumberOptimizer.sortMethods(methods);
                }
                PositionRemapper positionRemapper = identityMapping ? new IdentityPositionRemapper() : new OptimizingPositionRemapper();
                for (DexEncodedMethod method : methods) {
                    ArrayList<MappedPosition> mappedPositions = new ArrayList<MappedPosition>();
                    Code code = method.getCode();
                    if (code != null) {
                        if (code.isDexCode() && LineNumberOptimizer.doesContainPositions(code.asDexCode())) {
                            LineNumberOptimizer.optimizeDexCodePositions(method, application, positionRemapper, mappedPositions, identityMapping);
                        } else if (code.isCfCode() && LineNumberOptimizer.doesContainPositions(code.asCfCode())) {
                            LineNumberOptimizer.optimizeCfCodePositions(method, positionRemapper, mappedPositions);
                        }
                    }
                    MemberNaming.MethodSignature originalSignature = MemberNaming.MethodSignature.fromDexMethod(method.method);
                    DexString obfuscatedNameDexString = namingLens.lookupName(method.method);
                    String obfuscatedName = obfuscatedNameDexString.toString();
                    if (mappedPositions.isEmpty()) {
                        if (obfuscatedNameDexString == method.method.name) continue;
                        ((ClassNaming.Builder)onDemandClassNamingBuilder.get()).addMappedRange(null, originalSignature, null, obfuscatedName);
                        continue;
                    }
                    IdentityHashMap<DexMethod, MemberNaming.MethodSignature> signatures = new IdentityHashMap<DexMethod, MemberNaming.MethodSignature>();
                    signatures.put(method.method, originalSignature);
                    MemberNaming memberNaming = new MemberNaming(originalSignature, obfuscatedName);
                    ((ClassNaming.Builder)onDemandClassNamingBuilder.get()).addMemberEntry(memberNaming);
                    int i = 0;
                    while (i < mappedPositions.size()) {
                        MappedPosition mp;
                        int j;
                        MappedPosition firstPosition = (MappedPosition)mappedPositions.get(i);
                        MappedPosition lastPosition = firstPosition;
                        for (j = i + 1; j < mappedPositions.size() && (mp = (MappedPosition)mappedPositions.get(j)).method == lastPosition.method && mp.originalLine - lastPosition.originalLine == mp.obfuscatedLine - lastPosition.obfuscatedLine && Objects.equals(mp.caller, lastPosition.caller); ++j) {
                            lastPosition = mp;
                        }
                        Range obfuscatedRange = new Range(firstPosition.obfuscatedLine, lastPosition.obfuscatedLine);
                        Range originalRange = new Range(firstPosition.originalLine, lastPosition.originalLine);
                        ClassNaming.Builder classNamingBuilder = (ClassNaming.Builder)onDemandClassNamingBuilder.get();
                        classNamingBuilder.addMappedRange(obfuscatedRange, signatures.computeIfAbsent(firstPosition.method, m -> MemberNaming.MethodSignature.fromDexMethod(m, ((MappedPosition)firstPosition).method.holder != clazz.getType())), originalRange, obfuscatedName);
                        Position caller = firstPosition.caller;
                        while (caller != null) {
                            Position finalCaller = caller;
                            classNamingBuilder.addMappedRange(obfuscatedRange, signatures.computeIfAbsent(caller.method, m -> MemberNaming.MethodSignature.fromDexMethod(m, finalCaller.method.holder != clazz.getType())), Math.max(caller.line, 0), obfuscatedName);
                            caller = caller.callerPosition;
                        }
                        i = j;
                    }
                }
            }
        }
        return classNameMapperBuilder.build();
    }

    private static int getMethodStartLine(DexEncodedMethod method) {
        Code code = method.getCode();
        if (code == null) {
            return 0;
        }
        if (code.isDexCode()) {
            DexDebugInfo dexDebugInfo = code.asDexCode().getDebugInfo();
            return dexDebugInfo == null ? 0 : dexDebugInfo.startLine;
        }
        if (code.isCfCode()) {
            List<CfInstruction> instructions = code.asCfCode().getInstructions();
            for (CfInstruction instruction : instructions) {
                if (!(instruction instanceof CfPosition)) continue;
                return ((CfPosition)instruction).getPosition().line;
            }
        }
        return 0;
    }

    private static void sortMethods(List<DexEncodedMethod> methods) {
        methods.sort((lhs, rhs) -> {
            int rhsStartLine;
            int lhsStartLine = LineNumberOptimizer.getMethodStartLine(lhs);
            int startLineDiff = lhsStartLine - (rhsStartLine = LineNumberOptimizer.getMethodStartLine(rhs));
            if (startLineDiff != 0) {
                return startLineDiff;
            }
            return DexEncodedMethod.slowCompare(lhs, rhs);
        });
    }

    private static void addClassToClassNaming(DexProgramClass clazz, DexString renamedClassName, Supplier<ClassNaming.Builder> onDemandClassNamingBuilder) {
        if (!clazz.toString().equals(renamedClassName.toString())) {
            onDemandClassNamingBuilder.get();
        }
    }

    private static void addFieldsToClassNaming(NamingLens namingLens, DexProgramClass clazz, Supplier<ClassNaming.Builder> onDemandClassNamingBuilder) {
        clazz.forEachField(dexEncodedField -> {
            DexField dexField = dexEncodedField.field;
            DexString renamedName = namingLens.lookupName(dexField);
            if (renamedName != dexField.name) {
                MemberNaming.FieldSignature signature = new MemberNaming.FieldSignature(dexField.name.toString(), dexField.type.toString());
                MemberNaming memberNaming = new MemberNaming(signature, renamedName.toString());
                ((ClassNaming.Builder)onDemandClassNamingBuilder.get()).addMemberEntry(memberNaming);
            }
        });
    }

    private static IdentityHashMap<DexString, List<DexEncodedMethod>> groupMethodsByName(NamingLens namingLens, DexProgramClass clazz) {
        IdentityHashMap<DexString, List<DexEncodedMethod>> methodsByName = new IdentityHashMap<DexString, List<DexEncodedMethod>>(clazz.directMethods().length + clazz.virtualMethods().length);
        clazz.forEachMethod(method -> {
            if (namingLens.lookupName(method.method) != method.method.name || LineNumberOptimizer.doesContainPositions(method)) {
                methodsByName.compute(method.method.name, (name, methods) -> {
                    if (methods == null) {
                        methods = new ArrayList<DexEncodedMethod>();
                    }
                    methods.add(method);
                    return methods;
                });
            }
        });
        return methodsByName;
    }

    private static boolean doesContainPositions(DexEncodedMethod method) {
        Code code = method.getCode();
        if (code == null) {
            return false;
        }
        if (code.isDexCode()) {
            return LineNumberOptimizer.doesContainPositions(code.asDexCode());
        }
        if (code.isCfCode()) {
            return LineNumberOptimizer.doesContainPositions(code.asCfCode());
        }
        return false;
    }

    private static boolean doesContainPositions(DexCode dexCode) {
        DexDebugInfo debugInfo = dexCode.getDebugInfo();
        if (debugInfo == null) {
            return false;
        }
        for (DexDebugEvent event : debugInfo.events) {
            if (!(event instanceof DexDebugEvent.Default)) continue;
            return true;
        }
        return false;
    }

    private static boolean doesContainPositions(CfCode cfCode) {
        List<CfInstruction> instructions = cfCode.getInstructions();
        for (CfInstruction instruction : instructions) {
            if (!(instruction instanceof CfPosition)) continue;
            return true;
        }
        return false;
    }

    private static void optimizeDexCodePositions(DexEncodedMethod method, DexApplication application, PositionRemapper positionRemapper, List<MappedPosition> mappedPositions, boolean identityMapping) {
        DexCode dexCode = method.getCode().asDexCode();
        DexDebugInfo debugInfo = dexCode.getDebugInfo();
        ArrayList processedEvents = new ArrayList();
        PositionEventEmitter positionEventEmitter = new PositionEventEmitter(application.dexItemFactory, method.method, processedEvents);
        EventFilter eventFilter = new EventFilter(debugInfo.startLine, method.method, processedEvents::add, positionState -> {
            int currentLine = positionState.getCurrentLine();
            assert (currentLine >= 0);
            Position position = positionRemapper.createRemappedPosition(positionState.getCurrentLine(), positionState.getCurrentFile(), positionState.getCurrentMethod(), positionState.getCurrentCallerPosition());
            mappedPositions.add(new MappedPosition(positionState.getCurrentMethod(), currentLine, positionState.getCurrentCallerPosition(), position.line));
            positionEventEmitter.emitPositionEvents(positionState.getCurrentPc(), position);
        });
        for (DexDebugEvent event : debugInfo.events) {
            event.accept(eventFilter);
        }
        DexDebugInfo optimizedDebugInfo = new DexDebugInfo(positionEventEmitter.getStartLine(), debugInfo.parameters, processedEvents.toArray(new DexDebugEvent[processedEvents.size()]));
        if (identityMapping) {
            assert (optimizedDebugInfo.startLine == debugInfo.startLine);
            assert (optimizedDebugInfo.events.length == debugInfo.events.length);
            for (int i = 0; i < debugInfo.events.length; ++i) {
                assert (optimizedDebugInfo.events[i].equals(debugInfo.events[i]));
            }
        }
        dexCode.setDebugInfo(optimizedDebugInfo);
    }

    private static void optimizeCfCodePositions(DexEncodedMethod method, PositionRemapper positionRemapper, List<MappedPosition> mappedPositions) {
        CfCode oldCode = method.getCode().asCfCode();
        List<CfInstruction> oldInstructions = oldCode.getInstructions();
        ArrayList<CfInstruction> newInstructions = new ArrayList<CfInstruction>(oldInstructions.size());
        for (int i = 0; i < oldInstructions.size(); ++i) {
            CfInstruction newInstruction;
            CfInstruction oldInstruction = oldInstructions.get(i);
            if (oldInstruction instanceof CfPosition) {
                CfPosition cfPosition = (CfPosition)oldInstruction;
                Position oldPosition = cfPosition.getPosition();
                Position newPosition = positionRemapper.createRemappedPosition(oldPosition.line, oldPosition.file, oldPosition.method, oldPosition.callerPosition);
                mappedPositions.add(new MappedPosition(oldPosition.method, oldPosition.line, oldPosition.callerPosition, newPosition.line));
                newInstruction = new CfPosition(cfPosition.getLabel(), newPosition);
            } else {
                newInstruction = oldInstruction;
            }
            newInstructions.add(newInstruction);
        }
        method.setCode(new CfCode(oldCode.getMethod(), oldCode.getMaxStack(), oldCode.getMaxLocals(), newInstructions, oldCode.getTryCatchRanges(), oldCode.getLocalVariables()));
    }

    private static class MappedPosition {
        private final DexMethod method;
        private final int originalLine;
        private final Position caller;
        private final int obfuscatedLine;

        private MappedPosition(DexMethod method, int originalLine, Position caller, int obfuscatedLine) {
            this.method = method;
            this.originalLine = originalLine;
            this.caller = caller;
            this.obfuscatedLine = obfuscatedLine;
        }
    }

    private static class PositionEventEmitter {
        private final DexItemFactory dexItemFactory;
        private int startLine = -1;
        private final DexMethod method;
        private int previousPc = -1;
        private Position previousPosition = null;
        private final List<DexDebugEvent> processedEvents;

        private PositionEventEmitter(DexItemFactory dexItemFactory, DexMethod method, List<DexDebugEvent> processedEvents) {
            this.dexItemFactory = dexItemFactory;
            this.method = method;
            this.processedEvents = processedEvents;
        }

        private void emitPositionEvents(int currentPc, Position currentPosition) {
            if (this.previousPosition == null) {
                this.startLine = currentPosition.line;
                this.previousPosition = new Position(this.startLine, null, this.method, null);
            }
            DexDebugEventBuilder.emitAdvancementEvents(this.previousPc, this.previousPosition, currentPc, currentPosition, this.processedEvents, this.dexItemFactory);
            this.previousPc = currentPc;
            this.previousPosition = currentPosition;
        }

        private int getStartLine() {
            assert (this.startLine >= 0);
            return this.startLine;
        }
    }

    private static class OptimizingPositionRemapper
    implements PositionRemapper {
        private int nextLineNumber = 1;

        private OptimizingPositionRemapper() {
        }

        @Override
        public Position createRemappedPosition(int line, DexString file, DexMethod method, Position callerPosition) {
            Position newPosition = new Position(this.nextLineNumber, file, method, null);
            ++this.nextLineNumber;
            return newPosition;
        }
    }

    private static class IdentityPositionRemapper
    implements PositionRemapper {
        private IdentityPositionRemapper() {
        }

        @Override
        public Position createRemappedPosition(int line, DexString file, DexMethod method, Position callerPosition) {
            return new Position(line, file, method, callerPosition);
        }
    }

    private static interface PositionRemapper {
        public Position createRemappedPosition(int var1, DexString var2, DexMethod var3, Position var4);
    }

    private static class EventFilter
    implements DexDebugEventVisitor {
        private final BypassedEventReceiver bypassedEventReceiver;
        private final PositionEventReceiver positionEventReceiver;
        private final DexDebugPositionState positionState;

        private EventFilter(int startLine, DexMethod method, BypassedEventReceiver bypassedEventReceiver, PositionEventReceiver positionEventReceiver) {
            this.positionState = new DexDebugPositionState(startLine, method);
            this.bypassedEventReceiver = bypassedEventReceiver;
            this.positionEventReceiver = positionEventReceiver;
        }

        @Override
        public void visit(DexDebugEvent.SetPrologueEnd event) {
            this.bypassedEventReceiver.receiveBypassedEvent(event);
        }

        @Override
        public void visit(DexDebugEvent.SetEpilogueBegin event) {
            this.bypassedEventReceiver.receiveBypassedEvent(event);
        }

        @Override
        public void visit(DexDebugEvent.StartLocal event) {
            this.bypassedEventReceiver.receiveBypassedEvent(event);
        }

        @Override
        public void visit(DexDebugEvent.EndLocal event) {
            this.bypassedEventReceiver.receiveBypassedEvent(event);
        }

        @Override
        public void visit(DexDebugEvent.RestartLocal event) {
            this.bypassedEventReceiver.receiveBypassedEvent(event);
        }

        @Override
        public void visit(DexDebugEvent.AdvancePC advancePC) {
            this.positionState.visit(advancePC);
        }

        @Override
        public void visit(DexDebugEvent.AdvanceLine advanceLine) {
            this.positionState.visit(advanceLine);
        }

        @Override
        public void visit(DexDebugEvent.SetInlineFrame setInlineFrame) {
            this.positionState.visit(setInlineFrame);
        }

        @Override
        public void visit(DexDebugEvent.Default defaultEvent) {
            this.positionState.visit(defaultEvent);
            this.positionEventReceiver.receivePositionEvent(this.positionState);
        }

        @Override
        public void visit(DexDebugEvent.SetFile setFile) {
            this.positionState.visit(setFile);
        }

        private static interface PositionEventReceiver {
            public void receivePositionEvent(DexDebugPositionState var1);
        }

        private static interface BypassedEventReceiver {
            public void receiveBypassedEvent(DexDebugEvent var1);
        }
    }
}

