/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.DataResource;
import com.android.tools.r8.Keep;
import com.android.tools.r8.origin.ArchiveEntryOrigin;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

@Keep
public interface DataDirectoryResource
extends DataResource {
    public static DataDirectoryResource fromFile(Path dir, Path file) {
        return new LocalDataDirectoryResource(dir.resolve(file).toFile(), file.toString().replace(File.separatorChar, '/'));
    }

    public static DataDirectoryResource fromZip(ZipFile zip2, ZipEntry entry) {
        return new ZipDataDirectoryResource(zip2, entry);
    }

    public static class LocalDataDirectoryResource
    implements DataDirectoryResource {
        private final File file;
        private final String relativePath;

        private LocalDataDirectoryResource(File file, String relativePath) {
            assert (file != null);
            assert (relativePath != null);
            this.file = file;
            this.relativePath = relativePath;
        }

        @Override
        public Origin getOrigin() {
            return new PathOrigin(this.file.toPath());
        }

        @Override
        public String getName() {
            return this.relativePath;
        }
    }

    public static class ZipDataDirectoryResource
    implements DataDirectoryResource {
        private final ZipFile zip;
        private final ZipEntry entry;

        private ZipDataDirectoryResource(ZipFile zip2, ZipEntry entry) {
            assert (zip2 != null);
            assert (entry != null);
            this.zip = zip2;
            this.entry = entry;
        }

        @Override
        public Origin getOrigin() {
            return new ArchiveEntryOrigin(this.entry.getName(), new PathOrigin(Paths.get(this.zip.getName(), new String[0])));
        }

        @Override
        public String getName() {
            return this.entry.getName();
        }
    }
}

