/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dex;

import com.android.tools.r8.DataEntryResource;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.shaking.ProguardPathFilter;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.ExceptionDiagnostic;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.StringDiagnostic;
import java.io.InputStream;
import java.nio.charset.Charset;

public class ResourceAdapter {
    private final DexItemFactory dexItemFactory;
    private final GraphLense graphLense;
    private final NamingLens namingLense;
    private final InternalOptions options;

    public ResourceAdapter(DexItemFactory dexItemFactory, GraphLense graphLense, NamingLens namingLense, InternalOptions options) {
        this.dexItemFactory = dexItemFactory;
        this.graphLense = graphLense;
        this.namingLense = namingLense;
        this.options = options;
    }

    public DataEntryResource adaptFileContentsIfNeeded(DataEntryResource file) {
        ProguardPathFilter filter = this.options.proguardConfiguration.getAdaptResourceFileContents();
        return filter.isEnabled() && !file.getName().toLowerCase().endsWith(".class") && filter.matches(file.getName()) ? this.adaptFileContents(file) : file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DataEntryResource adaptFileContents(DataEntryResource file) {
        try (InputStream in = file.getByteStream();){
            byte[] bytes = ByteStreams.toByteArray(in);
            String contents = new String(bytes, Charset.defaultCharset());
            FileContentsAdapter adapter = new FileContentsAdapter(contents);
            if (!adapter.run()) return file;
            DataEntryResource dataEntryResource = DataEntryResource.fromBytes(adapter.getResult().getBytes(Charset.defaultCharset()), file.getName(), file.getOrigin());
            return dataEntryResource;
        }
        catch (ResourceException e) {
            this.options.reporter.error(new StringDiagnostic("Failed to open input: " + e.getMessage(), file.getOrigin()));
            return file;
        }
        catch (Exception e) {
            this.options.reporter.error(new ExceptionDiagnostic(e, file.getOrigin()));
        }
        return file;
    }

    private class FileContentsAdapter {
        private final String contents;
        private final StringBuilder result = new StringBuilder();
        private boolean changed = false;
        private int outputFrom = 0;
        private int position = 0;

        public FileContentsAdapter(String contents) {
            this.contents = contents;
        }

        public boolean run() {
            do {
                this.handleMisc();
                this.handleJavaType();
            } while (!this.eof());
            if (this.changed) {
                this.outputRangeFromInput(this.outputFrom, this.contents.length());
            } else {
                assert (this.outputFrom == 0);
                assert (this.result.toString().isEmpty());
            }
            return this.changed;
        }

        public String getResult() {
            assert (this.changed);
            return this.result.toString();
        }

        private void handleMisc() {
            while (!this.eof() && !Character.isJavaIdentifierPart(this.contents.charAt(this.position))) {
                ++this.position;
            }
        }

        private void handleJavaType() {
            DexString renamedDescriptor;
            DexType dexType;
            if (this.eof()) {
                return;
            }
            assert (Character.isJavaIdentifierPart(this.contents.charAt(this.position)));
            int start = this.position++;
            while (!this.eof()) {
                char currentChar = this.contents.charAt(this.position);
                if (Character.isJavaIdentifierPart(currentChar)) {
                    ++this.position;
                    continue;
                }
                if (currentChar != '.' || this.eof(this.position + 1) || !Character.isJavaIdentifierPart(this.contents.charAt(this.position + 1))) break;
                this.position += 2;
            }
            if (start > 0 && this.isDashOrDot(this.contents.charAt(start - 1)) || !this.eof(this.position) && this.isDashOrDot(this.contents.charAt(this.position))) {
                return;
            }
            String javaType = this.contents.substring(start, this.position);
            DexString descriptor = ResourceAdapter.this.dexItemFactory.lookupString(DescriptorUtils.javaTypeToDescriptorIgnorePrimitives(javaType));
            DexType dexType2 = dexType = descriptor != null ? ResourceAdapter.this.dexItemFactory.lookupType(descriptor) : null;
            if (dexType != null && !descriptor.equals(renamedDescriptor = ResourceAdapter.this.namingLense.lookupDescriptor(ResourceAdapter.this.graphLense.lookupType(dexType)))) {
                this.outputRangeFromInput(this.outputFrom, start);
                this.outputString(DescriptorUtils.descriptorToJavaType(renamedDescriptor.toSourceString()));
                this.outputFrom = this.position;
                this.changed = true;
            }
        }

        private boolean isDashOrDot(char c) {
            return c == '.' || c == '-';
        }

        private void outputRangeFromInput(int from, int toExclusive) {
            if (from < toExclusive) {
                this.result.append(this.contents.substring(from, toExclusive));
            }
        }

        private void outputString(String s) {
            this.result.append(s);
        }

        private boolean eof() {
            return this.eof(this.position);
        }

        private boolean eof(int position) {
            return position == this.contents.length();
        }
    }
}

