/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.utils.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class ParameterUsagesInfo {
    private ImmutableList<ParameterUsage> parametersUsages;

    public ParameterUsagesInfo(List<ParameterUsage> usages) {
        assert (!usages.isEmpty());
        this.parametersUsages = ImmutableList.copyOf(usages);
        assert (this.parametersUsages.size() == this.parametersUsages.stream().map(usage -> usage.index).collect(Collectors.toSet()).size());
    }

    ParameterUsage getParameterUsage(int parameter) {
        for (ParameterUsage usage : this.parametersUsages) {
            if (usage.index != parameter) continue;
            return usage;
        }
        return null;
    }

    public static class ParameterUsageBuilder {
        private final int index;
        private final Value arg;
        private final Set<If.Type> ifZeroTestTypes = new HashSet<If.Type>();
        private final List<Pair<Invoke.Type, DexMethod>> callsOnReceiver = new ArrayList<Pair<Invoke.Type, DexMethod>>();
        private boolean returnValue = false;

        public ParameterUsageBuilder(Value arg, int index) {
            this.arg = arg;
            this.index = index;
        }

        public boolean note(Instruction instruction) {
            if (instruction.isInvokeMethodWithReceiver() && instruction.inValues().lastIndexOf(this.arg) == 0) {
                this.callsOnReceiver.add(new Pair<Invoke.Type, DexMethod>(instruction.asInvokeMethodWithReceiver().getType(), instruction.asInvokeMethodWithReceiver().getInvokedMethod()));
                return true;
            }
            if (instruction.isIf() && instruction.asIf().isZeroTest()) {
                assert (instruction.inValues().size() == 1 && instruction.inValues().get(0) == this.arg);
                this.ifZeroTestTypes.add(instruction.asIf().getType());
                return true;
            }
            if (instruction.isReturn()) {
                assert (instruction.inValues().size() == 1 && instruction.inValues().get(0) == this.arg);
                this.returnValue = true;
                return true;
            }
            return false;
        }

        public ParameterUsage build() {
            return new ParameterUsage(this.index, this.ifZeroTestTypes, this.callsOnReceiver, this.returnValue);
        }
    }

    public static final class ParameterUsage {
        public final int index;
        public final Set<If.Type> ifZeroTest;
        public final List<Pair<Invoke.Type, DexMethod>> callsReceiver;
        public final boolean returnValue;

        ParameterUsage(int index, Set<If.Type> ifZeroTest, List<Pair<Invoke.Type, DexMethod>> callsReceiver, boolean returnValue) {
            this.index = index;
            this.ifZeroTest = ifZeroTest.isEmpty() ? Collections.emptySet() : ImmutableSet.copyOf(ifZeroTest);
            this.callsReceiver = callsReceiver.isEmpty() ? Collections.emptyList() : ImmutableList.copyOf(callsReceiver);
            this.returnValue = returnValue;
        }

        public boolean notUsed() {
            return this.ifZeroTest == null && this.callsReceiver == null && !this.returnValue;
        }
    }
}

