/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.TypeEnvironment;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.CheckCast;
import com.android.tools.r8.ir.code.DominatorTree;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeInterface;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.NonNull;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.shaking.Enqueuer;
import java.util.IdentityHashMap;
import java.util.ListIterator;
import java.util.Map;

public class Devirtualizer {
    private final Enqueuer.AppInfoWithLiveness appInfo;

    public Devirtualizer(Enqueuer.AppInfoWithLiveness appInfo) {
        this.appInfo = appInfo;
    }

    public void devirtualizeInvokeInterface(IRCode code, TypeEnvironment typeEnvironment, DexType invocationContext) {
        IdentityHashMap<InvokeInterface, InvokeVirtual> devirtualizedCall = new IdentityHashMap<InvokeInterface, InvokeVirtual>();
        DominatorTree dominatorTree = new DominatorTree(code);
        IdentityHashMap castedReceiverCache = new IdentityHashMap();
        ListIterator<BasicBlock> blocks = code.listIterator();
        while (blocks.hasNext()) {
            BasicBlock block = blocks.next();
            InstructionListIterator it = block.listIterator();
            while (it.hasNext()) {
                TypeLatticeElement castTypeLattice;
                Value receiver;
                TypeLatticeElement receiverTypeLattice;
                Inliner.ConstraintWithTarget visibility;
                DexType holderType;
                DexClass holderClass;
                InvokeInterface invoke;
                DexEncodedMethod target;
                InvokeVirtual devirtualizedInvoke;
                NonNull nonNull;
                Instruction origin;
                Instruction current = (Instruction)it.next();
                if (current.isNonNull() && (origin = (nonNull = current.asNonNull()).origin()).isInvokeInterface() && devirtualizedCall.containsKey(origin.asInvokeInterface()) && dominatorTree.dominatedBy(block, (devirtualizedInvoke = (InvokeVirtual)devirtualizedCall.get(origin.asInvokeInterface())).getBlock())) {
                    nonNull.src().replaceSelectiveUsers(devirtualizedInvoke.getReceiver(), ImmutableSet.of(nonNull), ImmutableMap.of());
                }
                if (!current.isInvokeInterface() || (target = (invoke = current.asInvokeInterface()).computeSingleTarget(this.appInfo, typeEnvironment, invocationContext)) == null || (holderClass = this.appInfo.definitionFor(holderType = target.method.getHolder())) == null || holderClass.isInterface() || (visibility = Inliner.ConstraintWithTarget.classIsVisible(invocationContext, holderType, this.appInfo)) == Inliner.ConstraintWithTarget.NEVER) continue;
                InvokeVirtual devirtualizedInvoke2 = new InvokeVirtual(target.method, invoke.outValue(), invoke.inValues());
                it.replaceCurrentInstruction(devirtualizedInvoke2);
                devirtualizedCall.put(invoke, devirtualizedInvoke2);
                if (holderType == invoke.getInvokedMethod().getHolder() || TypeLatticeElement.lessThanOrEqual(this.appInfo, receiverTypeLattice = typeEnvironment.getLatticeElement(receiver = invoke.getReceiver()), castTypeLattice = TypeLatticeElement.fromDexType(holderType, receiverTypeLattice.isNullable()))) continue;
                Value newReceiver = null;
                if (castedReceiverCache.containsKey(receiver) && ((Map)castedReceiverCache.get(receiver)).containsKey(holderType)) {
                    Value cachedReceiver = (Value)((Map)castedReceiverCache.get(receiver)).get(holderType);
                    if (dominatorTree.dominatedBy(block, cachedReceiver.definition.getBlock())) {
                        newReceiver = cachedReceiver;
                    }
                }
                if (newReceiver == null) {
                    BasicBlock blockWithDevirtualizedInvoke;
                    newReceiver = receiver.definition != null ? code.createValue(receiver.outType(), receiver.definition.getLocalInfo()) : code.createValue(receiver.outType());
                    castedReceiverCache.putIfAbsent(receiver, new IdentityHashMap());
                    ((Map)castedReceiverCache.get(receiver)).put(holderType, newReceiver);
                    CheckCast checkCast = new CheckCast(newReceiver, receiver, holderType);
                    checkCast.setPosition(invoke.getPosition());
                    assert (it.peekPrevious() == devirtualizedInvoke2);
                    it.previous();
                    BasicBlock basicBlock = blockWithDevirtualizedInvoke = block.hasCatchHandlers() ? it.split(code, blocks) : block;
                    if (blockWithDevirtualizedInvoke != block) {
                        it = block.listIterator(block.getInstructions().size());
                        it.previous();
                        it.add(checkCast);
                        dominatorTree = new DominatorTree(code);
                        it = blockWithDevirtualizedInvoke.listIterator();
                        assert (it.peekNext() == devirtualizedInvoke2);
                        it.next();
                    } else {
                        it.add(checkCast);
                        assert (it.peekNext() == devirtualizedInvoke2);
                        it.next();
                    }
                }
                receiver.replaceSelectiveUsers(newReceiver, ImmutableSet.of(devirtualizedInvoke2), ImmutableMap.of());
                typeEnvironment.enqueue(newReceiver);
                typeEnvironment.analyze();
            }
        }
        assert (code.isConsistentSSA());
    }
}

