/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dex;

import com.android.tools.r8.DataEntryResource;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntArrayList;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntStack;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.shaking.ProguardPathFilter;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.ExceptionDiagnostic;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.StringDiagnostic;
import java.io.InputStream;
import java.nio.charset.Charset;

public class ResourceAdapter {
    private final DexItemFactory dexItemFactory;
    private final GraphLense graphLense;
    private final NamingLens namingLense;
    private final InternalOptions options;

    public ResourceAdapter(DexItemFactory dexItemFactory, GraphLense graphLense, NamingLens namingLense, InternalOptions options) {
        this.dexItemFactory = dexItemFactory;
        this.graphLense = graphLense;
        this.namingLense = namingLense;
        this.options = options;
    }

    public DataEntryResource adaptIfNeeded(DataEntryResource file) {
        byte[] contents;
        String name;
        ProguardPathFilter adaptResourceFileNamesFilter = this.options.proguardConfiguration.getAdaptResourceFilenames();
        String string = name = adaptResourceFileNamesFilter.isEnabled() && !file.getName().toLowerCase().endsWith(".class") && adaptResourceFileNamesFilter.matches(file.getName()) ? this.adaptFilename(file) : file.getName();
        assert (name != null);
        ProguardPathFilter adaptResourceFileContentsFilter = this.options.proguardConfiguration.getAdaptResourceFileContents();
        byte[] byArray = contents = adaptResourceFileContentsFilter.isEnabled() && !file.getName().toLowerCase().endsWith(".class") && adaptResourceFileContentsFilter.matches(file.getName()) ? this.adaptFileContents(file) : null;
        if (contents != null) {
            return DataEntryResource.fromBytes(contents, name, file.getOrigin());
        }
        if (!name.equals(file.getName())) {
            return file.withName(name);
        }
        return file;
    }

    private String adaptFilename(DataEntryResource file) {
        FilenameAdapter adapter = new FilenameAdapter(file.getName());
        if (adapter.run()) {
            return adapter.getResult();
        }
        return file.getName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] adaptFileContents(DataEntryResource file) {
        try (InputStream in = file.getByteStream();){
            byte[] bytes = ByteStreams.toByteArray(in);
            String contents = new String(bytes, Charset.defaultCharset());
            FileContentsAdapter adapter = new FileContentsAdapter(contents);
            if (!adapter.run()) return null;
            byte[] byArray = adapter.getResult().getBytes(Charset.defaultCharset());
            return byArray;
        }
        catch (ResourceException e) {
            this.options.reporter.error(new StringDiagnostic("Failed to open input: " + e.getMessage(), file.getOrigin()));
            return null;
        }
        catch (Exception e) {
            this.options.reporter.error(new ExceptionDiagnostic(e, file.getOrigin()));
        }
        return null;
    }

    private class FilenameAdapter
    extends StringAdapter {
        public FilenameAdapter(String filename) {
            super(filename);
        }

        @Override
        public char getClassNameSeparator() {
            return '/';
        }

        @Override
        public boolean allowRenamingOfPrefixes() {
            return true;
        }

        @Override
        public boolean shouldRecordPrefix(char c) {
            return !Character.isLetterOrDigit(c);
        }

        @Override
        protected boolean handlePrefix(int from, int toExclusive) {
            assert (!this.eof(toExclusive));
            if (this.contents.charAt(toExclusive) == '/') {
                return this.renameJavaPackageInRange(from, toExclusive);
            }
            return this.renameJavaTypeInRange(from, toExclusive);
        }

        @Override
        public boolean isRenamingCandidate(int from, int toExclusive) {
            return from == 0 && !this.eof(toExclusive);
        }
    }

    private class FileContentsAdapter
    extends StringAdapter {
        public FileContentsAdapter(String fileContents) {
            super(fileContents);
        }

        @Override
        public char getClassNameSeparator() {
            return '.';
        }

        @Override
        public boolean allowRenamingOfPrefixes() {
            return false;
        }

        @Override
        public boolean shouldRecordPrefix(char c) {
            throw new Unreachable();
        }

        @Override
        protected boolean handlePrefix(int from, int toExclusive) {
            throw new Unreachable();
        }

        @Override
        public boolean isRenamingCandidate(int from, int toExclusive) {
            return !(from > 0 && this.isDashOrDot(this.contents.charAt(from - 1)) || !this.eof(toExclusive) && this.isDashOrDot(this.contents.charAt(toExclusive)));
        }

        private boolean isDashOrDot(char c) {
            return c == '.' || c == '-';
        }
    }

    private abstract class StringAdapter {
        protected final String contents;
        private final StringBuilder result = new StringBuilder();
        private boolean changed = false;
        private int outputFrom = 0;
        private int position = 0;
        private final IntStack prefixEndPositionsExclusive;

        public StringAdapter(String contents) {
            this.contents = contents;
            this.prefixEndPositionsExclusive = this.allowRenamingOfPrefixes() ? new IntArrayList() : null;
        }

        public boolean run() {
            do {
                this.handleMisc();
                this.handleJavaType();
            } while (!this.eof());
            if (this.changed) {
                this.outputRangeFromInput(this.outputFrom, this.contents.length());
            } else {
                assert (this.outputFrom == 0);
                assert (this.result.toString().isEmpty());
            }
            return this.changed;
        }

        public String getResult() {
            assert (this.changed);
            return this.result.toString();
        }

        private void handleMisc() {
            while (!this.eof() && !Character.isJavaIdentifierPart(this.contents.charAt(this.position))) {
                ++this.position;
            }
        }

        private void handleJavaType() {
            boolean renamingSucceeded;
            if (this.eof()) {
                return;
            }
            assert (!this.allowRenamingOfPrefixes() || this.prefixEndPositionsExclusive.isEmpty());
            assert (Character.isJavaIdentifierPart(this.contents.charAt(this.position)));
            int start = this.position++;
            while (!this.eof()) {
                char currentChar = this.contents.charAt(this.position);
                if (Character.isJavaIdentifierPart(currentChar)) {
                    if (this.allowRenamingOfPrefixes() && this.shouldRecordPrefix(currentChar) && this.isRenamingCandidate(start, this.position)) {
                        this.prefixEndPositionsExclusive.push(this.position);
                    }
                    ++this.position;
                    continue;
                }
                if (currentChar != this.getClassNameSeparator() || this.eof(this.position + 1) || !Character.isJavaIdentifierPart(this.contents.charAt(this.position + 1))) break;
                if (this.allowRenamingOfPrefixes() && this.shouldRecordPrefix(currentChar) && this.isRenamingCandidate(start, this.position)) {
                    this.prefixEndPositionsExclusive.push(this.position);
                }
                this.position += 2;
            }
            boolean bl = renamingSucceeded = this.isRenamingCandidate(start, this.position) && this.renameJavaTypeInRange(start, this.position);
            if (!renamingSucceeded && this.allowRenamingOfPrefixes()) {
                while (!this.prefixEndPositionsExclusive.isEmpty() && !renamingSucceeded) {
                    int prefixEndExclusive = this.prefixEndPositionsExclusive.popInt();
                    assert (this.isRenamingCandidate(start, prefixEndExclusive));
                    renamingSucceeded = this.handlePrefix(start, prefixEndExclusive);
                }
            }
            if (this.allowRenamingOfPrefixes()) {
                while (!this.prefixEndPositionsExclusive.isEmpty()) {
                    this.prefixEndPositionsExclusive.popInt();
                }
            }
        }

        protected boolean renameJavaTypeInRange(int from, int toExclusive) {
            DexString renamedDescriptor;
            DexString descriptor;
            DexType dexType;
            String javaType = this.contents.substring(from, toExclusive);
            if (this.getClassNameSeparator() != '.') {
                javaType = javaType.replace(this.getClassNameSeparator(), '.');
            }
            DexType dexType2 = dexType = (descriptor = ResourceAdapter.this.dexItemFactory.lookupString(DescriptorUtils.javaTypeToDescriptorIgnorePrimitives(javaType))) != null ? ResourceAdapter.this.dexItemFactory.lookupType(descriptor) : null;
            if (dexType != null && !descriptor.equals(renamedDescriptor = ResourceAdapter.this.namingLense.lookupDescriptor(ResourceAdapter.this.graphLense.lookupType(dexType)))) {
                String renamedJavaType = DescriptorUtils.descriptorToJavaType(renamedDescriptor.toSourceString());
                this.outputRangeFromInput(this.outputFrom, from);
                this.outputJavaType(this.getClassNameSeparator() != '.' ? renamedJavaType.replace('.', this.getClassNameSeparator()) : renamedJavaType);
                this.outputFrom = toExclusive;
                this.changed = true;
                return true;
            }
            return false;
        }

        protected boolean renameJavaPackageInRange(int from, int toExclusive) {
            String minifiedJavaPackage;
            String javaPackage = this.contents.substring(from, toExclusive);
            if (this.getClassNameSeparator() != '/') {
                javaPackage = javaPackage.replace(this.getClassNameSeparator(), '/');
            }
            if (!javaPackage.equals(minifiedJavaPackage = ResourceAdapter.this.namingLense.lookupPackageName(javaPackage))) {
                this.outputRangeFromInput(this.outputFrom, from);
                this.outputJavaType(this.getClassNameSeparator() != '/' ? minifiedJavaPackage.replace('/', this.getClassNameSeparator()) : minifiedJavaPackage);
                this.outputFrom = toExclusive;
                this.changed = true;
                return true;
            }
            return false;
        }

        protected abstract char getClassNameSeparator();

        protected abstract boolean allowRenamingOfPrefixes();

        protected abstract boolean shouldRecordPrefix(char var1);

        protected abstract boolean handlePrefix(int var1, int var2);

        protected abstract boolean isRenamingCandidate(int var1, int var2);

        private void outputRangeFromInput(int from, int toExclusive) {
            if (from < toExclusive) {
                this.result.append(this.contents.substring(from, toExclusive));
            }
        }

        private void outputJavaType(String s) {
            this.result.append(s);
        }

        protected boolean eof() {
            return this.eof(this.position);
        }

        protected boolean eof(int position) {
            return position == this.contents.length();
        }
    }
}

