/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.ir.code.Position;
import java.util.HashMap;
import java.util.Map;

public class CanonicalPositions {
    private final Position callerPosition;
    private final boolean preserveCaller;
    private final Map<Position, Position> canonicalPositions;
    private final Position preamblePosition;

    public CanonicalPositions(Position callerPosition, boolean preserveCaller, int expectedPositionsCount, DexMethod method) {
        this.canonicalPositions = new HashMap<Position, Position>(1 + (callerPosition == null ? 0 : 1) + expectedPositionsCount);
        this.preserveCaller = preserveCaller;
        this.callerPosition = callerPosition;
        if (callerPosition != null) {
            this.canonicalPositions.put(callerPosition, callerPosition);
        }
        this.preamblePosition = callerPosition == null ? Position.synthetic(0, method, null) : new Position(0, null, method, callerPosition);
        this.canonicalPositions.put(this.preamblePosition, this.preamblePosition);
    }

    public Position getPreamblePosition() {
        return this.preamblePosition;
    }

    public Position getCanonical(Position position) {
        Position canonical = this.canonicalPositions.putIfAbsent(position, position);
        return canonical != null ? canonical : position;
    }

    public Position canonicalizeCallerPosition(Position caller) {
        if (!this.preserveCaller) {
            return null;
        }
        if (caller == null) {
            return this.callerPosition;
        }
        if (caller.callerPosition == null && this.callerPosition == null) {
            return this.getCanonical(caller);
        }
        Position callerOfCaller = this.canonicalizeCallerPosition(caller.callerPosition);
        return this.getCanonical(caller.isNone() ? Position.noneWithMethod(caller.method, callerOfCaller) : new Position(caller.line, caller.file, caller.method, callerOfCaller));
    }
}

