/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.code.Format11x;
import com.android.tools.r8.code.MoveResult;
import com.android.tools.r8.code.MoveResultObject;
import com.android.tools.r8.code.MoveResultWide;
import com.android.tools.r8.code.MoveType;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InvokeCustom;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.InvokeInterface;
import com.android.tools.r8.ir.code.InvokeMultiNewArray;
import com.android.tools.r8.ir.code.InvokeNewArray;
import com.android.tools.r8.ir.code.InvokePolymorphic;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.code.InvokeSuper;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.DexBuilder;
import java.util.List;
import java.util.function.Function;

public abstract class Invoke
extends Instruction {
    public Invoke(Value result, List<Value> arguments) {
        super(result, arguments);
    }

    public static Invoke create(Type type, DexItem target, DexProto proto, Value result, List<Value> arguments) {
        return Invoke.create(type, target, proto, result, arguments, false);
    }

    public static Invoke create(Type type, DexItem target, DexProto proto, Value result, List<Value> arguments, boolean itf) {
        switch (type) {
            case DIRECT: {
                return new InvokeDirect((DexMethod)target, result, arguments, itf);
            }
            case INTERFACE: {
                return new InvokeInterface((DexMethod)target, result, arguments);
            }
            case STATIC: {
                return new InvokeStatic((DexMethod)target, result, arguments, itf);
            }
            case SUPER: {
                return new InvokeSuper((DexMethod)target, result, arguments, itf);
            }
            case VIRTUAL: {
                return new InvokeVirtual((DexMethod)target, result, arguments);
            }
            case NEW_ARRAY: {
                return new InvokeNewArray((DexType)target, result, arguments);
            }
            case MULTI_NEW_ARRAY: {
                return new InvokeMultiNewArray((DexType)target, result, arguments);
            }
            case CUSTOM: {
                throw new Unreachable("Use InvokeCustom constructor instead");
            }
            case POLYMORPHIC: {
                return new InvokePolymorphic((DexMethod)target, proto, result, arguments);
            }
        }
        throw new Unreachable("Unknown invoke type: " + (Object)((Object)type));
    }

    public static Instruction createFromTemplate(Invoke template, Value outValue, List<Value> inValues) {
        if (template.isInvokeMethod()) {
            return Invoke.create(template.getType(), template.asInvokeMethod().getInvokedMethod(), template.isInvokePolymorphic() ? template.asInvokePolymorphic().getProto() : null, outValue, inValues);
        }
        if (template.isInvokeNewArray()) {
            return new InvokeNewArray(template.asInvokeNewArray().getArrayType(), outValue, inValues);
        }
        assert (template.isInvokeCustom());
        InvokeCustom custom = template.asInvokeCustom();
        return new InvokeCustom(custom.getCallSite(), outValue, inValues);
    }

    public abstract Type getType();

    public abstract DexType getReturnType();

    public List<Value> arguments() {
        return this.inValues;
    }

    public int requiredArgumentRegisters() {
        int registers = 0;
        for (Value inValue : this.inValues) {
            registers += inValue.requiredRegisters();
        }
        return registers;
    }

    protected int argumentRegisterValue(int i, DexBuilder builder) {
        assert (this.needsRangedInvoke(builder));
        if (i < this.arguments().size()) {
            return builder.argumentOrAllocateRegister(this.arguments().get(i), this.getNumber());
        }
        return 0;
    }

    protected int fillArgumentRegisters(DexBuilder builder, int[] registers) {
        assert (!this.needsRangedInvoke(builder));
        int i = 0;
        for (Value value : this.arguments()) {
            int register = builder.argumentOrAllocateRegister(value, this.getNumber());
            if (register + value.requiredRegisters() - 1 > 15) {
                register = builder.allocatedRegister(value, this.getNumber());
            }
            assert (register + value.requiredRegisters() - 1 <= 15);
            for (int j = 0; j < value.requiredRegisters(); ++j) {
                assert (i < 5);
                registers[i++] = register++;
            }
        }
        return i;
    }

    protected boolean argumentsConsecutive(DexBuilder builder) {
        Value value = this.arguments().get(0);
        int next = builder.argumentOrAllocateRegister(value, this.getNumber()) + value.requiredRegisters();
        for (int i = 1; i < this.arguments().size(); ++i) {
            value = this.arguments().get(i);
            assert (next == builder.argumentOrAllocateRegister(value, this.getNumber()));
            next += value.requiredRegisters();
        }
        return true;
    }

    protected void addInvokeAndMoveResult(com.android.tools.r8.code.Instruction instruction, DexBuilder builder) {
        if (this.outValue != null && this.outValue.needsRegister()) {
            Format11x moveResult;
            MoveType moveType = MoveType.fromValueType(this.outType());
            int register = builder.allocatedRegister(this.outValue, this.getNumber());
            switch (moveType) {
                case SINGLE: {
                    moveResult = new MoveResult(register);
                    break;
                }
                case WIDE: {
                    moveResult = new MoveResultWide(register);
                    break;
                }
                case OBJECT: {
                    moveResult = new MoveResultObject(register);
                    break;
                }
                default: {
                    throw new Unreachable("Unexpected result type " + (Object)((Object)this.outType()));
                }
            }
            builder.add((Instruction)this, instruction, moveResult);
        } else {
            builder.add((Instruction)this, instruction);
        }
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public int maxInValueRegister() {
        if (this.arguments().size() == 1 || this.requiredArgumentRegisters() > 5 || this.argumentsAreConsecutiveInputArguments()) {
            return 65535;
        }
        return 15;
    }

    private boolean argumentsAreConsecutiveInputArguments() {
        if (this.arguments().size() == 0) {
            return false;
        }
        Value current = this.arguments().get(0);
        if (!current.isArgument()) {
            return false;
        }
        for (int i = 1; i < this.arguments().size(); ++i) {
            Value next = this.arguments().get(i);
            if (current.getNextConsecutive() != next) {
                return false;
            }
            current = next;
        }
        return true;
    }

    protected boolean needsRangedInvoke(DexBuilder builder) {
        boolean registersGuaranteedToBeConsecutive;
        if (this.requiredArgumentRegisters() > 5) {
            return true;
        }
        boolean bl = registersGuaranteedToBeConsecutive = this.arguments().size() == 1 || this.argumentsAreConsecutiveInputArguments();
        if (!registersGuaranteedToBeConsecutive) {
            return false;
        }
        assert (this.argumentsConsecutive(builder));
        int registerStart = builder.argumentOrAllocateRegister(this.arguments().get(0), this.getNumber());
        int registerEnd = registerStart + this.requiredArgumentRegisters() - 1;
        return registerEnd > 15;
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    protected abstract String getTypeString();

    @Override
    public String getInstructionName() {
        return "Invoke-" + this.getTypeString();
    }

    @Override
    public boolean isInvoke() {
        return true;
    }

    @Override
    public Invoke asInvoke() {
        return this;
    }

    @Override
    public TypeLatticeElement evaluate(AppInfo appInfo, Function<Value, TypeLatticeElement> getLatticeElement) {
        DexType returnType = this.getReturnType();
        if (returnType.isVoidType()) {
            throw new Unreachable("void methods have no type.");
        }
        return TypeLatticeElement.fromDexType(returnType, true);
    }

    public static enum Type {
        DIRECT,
        INTERFACE,
        STATIC,
        SUPER,
        VIRTUAL,
        NEW_ARRAY,
        MULTI_NEW_ARRAY,
        CUSTOM,
        POLYMORPHIC;


        public DexMethodHandle.MethodHandleType toMethodHandle(DexMethod targetMethod) {
            switch (this) {
                case STATIC: {
                    return DexMethodHandle.MethodHandleType.INVOKE_STATIC;
                }
                case VIRTUAL: {
                    return DexMethodHandle.MethodHandleType.INVOKE_INSTANCE;
                }
                case DIRECT: {
                    if (targetMethod.name.toString().equals("<init>")) {
                        return DexMethodHandle.MethodHandleType.INVOKE_CONSTRUCTOR;
                    }
                    return DexMethodHandle.MethodHandleType.INVOKE_DIRECT;
                }
                case INTERFACE: {
                    return DexMethodHandle.MethodHandleType.INVOKE_INTERFACE;
                }
                case SUPER: {
                    return DexMethodHandle.MethodHandleType.INVOKE_SUPER;
                }
            }
            throw new Unreachable("Conversion to method handle with unexpected invoke type: " + (Object)((Object)this));
        }
    }
}

