/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.errors.InvalidDebugInfoException;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.JarApplicationReader;
import com.android.tools.r8.ir.conversion.JarSourceCode;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceAVLTreeMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceSortedMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntIterator;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntSet;
import com.android.tools.r8.org.objectweb.asm.Type;
import com.android.tools.r8.org.objectweb.asm.tree.LocalVariableNode;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class JarState {
    public static final Type REFERENCE_TYPE = Type.getObjectType("<any reference>");
    public static final Type OBJECT_TYPE = Type.getObjectType("<any object>");
    public static final Type ARRAY_TYPE = Type.getObjectType("[<any array>");
    public static final Type NULL_TYPE = Type.getObjectType("<null>");
    public static final Type BYTE_OR_BOOL_TYPE = null;
    final int startOfStack;
    private int topOfStack;
    private final int localsSize;
    private final Local[] locals;
    private final LocalNodeEquivalence localNodeEquivalence = new LocalNodeEquivalence();
    private final Map<Equivalence.Wrapper<LocalVariableNode>, DebugLocalInfo> canonicalLocalInfo;
    private final Int2ReferenceSortedMap<LocalsAtOffset> localsAtOffsetTable;
    private final Deque<Slot> stack = new ArrayDeque<Slot>();
    private final Map<Integer, Snapshot> targetStates = new HashMap<Integer, Snapshot>();
    private boolean building = false;
    private List<Pair<Integer, Type>> writes = new ArrayList<Pair<Integer, Type>>();
    private List<Local> localsToOpen = new ArrayList<Local>();
    private List<Local> localsToClose = new ArrayList<Local>();

    public JarState(int maxLocals, List localNodes, JarSourceCode source, JarApplicationReader application) {
        int localsRegistersSize = maxLocals * 3;
        this.localsSize = maxLocals;
        this.locals = new Local[localsRegistersSize];
        this.topOfStack = this.startOfStack = localsRegistersSize;
        this.localsAtOffsetTable = new Int2ReferenceAVLTreeMap<LocalsAtOffset>();
        this.localsAtOffsetTable.put(-1, LocalsAtOffset.EMPTY);
        if (localNodes.size() == 0) {
            this.canonicalLocalInfo = Collections.emptyMap();
        } else if (localNodes.size() == 1) {
            LocalVariableNode local = (LocalVariableNode)localNodes.get(0);
            DebugLocalInfo info = JarState.createLocalInfo(local, application);
            this.canonicalLocalInfo = Collections.singletonMap(this.localNodeEquivalence.wrap(local), info);
            this.populateLocalsAtTable(local, info, source);
        } else {
            this.canonicalLocalInfo = new HashMap<Equivalence.Wrapper<LocalVariableNode>, DebugLocalInfo>(localNodes.size());
            for (Object o : localNodes) {
                LocalVariableNode node = (LocalVariableNode)o;
                Equivalence.Wrapper<LocalVariableNode> wrapped = this.localNodeEquivalence.wrap(node);
                DebugLocalInfo info = this.canonicalLocalInfo.get(wrapped);
                if (info == null) {
                    info = JarState.createLocalInfo(node, application);
                    this.canonicalLocalInfo.put(wrapped, info);
                }
                this.populateLocalsAtTable(node, info, source);
            }
        }
    }

    private static DebugLocalInfo createLocalInfo(LocalVariableNode node, JarApplicationReader application) {
        return new DebugLocalInfo(application.getString(node.name), application.getTypeFromDescriptor(node.desc), node.signature == null ? null : application.getString(node.signature));
    }

    private void populateLocalsAtTable(LocalVariableNode node, DebugLocalInfo info, JarSourceCode source) {
        LocalsAtOffset atEnd;
        LocalsAtOffset atStart;
        if (node.start == node.end) {
            return;
        }
        int start = source.getOffset(node.start);
        int end = source.getOffset(node.end);
        if (start == -1 || end == -1) {
            throw new InvalidDebugInfoException("Locals information for '" + node.name + "' has undefined start or end point.");
        }
        int lastOrStart = this.localsAtOffsetTable.headMap(start + 1).lastIntKey();
        if (lastOrStart < start) {
            atStart = new LocalsAtOffset((LocalsAtOffset)this.localsAtOffsetTable.get(lastOrStart));
            this.localsAtOffsetTable.put(start, atStart);
        } else {
            atStart = (LocalsAtOffset)this.localsAtOffsetTable.get(start);
        }
        atStart.addStart(node, info);
        int lastOrEnd = this.localsAtOffsetTable.headMap(end + 1).lastIntKey();
        if (lastOrEnd < end) {
            atEnd = new LocalsAtOffset((LocalsAtOffset)this.localsAtOffsetTable.get(lastOrEnd));
            this.localsAtOffsetTable.put(end, atEnd);
        } else {
            atEnd = (LocalsAtOffset)this.localsAtOffsetTable.get(end);
        }
        atEnd.addEnd(node, info);
        for (LocalsAtOffset entry : this.localsAtOffsetTable.subMap(start, end).values()) {
            entry.addLive(node, info);
        }
    }

    public List<Local> localsNotLiveAtAllSuccessors(IntSet successors) {
        Local[] liveLocals = Arrays.copyOf(this.locals, this.locals.length);
        ArrayList<Local> deadLocals = new ArrayList<Local>(this.locals.length);
        IntIterator it = successors.iterator();
        while (it.hasNext()) {
            LocalsAtOffset localsAtOffset = this.getLocalsAt(it.nextInt());
            for (int i = 0; i < liveLocals.length; ++i) {
                Local live = liveLocals[i];
                if (live == null || live.info == null || localsAtOffset.isLive(live.info)) continue;
                deadLocals.add(live);
                liveLocals[i] = null;
            }
        }
        return deadLocals;
    }

    private LocalsAtOffset getLocalsAt(int offset) {
        return offset < 0 ? LocalsAtOffset.EMPTY : (LocalsAtOffset)this.localsAtOffsetTable.get(this.localsAtOffsetTable.headMap(offset + 1).lastIntKey());
    }

    public void setBuilding() {
        assert (this.stack.isEmpty());
        this.building = true;
        for (int i = 0; i < this.locals.length; ++i) {
            Local local = this.locals[i];
            if (local == null || local.slot.type != BYTE_OR_BOOL_TYPE) continue;
            this.locals[i] = new Local(new Slot(local.slot.register, Type.BYTE_TYPE), local.info);
        }
        for (Map.Entry<Integer, Snapshot> entry : this.targetStates.entrySet()) {
            Local[] locals = entry.getValue().locals;
            for (int i = 0; i < locals.length; ++i) {
                Local local = locals[i];
                if (local == null || local.slot.type != BYTE_OR_BOOL_TYPE) continue;
                locals[i] = new Local(new Slot(local.slot.register, Type.BYTE_TYPE), local.info);
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            boolean found = false;
            for (Slot slot : entry.getValue().stack) {
                if (slot.type == BYTE_OR_BOOL_TYPE) {
                    found = true;
                    builder.add(new Slot(slot.register, Type.BYTE_TYPE));
                    continue;
                }
                builder.add(slot);
            }
            if (!found) continue;
            entry.setValue(new Snapshot(locals, (ImmutableList<Slot>)builder.build()));
        }
    }

    public void beginTransaction(int offset, boolean hasNextInstruction) {
        this.getLocalsToClose(offset);
        if (hasNextInstruction) {
            this.getLocalsToOpen(offset);
        } else {
            assert (this.localsToOpen.isEmpty());
            this.localsToOpen.clear();
        }
        assert (this.writes.isEmpty());
        this.writes.clear();
    }

    public void beginTransactionSynthetic() {
        assert (this.localsToClose.isEmpty());
        assert (this.localsToOpen.isEmpty());
        assert (this.writes.isEmpty());
        this.writes.clear();
    }

    public void endTransaction() {
        this.closeLocals();
        this.applyWrites();
        this.openLocals();
    }

    public void beginTransactionAtBlockStart(int offset) {
        assert (this.localsToClose.isEmpty());
        assert (this.writes.isEmpty());
        this.getLocalsToOpen(offset);
    }

    private void applyWrites() {
        for (Pair<Integer, Type> write : this.writes) {
            this.applyWriteLocal(write.getFirst(), write.getSecond());
        }
        this.writes.clear();
    }

    private void getLocalsToOpen(int offset) {
        assert (this.localsToOpen.isEmpty());
        LocalsAtOffset localsAtOffset = (LocalsAtOffset)this.localsAtOffsetTable.get(offset);
        if (localsAtOffset == null) {
            return;
        }
        for (LocalNodeInfo start : localsAtOffset.starts) {
            int register = this.getLocalRegister(start.node.index, start.type);
            Local existingLocal = this.getLocalForRegister(register);
            assert (existingLocal != null);
            Local local = new Local(existingLocal.slot, start.info);
            this.localsToOpen.add(local);
        }
    }

    private void openLocals() {
        for (Local local : this.localsToOpen) {
            assert (local != null);
            this.openLocal(local);
        }
        this.localsToOpen.clear();
    }

    private void getLocalsToClose(int offset) {
        assert (this.localsToClose.isEmpty());
        LocalsAtOffset localsAtOffset = (LocalsAtOffset)this.localsAtOffsetTable.get(offset);
        if (localsAtOffset == null) {
            return;
        }
        for (LocalNodeInfo end : localsAtOffset.ends) {
            int register = this.getLocalRegister(end.node.index, end.type);
            Local local = this.getLocalForRegister(register);
            assert (local != null);
            if (local.info == null) continue;
            this.localsToClose.add(local);
        }
    }

    private void closeLocals() {
        for (Local localToClose : this.localsToClose) {
            assert (localToClose != null);
            Local local = this.getLocalForRegister(localToClose.slot.register);
            this.setLocalForRegister(local.slot.register, local.slot.type, null);
        }
        this.localsToClose.clear();
    }

    private LocalsAtOffset getLocalsAtOffset(int offset) {
        Int2ReferenceSortedMap<LocalsAtOffset> headMap = this.localsAtOffsetTable.headMap(offset + 1);
        return (LocalsAtOffset)this.localsAtOffsetTable.get(headMap.lastIntKey());
    }

    public LocalChangeAtOffset getLocalChange(int predecessorIndex, int successorIndex) {
        return new LocalChangeAtOffset(this.getLocalsAtOffset(predecessorIndex), this.getLocalsAtOffset(successorIndex), this);
    }

    public List<Local> getLocalsToClose() {
        return this.localsToClose;
    }

    public List<Local> getLocalsToOpen() {
        return this.localsToOpen;
    }

    public ImmutableList<Local> getLocals() {
        ImmutableList.Builder nonNullLocals = ImmutableList.builder();
        for (Local local : this.locals) {
            if (local == null) continue;
            nonNullLocals.add(local);
        }
        return nonNullLocals.build();
    }

    int getLocalRegister(int index, Type type) {
        assert (index < this.localsSize);
        if (type == BYTE_OR_BOOL_TYPE) {
            assert (Slot.isCategory1(type));
            return index + this.localsSize;
        }
        if (type.getSort() == 10 || type.getSort() == 9) {
            return index;
        }
        return Slot.isCategory1(type) ? index + this.localsSize : index + 2 * this.localsSize;
    }

    public DebugLocalInfo getIncomingLocalInfoForRegister(int register) {
        if (register >= this.locals.length) {
            return null;
        }
        Local local = this.getLocalForRegister(register);
        return local == null ? null : local.info;
    }

    public DebugLocalInfo getOutgoingLocalInfoForRegister(int register) {
        DebugLocalInfo local = this.getIncomingLocalInfoForRegister(register);
        if (local != null && this.localsToClose != null) {
            for (Local localToClose : this.localsToClose) {
                if (localToClose.slot.register != register) continue;
                local = null;
                break;
            }
        }
        if (local == null && this.localsToOpen != null) {
            for (Local localToOpen : this.localsToOpen) {
                if (localToOpen.slot.register != register) continue;
                local = localToOpen.info;
                break;
            }
        }
        return local;
    }

    private Local getLocalForRegister(int register) {
        return this.locals[register];
    }

    private Local getLocal(int index, Type type) {
        return this.getLocalForRegister(this.getLocalRegister(index, type));
    }

    private Local setLocal(int index, Type type, DebugLocalInfo info) {
        return this.setLocalForRegister(this.getLocalRegister(index, type), type, info);
    }

    private Local setLocalForRegister(int register, Type type, DebugLocalInfo info) {
        Local local;
        Slot slot = new Slot(register, type);
        this.locals[register] = local = new Local(slot, info);
        return local;
    }

    private void openLocal(Local localToOpen) {
        int register = localToOpen.slot.register;
        DebugLocalInfo info = localToOpen.info;
        Local local = this.getLocalForRegister(register);
        Type type = Type.getType(info.type.toDescriptorString());
        if (!local.slot.isCompatibleWith(type)) {
            throw new InvalidDebugInfoException("Attempt to define local of type " + this.prettyType(local.slot.type) + " as " + info);
        }
        this.locals[register] = new Local(local.slot, localToOpen.info);
    }

    public int writeLocal(int index, Type type) {
        this.writes.add(new Pair<Integer, Type>(index, type));
        return this.getLocalRegister(index, type);
    }

    private void applyWriteLocal(int index, Type type) {
        assert (this.nonNullType(type));
        Local local = this.getLocal(index, type);
        if (local != null && local.info != null && !local.slot.isCompatibleWith(type)) {
            throw new InvalidDebugInfoException("Attempt to write value of type " + this.prettyType(type) + " to local " + local.info);
        }
        if (local == null || !this.typeEquals(local.slot.type, type)) {
            DebugLocalInfo info = local == null ? null : local.info;
            this.setLocal(index, type, info);
        }
    }

    public boolean typeEquals(Type type1, Type type2) {
        return type1 == BYTE_OR_BOOL_TYPE && type2 == BYTE_OR_BOOL_TYPE || type1 != null && type1.equals(type2);
    }

    public Slot readLocal(int index, Type type) {
        Local local = this.getLocal(index, type);
        assert (local != null);
        if (local.info != null && !local.slot.isCompatibleWith(type)) {
            throw new InvalidDebugInfoException("Attempt to read value of type " + this.prettyType(type) + " from local " + local.info);
        }
        assert (local.slot.isCompatibleWith(type));
        return local.slot;
    }

    public boolean nonNullType(Type type) {
        return type != null || !this.building;
    }

    public int push(Type type) {
        assert (this.nonNullType(type));
        int top = this.topOfStack;
        this.topOfStack += 2;
        Slot slot = new Slot(top, type);
        this.stack.push(slot);
        return top;
    }

    public Slot peek() {
        return this.stack.peek();
    }

    public Slot peek(Type type) {
        Slot slot = this.stack.peek();
        assert (slot.isCompatibleWith(type));
        return slot;
    }

    public Slot pop() {
        assert (this.topOfStack > this.startOfStack);
        this.topOfStack -= 2;
        Slot slot = this.stack.pop();
        assert (this.nonNullType(slot.type));
        assert (slot.register == this.topOfStack);
        return slot;
    }

    public Slot pop(Type type) {
        Slot slot = this.pop();
        assert (slot.isCompatibleWith(type)) : "Tried to pop " + this.prettyType(slot.type) + " as " + this.prettyType(type);
        return slot;
    }

    public Slot[] popReverse(int count) {
        Slot[] slots = new Slot[count];
        for (int i = count - 1; i >= 0; --i) {
            slots[i] = this.pop();
        }
        return slots;
    }

    public Slot[] popReverse(int count, Type type) {
        Slot[] slots = this.popReverse(count);
        assert (JarState.verifySlots(slots, type));
        return slots;
    }

    public boolean hasState(int offset) {
        return this.targetStates.get(offset) != null;
    }

    public void restoreState(int offset) {
        Snapshot snapshot = this.targetStates.get(offset);
        assert (snapshot != null);
        assert (this.locals.length == snapshot.locals.length);
        System.arraycopy(snapshot.locals, 0, this.locals, 0, this.locals.length);
        this.stack.clear();
        this.stack.addAll(snapshot.stack);
        this.topOfStack = this.startOfStack + 2 * this.stack.size();
    }

    public boolean recordStateForTarget(int target) {
        return this.recordStateForTarget(target, (Local[])this.locals.clone(), ImmutableList.copyOf(this.stack));
    }

    public boolean recordStateForExceptionalTarget(int target) {
        return this.recordStateForTarget(target, (Local[])this.locals.clone(), ImmutableList.of(new Slot(this.startOfStack, JarSourceCode.THROWABLE_TYPE)));
    }

    private boolean recordStateForTarget(int target, Local[] locals, ImmutableList<Slot> stack) {
        Snapshot snapshot;
        if (!this.canonicalLocalInfo.isEmpty()) {
            for (int i = 0; i < locals.length; ++i) {
                if (locals[i] == null) continue;
                locals[i] = new Local(locals[i].slot, null);
            }
            LocalsAtOffset localsAtOffset = this.getLocalsAt(target);
            for (LocalNodeInfo live : localsAtOffset.live) {
                int register = this.getLocalRegister(live.node.index, live.type);
                Local local = locals[register];
                locals[register] = new Local(local.slot, live.info);
            }
        }
        if ((snapshot = this.targetStates.get(target)) != null) {
            Local[] newLocals = this.mergeLocals(snapshot.locals, locals);
            ImmutableList<Slot> newStack = this.mergeStacks(snapshot.stack, stack);
            if (newLocals != snapshot.locals || newStack != snapshot.stack) {
                this.targetStates.put(target, new Snapshot(newLocals, newStack));
                return true;
            }
            return false;
        }
        this.targetStates.put(target, new Snapshot(locals, stack));
        return true;
    }

    private boolean isRefinement(Type current, Type other) {
        return current == NULL_TYPE && other != NULL_TYPE || current == BYTE_OR_BOOL_TYPE && other != BYTE_OR_BOOL_TYPE;
    }

    private ImmutableList<Slot> mergeStacks(ImmutableList<Slot> currentStack, ImmutableList<Slot> newStack) {
        assert (currentStack.size() == newStack.size());
        ArrayList<Slot> mergedStack = null;
        for (int i = 0; i < currentStack.size(); ++i) {
            if (this.isRefinement(((Slot)currentStack.get((int)i)).type, ((Slot)newStack.get((int)i)).type)) {
                if (mergedStack == null) {
                    mergedStack = new ArrayList<Slot>();
                    mergedStack.addAll(currentStack.subList(0, i));
                }
                mergedStack.add((Slot)newStack.get(i));
                continue;
            }
            if (mergedStack == null) continue;
            assert (((Slot)currentStack.get(i)).isCompatibleWith(((Slot)newStack.get((int)i)).type));
            mergedStack.add((Slot)currentStack.get(i));
        }
        return mergedStack != null ? ImmutableList.copyOf(mergedStack) : currentStack;
    }

    private Local[] mergeLocals(Local[] currentLocals, Local[] newLocals) {
        assert (currentLocals.length == newLocals.length);
        Local[] mergedLocals = null;
        for (int i = 0; i < currentLocals.length; ++i) {
            Local currentLocal = currentLocals[i];
            Local newLocal = newLocals[i];
            if (currentLocal == null || newLocal == null) continue;
            assert (currentLocal.info == newLocal.info);
            if (this.isRefinement(currentLocal.slot.type, newLocal.slot.type)) {
                if (mergedLocals == null) {
                    mergedLocals = new Local[currentLocals.length];
                    System.arraycopy(currentLocals, 0, mergedLocals, 0, i);
                }
                Slot newSlot = new Slot(newLocal.slot.register, newLocal.slot.type);
                mergedLocals[i] = new Local(newSlot, newLocal.info);
                continue;
            }
            if (mergedLocals == null) continue;
            mergedLocals[i] = currentLocals[i];
        }
        return mergedLocals != null ? mergedLocals : currentLocals;
    }

    private static boolean verifySlots(Slot[] slots, Type type) {
        for (Slot slot : slots) {
            assert (slot.isCompatibleWith(type));
        }
        return true;
    }

    public String toString() {
        return "locals: " + JarState.localsToString(Arrays.asList(this.locals)) + ", stack: " + JarState.stackToString(this.stack);
    }

    public static String stackToString(Collection<Slot> stack) {
        ArrayList<String> strings = new ArrayList<String>(stack.size());
        for (Slot slot : stack) {
            if (slot.type == BYTE_OR_BOOL_TYPE) {
                strings.add("<byte|bool>");
                continue;
            }
            strings.add(slot.type.toString());
        }
        StringBuilder builder = new StringBuilder("{ ");
        for (int i = strings.size() - 1; i >= 0; --i) {
            builder.append((String)strings.get(i));
            if (i <= 0) continue;
            builder.append(", ");
        }
        builder.append(" }");
        return builder.toString();
    }

    public static String localsToString(Collection<Local> locals) {
        StringBuilder builder = new StringBuilder("{ ");
        boolean first = true;
        for (Local local : locals) {
            if (!first) {
                builder.append(", ");
            } else {
                first = false;
            }
            if (local == null) {
                builder.append("_");
                continue;
            }
            if (local.info != null) {
                builder.append(local.info);
                continue;
            }
            if (local.slot.type == BYTE_OR_BOOL_TYPE) {
                builder.append("<byte|bool>");
                continue;
            }
            builder.append(local.slot.type.toString());
        }
        builder.append(" }");
        return builder.toString();
    }

    private String prettyType(Type type) {
        if (type == BYTE_OR_BOOL_TYPE) {
            return "<byte|bool>";
        }
        if (type == ARRAY_TYPE) {
            return type.getElementType().getInternalName();
        }
        if (type == REFERENCE_TYPE || type == OBJECT_TYPE || type == NULL_TYPE) {
            return type.getInternalName();
        }
        return DescriptorUtils.descriptorToJavaType(type.getDescriptor());
    }

    public static class LocalChangeAtOffset {
        final LocalsAtOffset atExit;
        final LocalsAtOffset atEntry;
        private JarState state;

        private LocalChangeAtOffset(LocalsAtOffset atExit, LocalsAtOffset atEntry, JarState state) {
            this.atExit = atExit;
            this.atEntry = atEntry;
            this.state = state;
        }

        public List<Local> getLocalsToClose() {
            ArrayList<Local> toClose = new ArrayList<Local>(this.atExit.live.size());
            for (LocalNodeInfo liveAtExit : this.atExit.live) {
                if (this.atEntry.isLive(liveAtExit.info)) continue;
                int register = this.state.getLocalRegister(liveAtExit.node.index, liveAtExit.type);
                toClose.add(new Local(new Slot(register, liveAtExit.type), liveAtExit.info));
            }
            return toClose;
        }

        public List<Local> getLocalsToOpen() {
            ArrayList<Local> toOpen = new ArrayList<Local>(this.atEntry.live.size());
            for (LocalNodeInfo liveAtEntry : this.atEntry.live) {
                if (this.atExit.isLive(liveAtEntry.info)) continue;
                int register = this.state.getLocalRegister(liveAtEntry.node.index, liveAtEntry.type);
                toOpen.add(new Local(new Slot(register, liveAtEntry.type), liveAtEntry.info));
            }
            return toOpen;
        }
    }

    private static class Snapshot {
        public final Local[] locals;
        public final ImmutableList<Slot> stack;

        public Snapshot(Local[] locals, ImmutableList<Slot> stack) {
            this.locals = locals;
            this.stack = stack;
        }

        public String toString() {
            return "locals: " + JarState.localsToString(Arrays.asList(this.locals)) + ", stack: " + JarState.stackToString(this.stack);
        }
    }

    public static class Local {
        final Slot slot;
        final DebugLocalInfo info;

        public Local(Slot slot, DebugLocalInfo info) {
            this.slot = slot;
            this.info = info;
        }
    }

    public static class Slot {
        public final int register;
        public final Type type;

        public String toString() {
            return "r" + this.register + ":" + this.type;
        }

        public Slot(int register, Type type) {
            assert (type != REFERENCE_TYPE);
            assert (type != OBJECT_TYPE);
            assert (type != ARRAY_TYPE);
            this.register = register;
            this.type = type;
        }

        public boolean isCompatibleWith(Type other) {
            return Slot.isCompatible(this.type, other);
        }

        public boolean isCategory1() {
            return Slot.isCategory1(this.type);
        }

        public Type getArrayElementType() {
            assert (this.type == NULL_TYPE || this.type == ARRAY_TYPE || this.type.getSort() == 9);
            if (this.type == NULL_TYPE) {
                return null;
            }
            return Slot.getArrayElementType(this.type);
        }

        public static boolean isCategory1(Type type) {
            return type != Type.LONG_TYPE && type != Type.DOUBLE_TYPE;
        }

        public static boolean isCompatible(Type type, Type other) {
            assert (type != REFERENCE_TYPE);
            assert (type != OBJECT_TYPE);
            assert (type != ARRAY_TYPE);
            if (type == BYTE_OR_BOOL_TYPE) {
                type = Type.BYTE_TYPE;
            }
            if (other == BYTE_OR_BOOL_TYPE) {
                other = Type.BYTE_TYPE;
            }
            int sort = type.getSort();
            int otherSort = other.getSort();
            if (Slot.isReferenceCompatible(type, other)) {
                return true;
            }
            if (Slot.isIntCompatible(sort)) {
                return Slot.isIntCompatible(otherSort);
            }
            if (Slot.isIntCompatible(otherSort)) {
                return Slot.isIntCompatible(sort);
            }
            return type.equals(other);
        }

        private static Type getArrayElementType(Type type) {
            String desc = type.getDescriptor();
            assert (desc.charAt(0) == '[');
            return Type.getType(desc.substring(1));
        }

        private static boolean isIntCompatible(int sort) {
            return 1 <= sort && sort <= 5;
        }

        private static boolean isReferenceCompatible(Type type, Type other) {
            int sort = type.getSort();
            int otherSort = other.getSort();
            if (other == REFERENCE_TYPE) {
                return sort == 10 || sort == 9 || sort == 11;
            }
            if (other == OBJECT_TYPE) {
                return sort == 10;
            }
            if (other == ARRAY_TYPE) {
                return type == NULL_TYPE || sort == 9;
            }
            return sort == 10 && otherSort == 9 || sort == 9 && otherSort == 10 || sort == 10 && otherSort == 10 || sort == 9 && otherSort == 9;
        }
    }

    static class LocalsAtOffset {
        final List<LocalNodeInfo> live;
        final List<LocalNodeInfo> starts;
        final List<LocalNodeInfo> ends;
        IdentityHashMap<DebugLocalInfo, DebugLocalInfo> liveInfosCache = null;
        static final LocalsAtOffset EMPTY = new LocalsAtOffset();

        LocalsAtOffset() {
            this.live = Collections.emptyList();
            this.starts = Collections.emptyList();
            this.ends = Collections.emptyList();
        }

        LocalsAtOffset(LocalsAtOffset other) {
            this.live = new ArrayList<LocalNodeInfo>(other.live);
            this.starts = new ArrayList<LocalNodeInfo>();
            this.ends = new ArrayList<LocalNodeInfo>();
        }

        void addStart(LocalVariableNode node, DebugLocalInfo info) {
            this.starts.add(new LocalNodeInfo(node, info));
        }

        void addEnd(LocalVariableNode node, DebugLocalInfo info) {
            this.ends.add(new LocalNodeInfo(node, info));
        }

        void addLive(LocalVariableNode node, DebugLocalInfo info) {
            assert (this.liveInfosCache == null);
            this.live.add(new LocalNodeInfo(node, info));
        }

        boolean isLive(DebugLocalInfo info) {
            if (this.live.size() < 10) {
                for (LocalNodeInfo entry : this.live) {
                    if (entry.info != info) continue;
                    return true;
                }
                return false;
            }
            if (this.liveInfosCache == null) {
                this.liveInfosCache = new IdentityHashMap(this.live.size());
                for (LocalNodeInfo entry : this.live) {
                    this.liveInfosCache.put(entry.info, entry.info);
                }
            }
            return this.liveInfosCache.containsKey(info);
        }
    }

    private static class LocalNodeInfo {
        final Type type;
        final LocalVariableNode node;
        final DebugLocalInfo info;

        LocalNodeInfo(LocalVariableNode node, DebugLocalInfo info) {
            this.node = node;
            this.info = info;
            this.type = Type.getType(node.desc);
        }
    }

    private static class LocalNodeEquivalence
    extends Equivalence<LocalVariableNode> {
        private LocalNodeEquivalence() {
        }

        @Override
        protected boolean doEquivalent(LocalVariableNode a, LocalVariableNode b) {
            if (!a.name.equals(b.name) || !a.desc.equals(b.desc)) {
                return false;
            }
            return a.signature == null && b.signature == null || a.signature != null && a.signature.equals(b.signature);
        }

        @Override
        protected int doHash(LocalVariableNode local) {
            return 31 * local.name.hashCode() + 7 * local.desc.hashCode() + (local.signature == null ? 0 : local.signature.hashCode());
        }
    }
}

