/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.tasks;

import com.android.builder.tasks.Job;
import com.android.builder.tasks.QueueThreadContext;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class WorkQueue<T>
implements Runnable {
    private static final boolean VERBOSE = System.getenv("GRADLE_WORK_QUEUE_VERBOSE") != null;
    private final ILogger mLogger;
    private final String mName;
    private final LinkedBlockingQueue<QueueTask<T>> mPendingJobs = new LinkedBlockingQueue();
    private final List<Thread> mWorkThreads = new ArrayList<Thread>();
    private int mServerFailure = 0;
    private final float mGrowthTriggerRatio;
    private final int mMWorkforceIncrement;
    private final AtomicInteger mThreadId = new AtomicInteger(0);
    private final QueueThreadContext<T> mQueueThreadContext;
    private static final int MAX_WORKFORCE_SIZE = 20;

    public WorkQueue(ILogger logger, QueueThreadContext<T> queueThreadContext, String queueName, int workforce) {
        this(logger, queueThreadContext, queueName, workforce, 0.0f);
    }

    public WorkQueue(ILogger logger, QueueThreadContext<T> queueThreadContext, String queueName, int workforce, float growthTriggerRatio) {
        this.mLogger = logger;
        this.mName = queueName;
        this.mGrowthTriggerRatio = growthTriggerRatio;
        this.mMWorkforceIncrement = workforce;
        this.mQueueThreadContext = queueThreadContext;
    }

    public synchronized void push(Job<T> job) throws InterruptedException {
        this._push(new QueueTask(QueueTask.ActionType.Normal, job));
        this.checkWorkforce();
    }

    private void _push(QueueTask<T> task) throws InterruptedException {
        this.mPendingJobs.put(task);
    }

    private synchronized void checkWorkforce() {
        List livingThreads = this.mWorkThreads.stream().filter(Thread::isAlive).collect(Collectors.toList());
        if (livingThreads.isEmpty() || (float)(this.mPendingJobs.size() / livingThreads.size()) > this.mGrowthTriggerRatio && this.mGrowthTriggerRatio > 0.0f) {
            this.mLogger.verbose("Request to incrementing alive workforce from %1$d. Current workforce (dead or alive) %2$d", new Object[]{livingThreads.size(), this.mWorkThreads.size()});
            if (this.mWorkThreads.size() >= 20) {
                this.verbose("Already at max workforce %1$d, denied.", 20);
                return;
            }
            for (int i = 0; i < this.mMWorkforceIncrement; ++i) {
                Thread t = new Thread((Runnable)this, this.mName + "_" + this.mThreadId.incrementAndGet());
                t.setDaemon(true);
                this.mWorkThreads.add(t);
                t.start();
            }
            this.mLogger.verbose("thread-pool size=%1$d", new Object[]{this.mWorkThreads.size()});
        }
    }

    private synchronized void reduceWorkforce() throws InterruptedException {
        this.verbose("Decrementing workforce from " + this.mWorkThreads.size(), new Object[0]);
        for (int i = 0; i < this.mMWorkforceIncrement; ++i) {
            this._push(new QueueTask(QueueTask.ActionType.Death, null));
        }
    }

    public synchronized void shutdown() throws InterruptedException {
        List livingThreads = this.mWorkThreads.stream().filter(Thread::isAlive).collect(Collectors.toList());
        if (livingThreads.isEmpty() && !this.mPendingJobs.isEmpty()) {
            this.mLogger.verbose("Shutdown called on the work queue, but there are still jobs pending.", new Object[0]);
            this.mLogger.verbose("Pending jobs:", new Object[0]);
            for (QueueTask<T> job : this.mPendingJobs) {
                this.mLogger.verbose(job.toString(), new Object[0]);
            }
            throw new RuntimeException("No slave process to process jobs, aborting");
        }
        for (Thread t : this.mWorkThreads) {
            this._push(new QueueTask(QueueTask.ActionType.Death, null));
        }
        for (Thread t : this.mWorkThreads) {
            t.join();
        }
        this.mWorkThreads.clear();
        this.mPendingJobs.clear();
        this.mQueueThreadContext.shutdown();
    }

    public String getName() {
        return this.mName;
    }

    public int size() {
        return this.mPendingJobs.size();
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 16[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private synchronized void checkFailedServers() {
        ++this.mServerFailure;
        if (this.mServerFailure >= this.mWorkThreads.size()) {
            for (QueueTask<T> task : this.mPendingJobs) {
                task.job.error(new RuntimeException("No server to serve request. Check logs for details."));
            }
            this.mServerFailure = 0;
        }
    }

    private void verbose(String format, Object ... args) {
        if (VERBOSE) {
            this.mLogger.verbose(format, args);
        }
    }

    private static class QueueTask<T> {
        final ActionType actionType;
        final Job<T> job;

        private QueueTask(ActionType actionType, Job<T> job) {
            Preconditions.checkState((job != null || actionType == ActionType.Death ? 1 : 0) != 0, (Object)"Job cannot be null for action type NORMAL");
            this.actionType = actionType;
            this.job = job;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("QueueTask of type ");
            sb.append(this.actionType.name());
            sb.append(" with job ");
            sb.append(this.job == null ? "null" : this.job.toString());
            return sb.toString();
        }

        static enum ActionType {
            Death,
            Normal;

        }
    }
}

