/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.shaking.ProguardClassNameList;
import com.android.tools.r8.shaking.ProguardClassType;
import com.android.tools.r8.shaking.ProguardConfigurationParser;
import com.android.tools.r8.shaking.ProguardIdentifierNameStringRule;
import com.android.tools.r8.shaking.ProguardKeepRule;
import com.android.tools.r8.shaking.ProguardKeepRuleType;
import com.android.tools.r8.shaking.ProguardMemberRule;
import com.android.tools.r8.shaking.ProguardMemberType;
import com.android.tools.r8.shaking.ProguardTypeMatcher;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ProguardConfigurationUtils {
    public static ProguardKeepRule buildDefaultInitializerKeepRule(DexClass clazz) {
        ProguardKeepRule.Builder builder = ProguardKeepRule.builder();
        builder.setType(ProguardKeepRuleType.KEEP);
        builder.getModifiersBuilder().setAllowsObfuscation(true);
        builder.getModifiersBuilder().setAllowsOptimization(true);
        builder.getClassAccessFlags().setPublic();
        builder.setClassType(ProguardClassType.CLASS);
        ProguardClassNameList.Builder classNameListBuilder = ProguardClassNameList.builder();
        classNameListBuilder.addClassName(false, ProguardTypeMatcher.create(clazz.type));
        builder.setClassNames(classNameListBuilder.build());
        if (clazz.hasDefaultInitializer()) {
            ProguardMemberRule.Builder memberRuleBuilder = ProguardMemberRule.builder();
            memberRuleBuilder.setRuleType(ProguardMemberType.INIT);
            memberRuleBuilder.setName(ProguardConfigurationParser.IdentifierPatternWithWildcards.withoutWildcards("<init>"));
            memberRuleBuilder.setArguments(ImmutableList.of());
            builder.getMemberRules().add(memberRuleBuilder.build());
        }
        return builder.build();
    }

    public static ProguardKeepRule buildFieldKeepRule(DexClass clazz, DexEncodedField field) {
        assert (clazz.type == field.field.getHolder());
        ProguardKeepRule.Builder builder = ProguardKeepRule.builder();
        builder.setType(ProguardKeepRuleType.KEEP_CLASS_MEMBERS);
        builder.getModifiersBuilder().setAllowsObfuscation(true);
        builder.getModifiersBuilder().setAllowsOptimization(true);
        builder.getClassAccessFlags().setPublic();
        if (clazz.isInterface()) {
            builder.setClassType(ProguardClassType.INTERFACE);
        } else {
            builder.setClassType(ProguardClassType.CLASS);
        }
        builder.setClassNames(ProguardClassNameList.singletonList(ProguardTypeMatcher.create(clazz.type)));
        ProguardMemberRule.Builder memberRuleBuilder = ProguardMemberRule.builder();
        memberRuleBuilder.setRuleType(ProguardMemberType.FIELD);
        memberRuleBuilder.getAccessFlags().setFlags(field.accessFlags);
        memberRuleBuilder.setName(ProguardConfigurationParser.IdentifierPatternWithWildcards.withoutWildcards(field.field.name.toString()));
        memberRuleBuilder.setTypeMatcher(ProguardTypeMatcher.create(field.field.type));
        builder.getMemberRules().add(memberRuleBuilder.build());
        return builder.build();
    }

    public static ProguardKeepRule buildMethodKeepRule(DexClass clazz, DexEncodedMethod method) {
        assert (clazz.type == method.method.getHolder());
        ProguardKeepRule.Builder builder = ProguardKeepRule.builder();
        builder.setType(ProguardKeepRuleType.KEEP_CLASS_MEMBERS);
        builder.getModifiersBuilder().setAllowsObfuscation(true);
        builder.getModifiersBuilder().setAllowsOptimization(true);
        builder.getClassAccessFlags().setPublic();
        if (clazz.isInterface()) {
            builder.setClassType(ProguardClassType.INTERFACE);
        } else {
            builder.setClassType(ProguardClassType.CLASS);
        }
        builder.setClassNames(ProguardClassNameList.singletonList(ProguardTypeMatcher.create(clazz.type)));
        ProguardMemberRule.Builder memberRuleBuilder = ProguardMemberRule.builder();
        memberRuleBuilder.setRuleType(ProguardMemberType.METHOD);
        memberRuleBuilder.getAccessFlags().setFlags(method.accessFlags);
        memberRuleBuilder.setName(ProguardConfigurationParser.IdentifierPatternWithWildcards.withoutWildcards(method.method.name.toString()));
        memberRuleBuilder.setTypeMatcher(ProguardTypeMatcher.create(method.method.proto.returnType));
        List<ProguardTypeMatcher> arguments = Arrays.stream(method.method.proto.parameters.values).map(ProguardTypeMatcher::create).collect(Collectors.toList());
        memberRuleBuilder.setArguments(arguments);
        builder.getMemberRules().add(memberRuleBuilder.build());
        return builder.build();
    }

    public static ProguardIdentifierNameStringRule buildIdentifierNameStringRule(DexReference item) {
        DexType holderType;
        assert (item.isDexField() || item.isDexMethod());
        ProguardIdentifierNameStringRule.Builder builder = ProguardIdentifierNameStringRule.builder();
        ProguardMemberRule.Builder memberRuleBuilder = ProguardMemberRule.builder();
        if (item.isDexField()) {
            DexField field = item.asDexField();
            holderType = field.getHolder();
            memberRuleBuilder.setRuleType(ProguardMemberType.FIELD);
            memberRuleBuilder.setName(ProguardConfigurationParser.IdentifierPatternWithWildcards.withoutWildcards(field.name.toString()));
            memberRuleBuilder.setTypeMatcher(ProguardTypeMatcher.create(field.type));
        } else {
            DexMethod method = item.asDexMethod();
            holderType = method.getHolder();
            memberRuleBuilder.setRuleType(ProguardMemberType.METHOD);
            memberRuleBuilder.setName(ProguardConfigurationParser.IdentifierPatternWithWildcards.withoutWildcards(method.name.toString()));
            memberRuleBuilder.setTypeMatcher(ProguardTypeMatcher.create(method.proto.returnType));
            List<ProguardTypeMatcher> arguments = Arrays.stream(method.proto.parameters.values).map(ProguardTypeMatcher::create).collect(Collectors.toList());
            memberRuleBuilder.setArguments(arguments);
        }
        if (holderType.isInterface()) {
            builder.setClassType(ProguardClassType.INTERFACE);
        } else {
            builder.setClassType(ProguardClassType.CLASS);
        }
        builder.setClassNames(ProguardClassNameList.singletonList(ProguardTypeMatcher.create(holderType)));
        builder.getMemberRules().add(memberRuleBuilder.build());
        return builder.build();
    }
}

