/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.desugaring;

import com.android.builder.desugaring.DesugaringData;
import com.android.builder.dexing.ClassFileInput;
import com.android.utils.PathUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class DesugaringClassAnalyzer {
    public static List<DesugaringData> analyze(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            return DesugaringClassAnalyzer.analyzeDir(path);
        }
        if (Files.isRegularFile(path, new LinkOption[0])) {
            if (path.toString().endsWith(".jar")) {
                return DesugaringClassAnalyzer.analyzeJar(path);
            }
            if (ClassFileInput.CLASS_MATCHER.test(PathUtils.toSystemIndependentPath((Path)path))) {
                return ImmutableList.of((Object)DesugaringClassAnalyzer.analyzeClass(path));
            }
            return ImmutableList.of();
        }
        throw new IOException("Unable to process " + path.toString());
    }

    private static List<DesugaringData> analyzeJar(Path jar) throws IOException {
        ArrayList<DesugaringData> data;
        Preconditions.checkArgument((jar.toString().endsWith(".jar") && Files.isRegularFile(jar, new LinkOption[0]) ? 1 : 0) != 0, (String)"Not a .jar file: %s", (Object)jar.toString());
        try (ZipFile zip2 = new ZipFile(jar.toFile());){
            data = new ArrayList<DesugaringData>(zip2.size());
            Enumeration<? extends ZipEntry> entries = zip2.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                if (!ClassFileInput.CLASS_MATCHER.test(zipEntry.getName())) continue;
                BufferedInputStream inputStream = new BufferedInputStream(zip2.getInputStream(zipEntry));
                Throwable throwable = null;
                try {
                    data.add(DesugaringClassAnalyzer.analyze(jar, inputStream));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }
        return data;
    }

    private static List<DesugaringData> analyzeDir(final Path dir) throws IOException {
        Preconditions.checkArgument((boolean)Files.isDirectory(dir, new LinkOption[0]), (String)"Not a directory: %s", (Object)dir.toString());
        final LinkedList<DesugaringData> data = new LinkedList<DesugaringData>();
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path relative = dir.relativize(file);
                if (ClassFileInput.CLASS_MATCHER.test(PathUtils.toSystemIndependentPath((Path)relative))) {
                    data.add(DesugaringClassAnalyzer.analyzeClass(file));
                }
                return super.visitFile(file, attrs);
            }
        });
        return data;
    }

    private static DesugaringData analyzeClass(Path classFile) throws IOException {
        Preconditions.checkArgument((classFile.toString().endsWith(".class") && Files.isRegularFile(classFile, new LinkOption[0]) ? 1 : 0) != 0, (String)"Not a .class file: %s", (Object)classFile.toString());
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(classFile, new OpenOption[0]));){
            DesugaringData desugaringData = DesugaringClassAnalyzer.analyze(classFile, is);
            return desugaringData;
        }
    }

    public static DesugaringData forRemoved(Path path) {
        Preconditions.checkArgument((!Files.exists(path, new LinkOption[0]) ? 1 : 0) != 0, (String)"%s exists.", (Object)path.toString());
        return new DesugaringData(path);
    }

    static DesugaringData analyze(Path path, InputStream is) throws IOException {
        ClassReader reader = new ClassReader(is);
        Visitor visitor = new Visitor(path);
        reader.accept((ClassVisitor)visitor, 6);
        return new DesugaringData(visitor.getPath(), visitor.getType(), visitor.getDependencies());
    }

    private static class LambdaSeeker
    extends MethodVisitor {
        private final Set<String> dependencies;

        public LambdaSeeker(Set<String> dependencies, MethodVisitor mv) {
            super(327680, mv);
            this.dependencies = dependencies;
        }

        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
            Type methodType = Type.getMethodType((String)desc);
            String internalName = methodType.getReturnType().getInternalName();
            this.dependencies.add(internalName);
            super.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
        }
    }

    private static class Visitor
    extends ClassVisitor {
        private final Path path;
        private String type;
        private final Set<String> dependencies = Sets.newHashSet();

        public Visitor(Path path) {
            super(327680);
            this.path = path;
        }

        public Path getPath() {
            return this.path;
        }

        public String getType() {
            return (String)Preconditions.checkNotNull((Object)this.type, (Object)"visit() not invoked");
        }

        public Set<String> getDependencies() {
            return this.dependencies;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.type = name;
            if (superName != null) {
                this.dependencies.add(superName);
            }
            if (interfaces != null) {
                Collections.addAll(this.dependencies, interfaces);
            }
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
            return new LambdaSeeker(this.dependencies, methodVisitor);
        }
    }
}

