/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.naming.MemberNameMinifier;
import com.android.tools.r8.naming.NamingState;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.RootSetBuilder;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.MethodSignatureEquivalence;
import com.android.tools.r8.utils.MethodSignatureRelaxedEquivalence;
import com.android.tools.r8.utils.Timing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

class MethodNameMinifier
extends MemberNameMinifier<DexMethod, DexProto> {
    private final Set<DexCallSite> desugaredCallSites;
    private final Equivalence<DexMethod> equivalence;
    private final Map<DexCallSite, DexString> callSiteRenaming = new IdentityHashMap<DexCallSite, DexString>();

    MethodNameMinifier(Enqueuer.AppInfoWithLiveness appInfo, RootSetBuilder.RootSet rootSet, Set<DexCallSite> desugaredCallSites, InternalOptions options) {
        super(appInfo, rootSet, options);
        this.desugaredCallSites = desugaredCallSites;
        this.equivalence = this.overloadAggressively ? MethodSignatureEquivalence.get() : new MethodSignatureRelaxedEquivalence(appInfo);
    }

    @Override
    Function<DexProto, ?> getKeyTransform() {
        if (this.overloadAggressively) {
            return a -> a;
        }
        return proto -> proto.parameters;
    }

    MethodRenaming computeRenaming(Timing timing) {
        timing.begin("Phase 1");
        IdentityHashMap<DexType, DexType> frontierMap = new IdentityHashMap<DexType, DexType>();
        this.reserveNamesInClasses(this.appInfo.dexItemFactory.objectType, this.appInfo.dexItemFactory.objectType, null, frontierMap);
        timing.end();
        timing.begin("Phase 2");
        DexType.forAllInterfaces(this.appInfo.dexItemFactory, iface -> this.reserveNamesInInterfaces((DexType)iface, (Map<DexType, DexType>)frontierMap));
        timing.end();
        timing.begin("Phase 3");
        this.assignNamesToInterfaceMethods(frontierMap, timing);
        timing.end();
        timing.begin("Phase 4");
        this.assignNamesToClassesMethods(this.appInfo.dexItemFactory.objectType, false);
        timing.end();
        timing.begin("Phase 5");
        this.assignNamesToClassesMethods(this.appInfo.dexItemFactory.objectType, true);
        timing.end();
        return new MethodRenaming(this.renaming, this.callSiteRenaming);
    }

    private void assignNamesToClassesMethods(DexType type, boolean doPrivates) {
        DexClass holder = this.appInfo.definitionFor(type);
        if (holder != null && !holder.isLibraryClass()) {
            IdentityHashMap<DexMethod, DexString> renamingAtThisLevel = new IdentityHashMap<DexMethod, DexString>();
            NamingState state = this.computeStateIfAbsent(type, k -> this.getState(holder.superType).createChild());
            holder.forEachMethod(method -> this.assignNameToMethod((DexEncodedMethod)method, state, (Map<DexMethod, DexString>)renamingAtThisLevel, doPrivates));
            if (!doPrivates && !this.useUniqueMemberNames) {
                renamingAtThisLevel.forEach((method, candidate) -> state.addRenaming(method.name, method.proto, (DexString)candidate));
            }
        }
        type.forAllExtendsSubtypes(subtype -> this.assignNamesToClassesMethods((DexType)subtype, doPrivates));
    }

    private void assignNameToMethod(DexEncodedMethod encodedMethod, NamingState<DexProto, ?> state, Map<DexMethod, DexString> renamingAtThisLevel, boolean doPrivates) {
        if (encodedMethod.accessFlags.isPrivate() != doPrivates) {
            return;
        }
        DexMethod method = encodedMethod.method;
        if (!state.isReserved(method.name, method.proto) && !encodedMethod.accessFlags.isConstructor()) {
            DexString renamedName = state.assignNewNameFor(method.name, method.proto, this.useUniqueMemberNames);
            this.renaming.put(method, renamedName);
            renamingAtThisLevel.put(method, renamedName);
        }
    }

    private Set<NamingState<DexProto, ?>> getReachableStates(DexType type, Map<DexType, DexType> frontierMap) {
        Set<DexType> interfaces = Sets.newIdentityHashSet();
        interfaces.add(type);
        this.collectSuperInterfaces(type, interfaces);
        this.collectSubInterfaces(type, interfaces);
        HashSet reachableStates = new HashSet();
        for (DexType iface : interfaces) {
            reachableStates.add(this.getState(iface));
            iface.forAllImplementsSubtypes(t -> {
                NamingState state = this.getState((DexType)frontierMap.get(t));
                assert (state != null);
                reachableStates.add(state);
            });
        }
        return reachableStates;
    }

    /*
     * WARNING - void declaration
     */
    private void assignNamesToInterfaceMethods(Map<DexType, DexType> frontierMap, Timing timing) {
        timing.begin("Compute map");
        HashMap globalStateMap = new HashMap();
        HashMap sourceMethodsMap = new HashMap();
        HashMap originStates = new HashMap();
        DexType.forAllInterfaces(this.appInfo.dexItemFactory, iface -> {
            assert (iface.isInterface());
            DexClass clazz = this.appInfo.definitionFor((DexType)iface);
            if (clazz != null) {
                Set<NamingState<DexProto, ?>> collectedStates = this.getReachableStates((DexType)iface, frontierMap);
                clazz.forEachMethod(method -> this.addStatesToGlobalMapForMethod((DexEncodedMethod)method, collectedStates, globalStateMap, sourceMethodsMap, originStates, (DexType)iface));
            }
        });
        Sets.SetView<DexCallSite> liveCallSites = Sets.union(this.desugaredCallSites, this.appInfo.callSites);
        IdentityHashMap callSites = new IdentityHashMap();
        HashMap<void, Equivalence.Wrapper> unificationParent = new HashMap<void, Equivalence.Wrapper>();
        liveCallSites.forEach(callSite -> {
            HashSet<Equivalence.Wrapper<DexMethod>> callSiteMethods = new HashSet<Equivalence.Wrapper<DexMethod>>();
            Set<DexEncodedMethod> implementedMethods = this.appInfo.lookupLambdaImplementedMethods((DexCallSite)callSite, null);
            if (implementedMethods.isEmpty()) {
                return;
            }
            callSites.put(callSite, implementedMethods.iterator().next().method);
            for (DexEncodedMethod method : implementedMethods) {
                DexType dexType = method.method.holder;
                assert (dexType.isInterface());
                Set<NamingState<DexProto, ?>> collectedStates = this.getReachableStates(dexType, frontierMap);
                this.addStatesToGlobalMapForMethod(method, collectedStates, globalStateMap, sourceMethodsMap, originStates, dexType);
                callSiteMethods.add(this.equivalence.wrap(method.method));
            }
            if (callSiteMethods.size() > 1) {
                Equivalence.Wrapper mainKey = (Equivalence.Wrapper)callSiteMethods.iterator().next();
                mainKey = unificationParent.getOrDefault(mainKey, mainKey);
                for (Equivalence.Wrapper wrapper : callSiteMethods) {
                    unificationParent.put(wrapper, mainKey);
                }
            }
        });
        HashMap<Equivalence.Wrapper, Set<Equivalence.Wrapper>> unification = new HashMap<Equivalence.Wrapper, Set<Equivalence.Wrapper>>();
        for (Equivalence.Wrapper key : unificationParent.keySet()) {
            void var12_12;
            Equivalence.Wrapper wrapper = (Equivalence.Wrapper)unificationParent.get(key);
            while (unificationParent.get(var12_12) != var12_12) {
                Equivalence.Wrapper k2 = (Equivalence.Wrapper)unificationParent.get(unificationParent.get(var12_12));
                unificationParent.put(var12_12, k2);
                Equivalence.Wrapper wrapper2 = k2;
            }
            unification.computeIfAbsent((Equivalence.Wrapper)var12_12, (Function<Equivalence.Wrapper, Set<Equivalence.Wrapper>>)((Function<Equivalence.Wrapper, Set>)k -> new HashSet())).add(key);
        }
        timing.end();
        timing.begin("Allocate names");
        ArrayList methods = new ArrayList(globalStateMap.keySet());
        methods.sort((a, b) -> ((Set)globalStateMap.get(b)).size() - ((Set)globalStateMap.get(a)).size());
        for (Equivalence.Wrapper wrapper : methods) {
            if (!unificationParent.getOrDefault(wrapper, wrapper).equals(wrapper)) continue;
            ArrayList<MethodNamingState> collectedStates = new ArrayList<MethodNamingState>();
            Set<DexMethod> sourceMethods = Sets.newIdentityHashSet();
            for (Equivalence.Wrapper k3 : unification.getOrDefault(wrapper, Collections.singleton(wrapper))) {
                DexMethod unifiedMethod = (DexMethod)k3.get();
                assert (unifiedMethod != null);
                sourceMethods.addAll((Collection)sourceMethodsMap.get(k3));
                for (NamingState namingState : (Set)globalStateMap.get(k3)) {
                    collectedStates.add(new MethodNamingState(namingState, unifiedMethod.name, unifiedMethod.proto));
                }
            }
            DexMethod method = (DexMethod)wrapper.get();
            assert (method != null);
            MethodNamingState originState = new MethodNamingState((NamingState)originStates.get(wrapper), method.name, method.proto);
            this.assignNameForInterfaceMethodInAllStates(collectedStates, sourceMethods, originState);
        }
        for (Map.Entry entry : callSites.entrySet()) {
            DexMethod method = (DexMethod)entry.getValue();
            DexString renamed = (DexString)this.renaming.get(method);
            if (((NamingState)originStates.get(this.equivalence.wrap(method))).isReserved(method.name, method.proto)) {
                assert (renamed == null);
                this.callSiteRenaming.put((DexCallSite)entry.getKey(), method.name);
                continue;
            }
            assert (renamed != null);
            this.callSiteRenaming.put((DexCallSite)entry.getKey(), renamed);
        }
        timing.end();
    }

    private void collectSuperInterfaces(DexType iface, Set<DexType> interfaces) {
        DexClass clazz = this.appInfo.definitionFor(iface);
        if (clazz != null) {
            for (DexType type : clazz.interfaces.values) {
                if (!interfaces.add(type)) continue;
                this.collectSuperInterfaces(type, interfaces);
            }
        }
    }

    private void collectSubInterfaces(DexType iface, Set<DexType> interfaces) {
        iface.forAllExtendsSubtypes(subtype -> {
            assert (subtype.isInterface());
            if (interfaces.add((DexType)subtype)) {
                this.collectSubInterfaces((DexType)subtype, interfaces);
            }
        });
    }

    private void addStatesToGlobalMapForMethod(DexEncodedMethod method, Set<NamingState<DexProto, ?>> collectedStates, Map<Equivalence.Wrapper<DexMethod>, Set<NamingState<DexProto, ?>>> globalStateMap, Map<Equivalence.Wrapper<DexMethod>, Set<DexMethod>> sourceMethodsMap, Map<Equivalence.Wrapper<DexMethod>, NamingState<DexProto, ?>> originStates, DexType originInterface) {
        Equivalence.Wrapper<DexMethod> key = this.equivalence.wrap(method.method);
        Set stateSet = globalStateMap.computeIfAbsent(key, k -> new HashSet());
        stateSet.addAll(collectedStates);
        sourceMethodsMap.computeIfAbsent(key, k -> new HashSet()).add(method.method);
        originStates.putIfAbsent(key, this.getState(originInterface));
    }

    private void assignNameForInterfaceMethodInAllStates(List<MethodNamingState> collectedStates, Set<DexMethod> sourceMethods, MethodNamingState originState) {
        if (this.anyIsReserved(collectedStates)) {
            for (MethodNamingState state : collectedStates) {
                state.reserveName();
            }
            return;
        }
        DexString previousCandidate = null;
        DexString candidate = null;
        block1: do {
            if ((candidate = originState.assignNewNameFor(false)) != null && candidate == previousCandidate) {
                assert (this.useUniqueMemberNames);
                break;
            }
            for (MethodNamingState state : collectedStates) {
                if (state.isAvailable(candidate)) continue;
                previousCandidate = candidate;
                candidate = null;
                continue block1;
            }
        } while (candidate == null);
        for (MethodNamingState state : collectedStates) {
            state.addRenaming(candidate);
        }
        for (DexMethod sourceMethod : sourceMethods) {
            this.renaming.put(sourceMethod, candidate);
        }
    }

    private boolean anyIsReserved(List<MethodNamingState> collectedStates) {
        DexString name = collectedStates.get(0).getName();
        HashMap<DexProto, Boolean> globalStateCache = new HashMap<DexProto, Boolean>();
        for (MethodNamingState state : collectedStates) {
            assert (state.getName() == name);
            if (!globalStateCache.computeIfAbsent(state.getProto(), proto -> this.globalState.isReserved(name, proto)).booleanValue() || !state.isReserved()) continue;
            return true;
        }
        return false;
    }

    private void reserveNamesInClasses(DexType type, DexType libraryFrontier, NamingState<DexProto, ?> parent, Map<DexType, DexType> frontierMap) {
        assert (!type.isInterface());
        DexClass holder = this.appInfo.definitionFor(type);
        NamingState<DexProto, ?> state = this.allocateNamingStateAndReserve(holder, type, libraryFrontier, parent, frontierMap);
        type.forAllExtendsSubtypes(subtype -> {
            assert (!subtype.isInterface());
            this.reserveNamesInClasses((DexType)subtype, holder == null || holder.isLibraryClass() ? subtype : libraryFrontier, state, frontierMap);
        });
    }

    private void reserveNamesInInterfaces(DexType type, Map<DexType, DexType> frontierMap) {
        assert (type.isInterface());
        frontierMap.put(type, type);
        DexClass holder = this.appInfo.definitionFor(type);
        this.allocateNamingStateAndReserve(holder, type, type, null, frontierMap);
    }

    private NamingState<DexProto, ?> allocateNamingStateAndReserve(DexClass holder, DexType type, DexType libraryFrontier, NamingState<DexProto, ?> parent, Map<DexType, DexType> frontierMap) {
        frontierMap.put(type, libraryFrontier);
        NamingState state = this.computeStateIfAbsent(libraryFrontier, ignore -> parent == null ? NamingState.createRoot(this.appInfo.dexItemFactory, this.dictionary, this.getKeyTransform(), this.useUniqueMemberNames) : parent.createChild());
        if (holder != null) {
            boolean keepAll = holder.isLibraryClass() || holder.accessFlags.isAnnotation();
            holder.forEachMethod(method -> this.reserveNamesForMethod((DexEncodedMethod)method, keepAll, state));
        }
        return state;
    }

    private void reserveNamesForMethod(DexEncodedMethod method, boolean keepAll, NamingState<DexProto, ?> state) {
        if (keepAll || this.rootSet.noObfuscation.contains(method)) {
            state.reserveName(method.method.name, method.method.proto);
            this.globalState.reserveName(method.method.name, method.method.proto);
        }
    }

    private static class MethodNamingState {
        private final NamingState<DexProto, ?> parent;
        private final DexString name;
        private final DexProto proto;

        MethodNamingState(NamingState<DexProto, ?> parent, DexString name, DexProto proto) {
            assert (parent != null);
            this.parent = parent;
            this.name = name;
            this.proto = proto;
        }

        DexString assignNewNameFor(boolean markAsUsed) {
            return this.parent.assignNewNameFor(this.name, this.proto, markAsUsed);
        }

        void reserveName() {
            this.parent.reserveName(this.name, this.proto);
        }

        boolean isReserved() {
            return this.parent.isReserved(this.name, this.proto);
        }

        boolean isAvailable(DexString candidate) {
            return this.parent.isAvailable(this.name, this.proto, candidate);
        }

        void addRenaming(DexString newName) {
            this.parent.addRenaming(this.name, this.proto, newName);
        }

        DexString getName() {
            return this.name;
        }

        DexProto getProto() {
            return this.proto;
        }
    }

    static class MethodRenaming {
        final Map<DexMethod, DexString> renaming;
        final Map<DexCallSite, DexString> callSiteRenaming;

        private MethodRenaming(Map<DexMethod, DexString> renaming, Map<DexCallSite, DexString> callSiteRenaming) {
            this.renaming = renaming;
            this.callSiteRenaming = callSiteRenaming;
        }
    }
}

