/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.AccessFlags;
import java.util.List;
import java.util.function.BooleanSupplier;

public class ProguardAccessFlags {
    private int flags = 0;
    private static final List<String> NAMES = ImmutableList.of("public", "private", "protected", "static", "final", "abstract", "volatile", "transient", "synchronized", "native", "strictfp");

    private List<BooleanSupplier> getPredicates() {
        return ImmutableList.of(this::isPublic, this::isPrivate, this::isProtected, this::isStatic, this::isFinal, this::isAbstract, this::isVolatile, this::isTransient, this::isSynchronized, this::isNative, this::isStrict);
    }

    private boolean containsAll(int other) {
        return (this.flags & other) == this.flags;
    }

    private boolean containsNone(int other) {
        return (this.flags & other) == 0;
    }

    public boolean containsAll(AccessFlags other) {
        return this.containsAll(other.getAsCfAccessFlags());
    }

    public boolean containsNone(AccessFlags other) {
        return this.containsNone(other.getAsCfAccessFlags());
    }

    public void setFlags(AccessFlags other) {
        this.flags = other.getAsCfAccessFlags();
    }

    public void setPublic() {
        this.set(1);
    }

    public boolean isPublic() {
        return this.isSet(1);
    }

    public void setPrivate() {
        this.set(2);
    }

    public boolean isPrivate() {
        return this.isSet(2);
    }

    public void setProtected() {
        this.set(4);
    }

    public boolean isProtected() {
        return this.isSet(4);
    }

    public void setStatic() {
        this.set(8);
    }

    public boolean isStatic() {
        return this.isSet(8);
    }

    public void setFinal() {
        this.set(16);
    }

    public boolean isFinal() {
        return this.isSet(16);
    }

    public void setAbstract() {
        this.set(1024);
    }

    public boolean isAbstract() {
        return this.isSet(1024);
    }

    public void setVolatile() {
        this.set(64);
    }

    public boolean isVolatile() {
        return this.isSet(64);
    }

    public void setTransient() {
        this.set(128);
    }

    public boolean isTransient() {
        return this.isSet(128);
    }

    public void setSynchronized() {
        this.set(32);
    }

    public boolean isSynchronized() {
        return this.isSet(32);
    }

    public void setNative() {
        this.set(256);
    }

    public boolean isNative() {
        return this.isSet(256);
    }

    public void setStrict() {
        this.set(2048);
    }

    public boolean isStrict() {
        return this.isSet(2048);
    }

    private boolean isSet(int flag) {
        return (this.flags & flag) != 0;
    }

    private void set(int flag) {
        this.flags |= flag;
    }

    public String toString() {
        List<BooleanSupplier> predicates = this.getPredicates();
        StringBuilder builder = new StringBuilder();
        boolean space = false;
        for (int i = 0; i < NAMES.size(); ++i) {
            if (!predicates.get(i).getAsBoolean()) continue;
            if (space) {
                builder.append(' ');
            } else {
                space = true;
            }
            builder.append(NAMES.get(i));
        }
        return builder.toString();
    }
}

