/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dex;

import com.android.tools.r8.com.google.common.collect.Iterators;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.dex.ApplicationWriter;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.dex.InheritanceClassInDexDistributor;
import com.android.tools.r8.errors.InternalCompilerError;
import com.android.tools.r8.errors.MainDexOverflow;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.StringDiagnostic;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class VirtualFile {
    public static final int MAX_ENTRIES = 65536;
    private static final int MAX_PREFILL_ENTRIES = 60536;
    private final int id;
    private final VirtualFileIndexedItemCollection indexedItems;
    private final IndexedItemTransaction transaction;
    private final DexProgramClass primaryClass;

    VirtualFile(int id, NamingLens namingLens) {
        this(id, namingLens, null);
    }

    private VirtualFile(int id, NamingLens namingLens, DexProgramClass primaryClass) {
        this.id = id;
        this.indexedItems = new VirtualFileIndexedItemCollection(namingLens);
        this.transaction = new IndexedItemTransaction(this.indexedItems, namingLens);
        this.primaryClass = primaryClass;
    }

    public int getId() {
        return this.id;
    }

    public Set<String> getClassDescriptors() {
        HashSet<String> classDescriptors = new HashSet<String>();
        for (DexProgramClass clazz : this.indexedItems.classes) {
            boolean added = classDescriptors.add(clazz.type.descriptor.toString());
            assert (added);
        }
        return classDescriptors;
    }

    public String getPrimaryClassDescriptor() {
        return this.primaryClass == null ? null : this.primaryClass.type.descriptor.toString();
    }

    public static String deriveCommonPrefixAndSanityCheck(List<String> fileNames) {
        Iterator<String> nameIterator = fileNames.iterator();
        String first = nameIterator.next();
        if (!first.toLowerCase().endsWith(".dex")) {
            throw new RuntimeException("Illegal suffix for dex file: `" + first + "`.");
        }
        String prefix = first.substring(0, first.length() - ".dex".length());
        int index = 2;
        while (nameIterator.hasNext()) {
            String next = nameIterator.next();
            if (!next.toLowerCase().endsWith(".dex")) {
                throw new RuntimeException("Illegal suffix for dex file: `" + first + "`.");
            }
            if (!next.startsWith(prefix)) {
                throw new RuntimeException("Input filenames lack common prefix.");
            }
            String numberPart = next.substring(prefix.length(), next.length() - ".dex".length());
            if (Integer.parseInt(numberPart) == index++) continue;
            throw new RuntimeException("DEX files are not numbered consecutively.");
        }
        return prefix;
    }

    private static Map<DexProgramClass, String> computeOriginalNameMapping(Collection<DexProgramClass> classes, ClassNameMapper proguardMap) {
        HashMap<DexProgramClass, String> originalNames = new HashMap<DexProgramClass, String>();
        classes.forEach(c -> originalNames.put((DexProgramClass)c, DescriptorUtils.descriptorToJavaType(c.type.toDescriptorString(), proguardMap)));
        return originalNames;
    }

    private static String extractPrefixToken(int prefixLength, String className, boolean addStar) {
        int index = 0;
        int lastIndex = 0;
        int segmentCount = 0;
        while (lastIndex != -1 && segmentCount++ < prefixLength) {
            index = lastIndex;
            lastIndex = className.indexOf(46, index + 1);
        }
        String prefix = className.substring(0, index);
        if (addStar && segmentCount >= prefixLength) {
            prefix = prefix + ".*";
        }
        return prefix;
    }

    public ObjectToOffsetMapping computeMapping(DexApplication application) {
        assert (this.transaction.isEmpty());
        return new ObjectToOffsetMapping(application, this.indexedItems.classes, this.indexedItems.protos, this.indexedItems.types, this.indexedItems.methods, this.indexedItems.fields, this.indexedItems.strings, this.indexedItems.callSites, this.indexedItems.methodHandles);
    }

    void addClass(DexProgramClass clazz) {
        this.transaction.addClassAndDependencies(clazz);
    }

    public boolean isFull(int maxEntries) {
        return this.transaction.getNumberOfMethods() > maxEntries || this.transaction.getNumberOfFields() > maxEntries;
    }

    boolean isFull() {
        return this.isFull(65536);
    }

    public int getNumberOfMethods() {
        return this.transaction.getNumberOfMethods();
    }

    public int getNumberOfFields() {
        return this.transaction.getNumberOfFields();
    }

    void throwIfFull(boolean hasMainDexList, Reporter reporter) {
        if (!this.isFull()) {
            return;
        }
        throw reporter.fatalError(new MainDexOverflow(hasMainDexList, this.transaction.getNumberOfMethods(), this.transaction.getNumberOfFields(), 65536L));
    }

    private boolean isFilledEnough(FillStrategy fillStrategy) {
        return this.isFull(fillStrategy == FillStrategy.FILL_MAX ? 65536 : 60536);
    }

    public void abortTransaction() {
        this.transaction.abort();
    }

    public void commitTransaction() {
        this.transaction.commit();
    }

    public boolean isEmpty() {
        return this.indexedItems.classes.isEmpty();
    }

    public Collection<DexProgramClass> classes() {
        return this.indexedItems.classes;
    }

    private static class PackageSplitPopulator
    implements Callable<Map<String, Integer>> {
        private static final int MINIMUM_PREFIX_LENGTH = 4;
        private static final int MAXIMUM_PREFIX_LENGTH = 7;
        private static final int MIN_FILL_FACTOR = 5;
        private final List<DexProgramClass> classes;
        private final Map<DexProgramClass, String> originalNames;
        private final DexItemFactory dexItemFactory;
        private final FillStrategy fillStrategy;
        private final VirtualFileCycler cycler;

        PackageSplitPopulator(List<VirtualFile> files, Set<DexProgramClass> classes, Map<DexProgramClass, String> originalNames, DexItemFactory dexItemFactory, FillStrategy fillStrategy, int fileIndexOffset, NamingLens namingLens) {
            this.classes = new ArrayList<DexProgramClass>(classes);
            this.originalNames = originalNames;
            this.dexItemFactory = dexItemFactory;
            this.fillStrategy = fillStrategy;
            this.cycler = new VirtualFileCycler(files, namingLens, fileIndexOffset);
        }

        static boolean coveredByPrefix(String originalName, String currentPrefix) {
            if (currentPrefix == null) {
                return false;
            }
            if (currentPrefix.endsWith(".*")) {
                return originalName.startsWith(currentPrefix.substring(0, currentPrefix.length() - 2));
            }
            return originalName.startsWith(currentPrefix) && originalName.lastIndexOf(46) == currentPrefix.length();
        }

        private String getOriginalName(DexProgramClass clazz) {
            return this.originalNames != null ? this.originalNames.get(clazz) : clazz.toString();
        }

        @Override
        public Map<String, Integer> call() throws IOException {
            int prefixLength = 4;
            int transactionStartIndex = 0;
            int fileStartIndex = 0;
            String currentPrefix = null;
            LinkedHashMap<String, Integer> newPackageAssignments = new LinkedHashMap<String, Integer>();
            VirtualFile current = this.cycler.next();
            ArrayList<DexProgramClass> nonPackageClasses = new ArrayList<DexProgramClass>();
            for (int classIndex = 0; classIndex < this.classes.size(); ++classIndex) {
                DexProgramClass clazz = this.classes.get(classIndex);
                String originalName = this.getOriginalName(clazz);
                if (!PackageSplitPopulator.coveredByPrefix(originalName, currentPrefix)) {
                    String newPrefix;
                    if (currentPrefix != null) {
                        current.commitTransaction();
                        this.cycler.restart();
                        assert (!newPackageAssignments.containsKey(currentPrefix));
                        newPackageAssignments.put(currentPrefix, current.id);
                        prefixLength = 3;
                    }
                    do {
                        newPrefix = VirtualFile.extractPrefixToken(++prefixLength, originalName, false);
                    } while (currentPrefix != null && currentPrefix.startsWith(newPrefix));
                    if (!newPrefix.equals("")) {
                        currentPrefix = VirtualFile.extractPrefixToken(prefixLength, originalName, true);
                    }
                    transactionStartIndex = classIndex;
                }
                if (currentPrefix != null) {
                    assert (clazz.superType != null || clazz.type == this.dexItemFactory.objectType);
                } else {
                    assert (clazz.superType != null);
                    assert (current.transaction.classes.isEmpty());
                    nonPackageClasses.add(clazz);
                    continue;
                }
                current.addClass(clazz);
                if (!current.isFilledEnough(this.fillStrategy) && !current.isFull()) continue;
                current.abortTransaction();
                if (classIndex - transactionStartIndex > (classIndex - fileStartIndex) / 5 && prefixLength < 7) {
                    ++prefixLength;
                } else {
                    fileStartIndex = transactionStartIndex;
                    if (!this.cycler.hasNext()) {
                        if (current.transaction.getNumberOfClasses() == 0) {
                            for (int j = transactionStartIndex; j <= classIndex; ++j) {
                                nonPackageClasses.add(this.classes.get(j));
                            }
                            transactionStartIndex = classIndex + 1;
                        }
                        this.cycler.addFile();
                    }
                    current = this.cycler.next();
                }
                currentPrefix = null;
                classIndex = transactionStartIndex - 1;
                assert (current != null);
            }
            current.commitTransaction();
            assert (!newPackageAssignments.containsKey(currentPrefix));
            if (currentPrefix != null) {
                newPackageAssignments.put(currentPrefix, current.id);
            }
            if (nonPackageClasses.size() > 0) {
                this.addNonPackageClasses(this.cycler, nonPackageClasses);
            }
            return newPackageAssignments;
        }

        private void addNonPackageClasses(VirtualFileCycler cycler, List<DexProgramClass> nonPackageClasses) {
            cycler.restart();
            VirtualFile current = cycler.next();
            for (DexProgramClass clazz : nonPackageClasses) {
                if (current.isFilledEnough(this.fillStrategy)) {
                    current = this.getVirtualFile(cycler);
                }
                current.addClass(clazz);
                while (current.isFull()) {
                    current.abortTransaction();
                    current = this.getVirtualFile(cycler);
                    boolean wasEmpty = current.isEmpty();
                    current.addClass(clazz);
                    if (!wasEmpty || !current.isFull()) continue;
                    throw new InternalCompilerError("Class " + clazz.toString() + " does not fit into a single dex file.");
                }
                current.commitTransaction();
            }
        }

        private VirtualFile getVirtualFile(VirtualFileCycler cycler) {
            VirtualFile current = null;
            while (cycler.hasNext() && (current = cycler.next()).isFilledEnough(this.fillStrategy)) {
            }
            if (current == null || current.isFilledEnough(this.fillStrategy)) {
                current = cycler.addFile();
            }
            return current;
        }
    }

    static class VirtualFileCycler {
        private final List<VirtualFile> files;
        private final NamingLens namingLens;
        private int nextFileId;
        private Iterator<VirtualFile> allFilesCyclic;
        private Iterator<VirtualFile> activeFiles;

        VirtualFileCycler(List<VirtualFile> files, NamingLens namingLens, int fileIndexOffset) {
            this.files = files;
            this.namingLens = namingLens;
            this.nextFileId = files.size() + fileIndexOffset;
            this.reset();
        }

        void reset() {
            this.allFilesCyclic = Iterators.cycle(this.files);
            this.restart();
        }

        boolean hasNext() {
            return this.activeFiles.hasNext();
        }

        VirtualFile next() {
            return this.activeFiles.next();
        }

        VirtualFile nextOrCreate() {
            if (this.hasNext()) {
                return this.activeFiles.next();
            }
            VirtualFile newFile = new VirtualFile(this.nextFileId++, this.namingLens);
            this.files.add(newFile);
            this.allFilesCyclic = Iterators.cycle(this.files);
            return newFile;
        }

        VirtualFile nextOrCreate(Predicate<? super VirtualFile> filter) {
            VirtualFile dex;
            do {
                if (!(dex = this.nextOrCreate()).isEmpty()) continue;
                assert (filter.test(dex));
                return dex;
            } while (!filter.test(dex));
            return dex;
        }

        void restart() {
            this.activeFiles = Iterators.limit(this.allFilesCyclic, this.files.size());
        }

        VirtualFile addFile() {
            VirtualFile newFile = new VirtualFile(this.nextFileId++, this.namingLens);
            this.files.add(newFile);
            this.reset();
            return newFile;
        }
    }

    private static class IndexedItemTransaction
    implements IndexedItemCollection {
        private final VirtualFileIndexedItemCollection base;
        private final NamingLens namingLens;
        private final Set<DexProgramClass> classes = new LinkedHashSet<DexProgramClass>();
        private final Set<DexField> fields = new LinkedHashSet<DexField>();
        private final Set<DexMethod> methods = new LinkedHashSet<DexMethod>();
        private final Set<DexType> types = new LinkedHashSet<DexType>();
        private final Set<DexProto> protos = new LinkedHashSet<DexProto>();
        private final Set<DexString> strings = new LinkedHashSet<DexString>();
        private final Set<DexCallSite> callSites = new LinkedHashSet<DexCallSite>();
        private final Set<DexMethodHandle> methodHandles = new LinkedHashSet<DexMethodHandle>();

        private IndexedItemTransaction(VirtualFileIndexedItemCollection base, NamingLens namingLens) {
            this.base = base;
            this.namingLens = namingLens;
        }

        private <T extends DexItem> boolean maybeInsert(T item, Set<T> set, Set<T> baseSet) {
            if (baseSet.contains(item) || set.contains(item)) {
                return false;
            }
            set.add(item);
            return true;
        }

        void addClassAndDependencies(DexProgramClass clazz) {
            clazz.collectIndexedItems(this);
        }

        @Override
        public boolean addClass(DexProgramClass dexProgramClass) {
            return this.maybeInsert(dexProgramClass, this.classes, this.base.classes);
        }

        @Override
        public boolean addField(DexField field) {
            return this.maybeInsert(field, this.fields, this.base.fields);
        }

        @Override
        public boolean addMethod(DexMethod method) {
            return this.maybeInsert(method, this.methods, this.base.methods);
        }

        @Override
        public boolean addString(DexString string) {
            return this.maybeInsert(string, this.strings, this.base.strings);
        }

        @Override
        public boolean addProto(DexProto proto) {
            return this.maybeInsert(proto, this.protos, this.base.protos);
        }

        @Override
        public boolean addType(DexType type) {
            return this.maybeInsert(type, this.types, this.base.types);
        }

        @Override
        public boolean addCallSite(DexCallSite callSite) {
            return this.maybeInsert(callSite, this.callSites, this.base.callSites);
        }

        @Override
        public boolean addMethodHandle(DexMethodHandle methodHandle) {
            return this.maybeInsert(methodHandle, this.methodHandles, this.base.methodHandles);
        }

        @Override
        public DexString getRenamedDescriptor(DexType type) {
            return this.namingLens.lookupDescriptor(type);
        }

        @Override
        public DexString getRenamedName(DexMethod method) {
            assert (this.namingLens.checkTargetCanBeTranslated(method));
            return this.namingLens.lookupName(method);
        }

        @Override
        public DexString getRenamedName(DexField field) {
            return this.namingLens.lookupName(field);
        }

        int getNumberOfMethods() {
            return this.methods.size() + this.base.getNumberOfMethods();
        }

        int getNumberOfFields() {
            return this.fields.size() + this.base.getNumberOfFields();
        }

        private <T extends DexItem> void commitItemsIn(Set<T> set, Function<T, Boolean> hook) {
            set.forEach(item -> {
                boolean newlyAdded = (Boolean)hook.apply(item);
                assert (newlyAdded);
            });
            set.clear();
        }

        void commit() {
            this.commitItemsIn(this.classes, this.base::addClass);
            this.commitItemsIn(this.fields, this.base::addField);
            this.commitItemsIn(this.methods, this.base::addMethod);
            this.commitItemsIn(this.protos, this.base::addProto);
            this.commitItemsIn(this.types, this.base::addType);
            this.commitItemsIn(this.strings, this.base::addString);
            this.commitItemsIn(this.callSites, this.base::addCallSite);
            this.commitItemsIn(this.methodHandles, this.base::addMethodHandle);
        }

        void abort() {
            this.classes.clear();
            this.fields.clear();
            this.methods.clear();
            this.protos.clear();
            this.types.clear();
            this.strings.clear();
        }

        public boolean isEmpty() {
            return this.classes.isEmpty() && this.fields.isEmpty() && this.methods.isEmpty() && this.protos.isEmpty() && this.types.isEmpty() && this.strings.isEmpty();
        }

        int getNumberOfClasses() {
            return this.classes.size() + this.base.classes.size();
        }
    }

    private static class VirtualFileIndexedItemCollection
    implements IndexedItemCollection {
        private final NamingLens namingLens;
        private final Set<DexProgramClass> classes = Sets.newIdentityHashSet();
        private final Set<DexProto> protos = Sets.newIdentityHashSet();
        private final Set<DexType> types = Sets.newIdentityHashSet();
        private final Set<DexMethod> methods = Sets.newIdentityHashSet();
        private final Set<DexField> fields = Sets.newIdentityHashSet();
        private final Set<DexString> strings = Sets.newIdentityHashSet();
        private final Set<DexCallSite> callSites = Sets.newIdentityHashSet();
        private final Set<DexMethodHandle> methodHandles = Sets.newIdentityHashSet();

        public VirtualFileIndexedItemCollection(NamingLens namingLens) {
            this.namingLens = namingLens;
        }

        @Override
        public boolean addClass(DexProgramClass clazz) {
            return this.classes.add(clazz);
        }

        @Override
        public boolean addField(DexField field) {
            return this.fields.add(field);
        }

        @Override
        public boolean addMethod(DexMethod method) {
            return this.methods.add(method);
        }

        @Override
        public boolean addString(DexString string) {
            return this.strings.add(string);
        }

        @Override
        public boolean addProto(DexProto proto) {
            return this.protos.add(proto);
        }

        @Override
        public boolean addType(DexType type) {
            return this.types.add(type);
        }

        @Override
        public boolean addCallSite(DexCallSite callSite) {
            return this.callSites.add(callSite);
        }

        @Override
        public boolean addMethodHandle(DexMethodHandle methodHandle) {
            return this.methodHandles.add(methodHandle);
        }

        int getNumberOfMethods() {
            return this.methods.size();
        }

        int getNumberOfFields() {
            return this.fields.size();
        }

        int getNumberOfStrings() {
            return this.strings.size();
        }

        @Override
        public DexString getRenamedDescriptor(DexType type) {
            return this.namingLens.lookupDescriptor(type);
        }

        @Override
        public DexString getRenamedName(DexMethod method) {
            assert (this.namingLens.checkTargetCanBeTranslated(method));
            return this.namingLens.lookupName(method);
        }

        @Override
        public DexString getRenamedName(DexField field) {
            return this.namingLens.lookupName(field);
        }
    }

    public static class MonoDexDistributor
    extends DistributorBase {
        MonoDexDistributor(ApplicationWriter writer, InternalOptions options) {
            super(writer, options);
        }

        @Override
        public Collection<VirtualFile> run() throws ExecutionException, IOException {
            for (DexProgramClass programClass : this.classes) {
                this.mainDexFile.addClass(programClass);
            }
            this.mainDexFile.commitTransaction();
            this.mainDexFile.throwIfFull(false, this.options.reporter);
            return this.virtualFiles;
        }
    }

    public static class FillFilesDistributor
    extends DistributorBase {
        private final FillStrategy fillStrategy = FillStrategy.FILL_MAX;
        private final ExecutorService executorService;

        FillFilesDistributor(ApplicationWriter writer, InternalOptions options, ExecutorService executorService) {
            super(writer, options);
            this.executorService = executorService;
        }

        @Override
        public Collection<VirtualFile> run() throws IOException {
            boolean multidexLegacy;
            int totalClassNumber = this.classes.size();
            this.fillForMainDexList(this.classes);
            if (this.classes.isEmpty()) {
                return this.virtualFiles;
            }
            List<VirtualFile> filesForDistribution = this.virtualFiles;
            int fileIndexOffset = 0;
            boolean bl = multidexLegacy = !this.mainDexFile.isEmpty();
            if (this.options.minimalMainDex && multidexLegacy) {
                assert (!((VirtualFile)this.virtualFiles.get(0)).isEmpty());
                assert (this.virtualFiles.size() == 1);
                this.virtualFiles.add(new VirtualFile(1, this.writer.namingLens));
                filesForDistribution = this.virtualFiles.subList(1, this.virtualFiles.size());
                fileIndexOffset = 1;
            }
            if (multidexLegacy && this.options.enableInheritanceClassInDexDistributor) {
                new InheritanceClassInDexDistributor(this.mainDexFile, filesForDistribution, this.classes, this.originalNames, fileIndexOffset, this.writer.namingLens, this.writer.application, this.executorService).distribute();
            } else {
                this.classes = this.sortClassesByPackage(this.classes, this.originalNames);
                new PackageSplitPopulator(filesForDistribution, this.classes, this.originalNames, this.application.dexItemFactory, this.fillStrategy, fileIndexOffset, this.writer.namingLens).call();
            }
            assert (totalClassNumber == this.virtualFiles.stream().mapToInt(dex -> dex.classes().size()).sum());
            return this.virtualFiles;
        }
    }

    public static abstract class DistributorBase
    extends Distributor {
        protected Set<DexProgramClass> classes;
        protected Map<DexProgramClass, String> originalNames;
        protected final VirtualFile mainDexFile;
        protected final InternalOptions options;

        DistributorBase(ApplicationWriter writer, InternalOptions options) {
            super(writer);
            this.options = options;
            this.mainDexFile = new VirtualFile(0, writer.namingLens);
            assert (this.virtualFiles.isEmpty());
            this.virtualFiles.add(this.mainDexFile);
            if (writer.markerStrings != null && !writer.markerStrings.isEmpty()) {
                for (DexString markerString : writer.markerStrings) {
                    this.mainDexFile.transaction.addString(markerString);
                }
                this.mainDexFile.commitTransaction();
            }
            this.classes = Sets.newHashSet(this.application.classes());
            this.originalNames = VirtualFile.computeOriginalNameMapping(this.classes, this.application.getProguardMap());
        }

        protected void fillForMainDexList(Set<DexProgramClass> classes) {
            if (!this.application.mainDexList.isEmpty()) {
                VirtualFile mainDexFile = (VirtualFile)this.virtualFiles.get(0);
                for (DexType type : this.application.mainDexList) {
                    DexClass clazz = this.application.definitionFor(type);
                    if (clazz != null && clazz.isProgramClass()) {
                        DexProgramClass programClass = (DexProgramClass)clazz;
                        mainDexFile.addClass(programClass);
                        classes.remove(programClass);
                    } else {
                        this.options.reporter.warning(new StringDiagnostic("Application does not contain `" + type.toSourceString() + "` as referenced in main-dex-list."));
                    }
                    mainDexFile.commitTransaction();
                }
                mainDexFile.throwIfFull(true, this.options.reporter);
            }
        }

        TreeSet<DexProgramClass> sortClassesByPackage(Set<DexProgramClass> classes, Map<DexProgramClass, String> originalNames) {
            TreeSet<DexProgramClass> sortedClasses = new TreeSet<DexProgramClass>((a, b) -> {
                String prefixB;
                String originalA = (String)originalNames.get(a);
                String originalB = (String)originalNames.get(b);
                int indexA = originalA.lastIndexOf(46);
                int indexB = originalB.lastIndexOf(46);
                if (indexA == -1 && indexB == -1) {
                    return originalA.compareTo(originalB);
                }
                if (indexA == -1) {
                    return -1;
                }
                if (indexB == -1) {
                    return 1;
                }
                String prefixA = originalA.substring(0, indexA);
                int result = prefixA.compareTo(prefixB = originalB.substring(0, indexB));
                if (result != 0) {
                    return result;
                }
                return originalA.compareTo(originalB);
            });
            sortedClasses.addAll(classes);
            return sortedClasses;
        }
    }

    public static class FilePerInputClassDistributor
    extends Distributor {
        private final boolean combineSyntheticClassesWithPrimaryClass;

        FilePerInputClassDistributor(ApplicationWriter writer, boolean combineSyntheticClassesWithPrimaryClass) {
            super(writer);
            this.combineSyntheticClassesWithPrimaryClass = combineSyntheticClassesWithPrimaryClass;
        }

        @Override
        public Collection<VirtualFile> run() {
            HashMap<DexProgramClass, VirtualFile> files = new HashMap<DexProgramClass, VirtualFile>();
            ArrayList<DexProgramClass> synthetics = new ArrayList<DexProgramClass>();
            for (DexProgramClass clazz : this.application.classes()) {
                if (!this.combineSyntheticClassesWithPrimaryClass || clazz.getSynthesizedFrom().isEmpty()) {
                    VirtualFile file = new VirtualFile(this.virtualFiles.size(), this.writer.namingLens, clazz);
                    this.virtualFiles.add(file);
                    file.addClass(clazz);
                    files.put(clazz, file);
                    file.commitTransaction();
                    continue;
                }
                synthetics.add(clazz);
            }
            for (DexProgramClass synthetic : synthetics) {
                for (DexProgramClass inputType : synthetic.getSynthesizedFrom()) {
                    VirtualFile file = (VirtualFile)files.get(inputType);
                    file.addClass(synthetic);
                    file.commitTransaction();
                }
            }
            return this.virtualFiles;
        }
    }

    public static abstract class Distributor {
        protected final DexApplication application;
        protected final ApplicationWriter writer;
        protected final List<VirtualFile> virtualFiles = new ArrayList<VirtualFile>();

        Distributor(ApplicationWriter writer) {
            this.application = writer.application;
            this.writer = writer;
        }

        public abstract Collection<VirtualFile> run() throws ExecutionException, IOException;
    }

    static enum FillStrategy {
        FILL_MAX,
        LEAVE_SPACE_FOR_GROWTH;

    }
}

