/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.cf.CfPrinter;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfLabel;
import com.android.tools.r8.cf.code.CfPosition;
import com.android.tools.r8.cf.code.CfReturnVoid;
import com.android.tools.r8.cf.code.CfTryCatch;
import com.android.tools.r8.errors.Unimplemented;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.ValueNumberGenerator;
import com.android.tools.r8.ir.conversion.CfSourceCode;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.Label;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.InternalOptions;
import java.util.Collections;
import java.util.List;

public class CfCode
extends Code {
    private final DexMethod method;
    private final int maxStack;
    private final int maxLocals;
    private final List<CfInstruction> instructions;
    private final List<CfTryCatch> tryCatchRanges;
    private final List<LocalVariableInfo> localVariables;

    public CfCode(DexMethod method, int maxStack, int maxLocals, List<CfInstruction> instructions, List<CfTryCatch> tryCatchRanges, List<LocalVariableInfo> localVariables) {
        this.method = method;
        this.maxStack = maxStack;
        this.maxLocals = maxLocals;
        this.instructions = instructions;
        this.tryCatchRanges = tryCatchRanges;
        this.localVariables = localVariables;
    }

    public DexMethod getMethod() {
        return this.method;
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public List<CfTryCatch> getTryCatchRanges() {
        return this.tryCatchRanges;
    }

    public List<CfInstruction> getInstructions() {
        return Collections.unmodifiableList(this.instructions);
    }

    public List<LocalVariableInfo> getLocalVariables() {
        return Collections.unmodifiableList(this.localVariables);
    }

    @Override
    public int estimatedSizeForInlining() {
        return this.countNonStackOperations(Integer.MAX_VALUE);
    }

    @Override
    public boolean estimatedSizeForInliningAtMost(int threshold) {
        return this.countNonStackOperations(threshold) <= threshold;
    }

    private int countNonStackOperations(int threshold) {
        int result = 0;
        for (CfInstruction instruction : this.instructions) {
            if (instruction.emitsIR() && ++result > threshold) break;
        }
        return result;
    }

    @Override
    public boolean isCfCode() {
        return true;
    }

    @Override
    public CfCode asCfCode() {
        return this;
    }

    public void write(MethodVisitor visitor, NamingLens namingLens) {
        for (CfInstruction instruction : this.instructions) {
            instruction.write(visitor, namingLens);
        }
        visitor.visitEnd();
        visitor.visitMaxs(this.maxStack, this.maxLocals);
        for (CfTryCatch tryCatch : this.tryCatchRanges) {
            Label start = tryCatch.start.getLabel();
            Label end = tryCatch.end.getLabel();
            for (int i = 0; i < tryCatch.guards.size(); ++i) {
                DexType guard = tryCatch.guards.get(i);
                Label target = tryCatch.targets.get(i).getLabel();
                visitor.visitTryCatchBlock(start, end, target, guard == DexItemFactory.catchAllType ? null : namingLens.lookupInternalName(guard));
            }
        }
        for (LocalVariableInfo localVariable : this.localVariables) {
            DebugLocalInfo info = localVariable.local;
            visitor.visitLocalVariable(info.name.toString(), namingLens.lookupDescriptor(info.type).toString(), info.signature == null ? null : info.signature.toString(), localVariable.start.getLabel(), localVariable.end.getLabel(), localVariable.index);
        }
    }

    @Override
    protected int computeHashCode() {
        throw new Unimplemented();
    }

    @Override
    protected boolean computeEquals(Object other) {
        throw new Unimplemented();
    }

    @Override
    public boolean isEmptyVoidMethod() {
        for (CfInstruction insn : this.instructions) {
            if (insn instanceof CfReturnVoid || insn instanceof CfLabel || insn instanceof CfPosition) continue;
            return false;
        }
        return true;
    }

    @Override
    public IRCode buildIR(DexEncodedMethod encodedMethod, AppInfo appInfo, GraphLense graphLense, InternalOptions options, Origin origin) {
        assert (this.getOwner() == encodedMethod);
        return this.internalBuild(encodedMethod, appInfo, graphLense, options, null, null, origin);
    }

    @Override
    public IRCode buildInliningIR(DexEncodedMethod encodedMethod, AppInfo appInfo, GraphLense graphLense, InternalOptions options, ValueNumberGenerator valueNumberGenerator, Position callerPosition, Origin origin) {
        assert (this.getOwner() == encodedMethod);
        assert (valueNumberGenerator != null);
        assert (callerPosition != null);
        return this.internalBuild(encodedMethod, appInfo, graphLense, options, valueNumberGenerator, callerPosition, origin);
    }

    private IRCode internalBuild(DexEncodedMethod encodedMethod, AppInfo appInfo, GraphLense graphLense, InternalOptions options, ValueNumberGenerator generator, Position callerPosition, Origin origin) {
        if (options.isGeneratingDex() && encodedMethod.accessFlags.isSynchronized()) {
            throw new Unimplemented("Converting CfCode to IR not supported for DEX output of synchronized methods.");
        }
        CfSourceCode source = new CfSourceCode(this, encodedMethod, graphLense.getOriginalMethodSignature(encodedMethod.method), callerPosition, origin);
        return new IRBuilder(encodedMethod, appInfo, source, options, generator).build();
    }

    @Override
    public void registerCodeReferences(UseRegistry registry) {
        for (CfInstruction instruction : this.instructions) {
            instruction.registerUse(registry, this.method.holder);
        }
        for (CfTryCatch tryCatch : this.tryCatchRanges) {
            for (DexType guard : tryCatch.guards) {
                if (guard == DexItemFactory.catchAllType) continue;
                registry.registerTypeReference(guard);
            }
        }
    }

    @Override
    public String toString() {
        return new CfPrinter(this, null).toString();
    }

    @Override
    public String toString(DexEncodedMethod method, ClassNameMapper naming) {
        return new CfPrinter(this, naming).toString();
    }

    public static class LocalVariableInfo {
        private final int index;
        private final DebugLocalInfo local;
        private final CfLabel start;
        private CfLabel end;

        public LocalVariableInfo(int index, DebugLocalInfo local, CfLabel start) {
            this.index = index;
            this.local = local;
            this.start = start;
        }

        public LocalVariableInfo(int index, DebugLocalInfo local, CfLabel start, CfLabel end) {
            this(index, local, start);
            this.setEnd(end);
        }

        public void setEnd(CfLabel end) {
            assert (this.end == null);
            assert (end != null);
            this.end = end;
        }

        public int getIndex() {
            return this.index;
        }

        public DebugLocalInfo getLocal() {
            return this.local;
        }

        public CfLabel getStart() {
            return this.start;
        }

        public CfLabel getEnd() {
            return this.end;
        }

        public String toString() {
            return "" + this.index + " => " + this.local;
        }
    }
}

