/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.StringConsumer;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.utils.AbortException;
import com.android.tools.r8.utils.ExceptionDiagnostic;
import com.android.tools.r8.utils.Reporter;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.Paths;
import java.util.function.Consumer;

public abstract class ExceptionUtils {
    public static final int STATUS_ERROR = 1;

    public static void withConsumeResourceHandler(Reporter reporter, StringConsumer consumer, String data) {
        ExceptionUtils.withConsumeResourceHandler(reporter, handler -> consumer.accept(data, (DiagnosticsHandler)handler));
    }

    public static void withConsumeResourceHandler(Reporter reporter, Consumer<DiagnosticsHandler> consumer) {
        consumer.accept(reporter);
        reporter.failIfPendingErrors();
    }

    public static void withD8CompilationHandler(Reporter reporter, CompileAction action) throws CompilationFailedException {
        ExceptionUtils.withCompilationHandler(reporter, action);
    }

    public static void withR8CompilationHandler(Reporter reporter, CompileAction action) throws CompilationFailedException {
        ExceptionUtils.withCompilationHandler(reporter, action);
    }

    public static void withMainDexListHandler(Reporter reporter, CompileAction action) throws CompilationFailedException {
        ExceptionUtils.withCompilationHandler(reporter, action);
    }

    public static void withCompilationHandler(Reporter reporter, CompileAction action) throws CompilationFailedException {
        try {
            try {
                action.run();
            }
            catch (IOException e) {
                throw reporter.fatalError(new ExceptionDiagnostic(e, ExceptionUtils.extractIOExceptionOrigin(e)));
            }
            catch (CompilationError e) {
                throw reporter.fatalError(e);
            }
            catch (ResourceException e) {
                throw reporter.fatalError(new ExceptionDiagnostic(e, e.getOrigin()));
            }
            reporter.failIfPendingErrors();
        }
        catch (AbortException e) {
            throw new CompilationFailedException(e);
        }
    }

    public static void withMainProgramHandler(MainAction action) {
        try {
            action.run();
        }
        catch (CompilationFailedException | AbortException e) {
            System.err.println("Compilation failed");
            System.exit(1);
        }
        catch (RuntimeException e) {
            System.err.println("Compilation failed with an internal error.");
            Throwable cause = e.getCause() == null ? e : e.getCause();
            cause.printStackTrace();
            System.exit(1);
        }
    }

    public static Origin extractIOExceptionOrigin(IOException e) {
        FileSystemException fse;
        if (e instanceof FileSystemException && (fse = (FileSystemException)e).getFile() != null && !fse.getFile().isEmpty()) {
            return new PathOrigin(Paths.get(fse.getFile(), new String[0]));
        }
        return Origin.unknown();
    }

    public static interface MainAction {
        public void run() throws CompilationFailedException;
    }

    public static interface CompileAction {
        public void run() throws IOException, CompilationError, ResourceException;
    }
}

