/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.ExtractMarkerCommand;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.dex.Marker;
import com.android.tools.r8.dex.VDexParser;
import com.android.tools.r8.dex.VDexReader;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Timing;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.concurrent.ExecutionException;

public class ExtractMarker {
    public static Collection<Marker> extractMarkerFromDexFile(Path file) throws IOException, ExecutionException, ResourceException {
        AndroidApp.Builder appBuilder = AndroidApp.builder();
        ExtractMarker.addDexResources(appBuilder, file);
        return ExtractMarker.extractMarker(appBuilder.build());
    }

    public static int extractDexSize(Path file) throws IOException, ResourceException {
        AndroidApp.Builder appBuilder = AndroidApp.builder();
        ExtractMarker.addDexResources(appBuilder, file);
        int size = 0;
        for (ProgramResource resource : appBuilder.build().computeAllProgramResources()) {
            if (resource.getKind() != ProgramResource.Kind.DEX) continue;
            InputStream input = resource.getByteStream();
            Throwable throwable = null;
            try {
                size += ByteStreams.toByteArray(input).length;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (input == null) continue;
                ExtractMarker.$closeResource(throwable, input);
            }
        }
        return size;
    }

    public static Collection<Marker> extractMarkerFromDexProgramData(byte[] data) throws IOException, ExecutionException {
        AndroidApp app = AndroidApp.builder().addDexProgramData(data, Origin.unknown()).build();
        return ExtractMarker.extractMarker(app);
    }

    private static void addDexResources(AndroidApp.Builder appBuilder, Path file) throws IOException, ResourceException {
        if (FileUtils.isVDexFile(file)) {
            PathOrigin vdexOrigin = new PathOrigin(file);
            try (InputStream fileInputStream = Files.newInputStream(file, new OpenOption[0]);){
                VDexReader vdexReader = new VDexReader((Origin)vdexOrigin, fileInputStream);
                VDexParser vDexParser = new VDexParser(vdexReader);
                int index = 0;
                for (byte[] bytes : vDexParser.getDexFiles()) {
                    appBuilder.addDexProgramData(bytes, new VdexOrigin(vdexOrigin, index));
                    ++index;
                }
            }
        } else {
            appBuilder.addProgramFiles(file);
        }
    }

    private static Collection<Marker> extractMarker(AndroidApp app) throws IOException, ExecutionException {
        InternalOptions options = new InternalOptions();
        options.skipReadingDexCode = true;
        options.minApiLevel = AndroidApiLevel.P.getLevel();
        DexApplication dexApp = new ApplicationReader(app, options, new Timing("ExtractMarker")).read();
        return dexApp.dexItemFactory.extractMarker();
    }

    public static void main(String[] args) throws IOException, ExecutionException, ResourceException {
        ExtractMarkerCommand.Builder builder = ExtractMarkerCommand.parse(args);
        ExtractMarkerCommand command = builder.build();
        if (command.isPrintHelp()) {
            System.out.println(ExtractMarkerCommand.USAGE_MESSAGE);
            return;
        }
        Path cwd = Paths.get(System.getProperty("user.dir"), new String[0]);
        int d8Count = 0;
        int r8Count = 0;
        int otherCount = 0;
        for (Path programFile : command.getProgramFiles()) {
            Collection<Marker> markers;
            try {
                markers = ExtractMarker.extractMarkerFromDexFile(programFile);
            }
            catch (CompilationError e) {
                System.out.println("Failed to read dex/vdex file `" + programFile + "`: '" + e.getMessage() + "'");
                continue;
            }
            System.out.print("In file: " + cwd.relativize(programFile));
            System.out.println(", " + ExtractMarker.extractDexSize(programFile) + " bytes:");
            for (Marker marker : markers) {
                if (marker == null) {
                    ++otherCount;
                    if (!command.getIncludeOther()) {
                        continue;
                    }
                } else if (marker.isD8()) {
                    ++d8Count;
                } else {
                    ++r8Count;
                }
                if (command.getCSV()) {
                    System.out.print("\"" + programFile + "\"");
                    System.out.print(", ");
                    if (marker == null) {
                        System.out.print("\"no marker\"");
                    } else {
                        System.out.print("\"" + (marker.isD8() ? "D8" : "R8") + "\"");
                    }
                    System.out.print(", ");
                    System.out.print(ExtractMarker.extractDexSize(programFile));
                } else {
                    if (command.getVerbose()) {
                        System.out.print(programFile);
                        System.out.print(": ");
                    }
                    System.out.print(marker == null ? "D8/R8 marker not found" : marker);
                }
                System.out.println();
            }
        }
        if (command.getSummary()) {
            System.out.println("D8: " + d8Count);
            System.out.println("R8: " + r8Count);
            System.out.println("Other: " + otherCount);
            System.out.println("Total: " + (d8Count + r8Count + otherCount));
        }
    }

    public static class VdexOrigin
    extends Origin {
        private final int index;

        public VdexOrigin(Origin vdexOrigin, int index) {
            super(vdexOrigin);
            this.index = index;
        }

        @Override
        public String part() {
            return Integer.toString(this.index);
        }
    }
}

