/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

public class ClassTypeLatticeElement
extends TypeLatticeElement {
    private final DexType classType;
    private final Set<DexType> interfaces;

    ClassTypeLatticeElement(DexType classType, boolean isNullable) {
        this(classType, isNullable, ImmutableSet.of());
    }

    ClassTypeLatticeElement(DexType classType, boolean isNullable, Set<DexType> interfaces) {
        super(isNullable);
        assert (classType.isClassType());
        this.classType = classType;
        this.interfaces = Collections.unmodifiableSet(interfaces);
    }

    public DexType getClassType() {
        return this.classType;
    }

    Set<DexType> getInterfaces() {
        return this.interfaces;
    }

    @Override
    TypeLatticeElement asNullable() {
        return this.isNullable() ? this : new ClassTypeLatticeElement(this.classType, true, this.interfaces);
    }

    @Override
    public TypeLatticeElement asNonNullable() {
        return this.isNullable() ? new ClassTypeLatticeElement(this.classType, false, this.interfaces) : this;
    }

    @Override
    public boolean isClassTypeLatticeElement() {
        return true;
    }

    @Override
    public ClassTypeLatticeElement asClassTypeLatticeElement() {
        return this;
    }

    @Override
    public TypeLatticeElement arrayGet(AppInfo appInfo) {
        return ClassTypeLatticeElement.objectType(appInfo, true);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.isNullableString()).append(this.classType.toString());
        if (!this.interfaces.isEmpty()) {
            builder.append(" [");
            builder.append(this.interfaces.stream().map(DexType::toString).collect(Collectors.joining(", ")));
            builder.append("]");
        }
        return builder.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        ClassTypeLatticeElement other = (ClassTypeLatticeElement)o;
        if (!this.classType.equals(other.classType)) {
            return false;
        }
        if (this.interfaces.size() != other.interfaces.size()) {
            return false;
        }
        return this.interfaces.containsAll(other.interfaces);
    }

    @Override
    public int hashCode() {
        int prime = !this.classType.isUnknown() && this.classType.isInterface() ? 3 : 17;
        return super.hashCode() * this.classType.hashCode() * prime;
    }
}

