/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.string;

import com.android.tools.r8.com.google.common.annotations.VisibleForTesting;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.ConstString;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.Value;
import java.util.List;

public class StringOptimizer {
    @VisibleForTesting
    static boolean isStringLength(DexMethod method, DexItemFactory factory) {
        boolean isStringClass = factory != null ? method.getHolder().equals(factory.stringType) : method.getHolder().toDescriptorString().equals("Ljava/lang/String;");
        return isStringClass && method.getArity() == 0 && method.proto.returnType.isIntType() && method.name.toString().equals("length");
    }

    public void computeConstStringLength(IRCode code, DexItemFactory factory) {
        if (!code.hasConstString) {
            return;
        }
        InstructionIterator it = code.instructionIterator();
        while (it.hasNext()) {
            InvokeVirtual invoke;
            DexMethod invokedMethod;
            Instruction instr = (Instruction)it.next();
            if (!instr.isInvokeVirtual() || !StringOptimizer.isStringLength(invokedMethod = (invoke = instr.asInvokeVirtual()).getInvokedMethod(), factory)) continue;
            List<Value> ins = invoke.arguments();
            assert (ins.size() == 1);
            Value in = ins.get(0);
            if (in.definition == null || !in.definition.isConstString() || !in.definition.outValue().isConstant()) continue;
            ConstString constString = in.definition.asConstString();
            int length = constString.getValue().toString().length();
            ConstNumber constNumber = code.createIntConstant(length);
            it.replaceCurrentInstruction(constNumber);
        }
    }
}

