/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.MethodAccessFlags;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class LambdaDescriptor {
    private static final int LAMBDA_ALT_SERIALIZABLE = 1;
    private static final int LAMBDA_ALT_HAS_EXTRA_INTERFACES = 2;
    private static final int LAMBDA_ALT_HAS_BRIDGES = 4;
    private static final int LAMBDA_ALT_MASK = 7;
    static final LambdaDescriptor MATCH_FAILED = new LambdaDescriptor();
    final String uniqueId;
    final DexString name;
    final DexProto erasedProto;
    final DexProto enforcedProto;
    public final DexMethodHandle implHandle;
    final List<DexType> interfaces = new ArrayList<DexType>();
    final Set<DexProto> bridges = Sets.newIdentityHashSet();
    final DexTypeList captures;
    private final DexEncodedMethod targetMethod;

    private LambdaDescriptor() {
        this.uniqueId = null;
        this.name = null;
        this.erasedProto = null;
        this.enforcedProto = null;
        this.implHandle = null;
        this.captures = null;
        this.targetMethod = null;
    }

    private LambdaDescriptor(AppInfo appInfo, DexCallSite callSite, DexString name, DexProto erasedProto, DexProto enforcedProto, DexMethodHandle implHandle, DexType mainInterface, DexTypeList captures) {
        assert (appInfo != null);
        assert (callSite != null);
        assert (name != null);
        assert (erasedProto != null);
        assert (enforcedProto != null);
        assert (implHandle != null);
        assert (mainInterface != null);
        assert (captures != null);
        this.uniqueId = callSite.getHash();
        this.name = name;
        this.erasedProto = erasedProto;
        this.enforcedProto = enforcedProto;
        this.implHandle = implHandle;
        this.captures = captures;
        this.interfaces.add(mainInterface);
        this.targetMethod = this.lookupTargetMethod(appInfo);
    }

    final DexType getImplReceiverType() {
        DexType[] params = this.enforcedProto.parameters.values;
        DexType[] captures = this.captures.values;
        assert (captures.length > 0 || params.length > 0);
        return captures.length > 0 ? captures[0] : params[0];
    }

    private DexEncodedMethod lookupTargetMethod(AppInfo appInfo) {
        DexMethod method = this.implHandle.asMethod();
        switch (this.implHandle.type) {
            case INVOKE_DIRECT: 
            case INVOKE_INSTANCE: {
                DexEncodedMethod target = appInfo.lookupVirtualTarget(this.getImplReceiverType(), method);
                if (target == null) {
                    target = appInfo.lookupDirectTarget(method);
                }
                assert (target == null || this.implHandle.type.isInvokeInstance() && this.isInstanceMethod(target) || this.implHandle.type.isInvokeDirect() && this.isPrivateInstanceMethod(target) || this.implHandle.type.isInvokeDirect() && this.isPublicizedInstanceMethod(target));
                return target;
            }
            case INVOKE_STATIC: {
                DexEncodedMethod target = appInfo.lookupStaticTarget(method);
                assert (target == null || target.accessFlags.isStatic());
                return target;
            }
            case INVOKE_CONSTRUCTOR: {
                DexEncodedMethod target = appInfo.lookupDirectTarget(method);
                assert (target == null || target.accessFlags.isConstructor());
                return target;
            }
            case INVOKE_INTERFACE: {
                DexEncodedMethod target = appInfo.lookupVirtualTarget(this.getImplReceiverType(), method);
                assert (target == null || this.isInstanceMethod(target));
                return target;
            }
        }
        throw new Unreachable("Unexpected method handle kind in " + this.implHandle);
    }

    private boolean isInstanceMethod(DexEncodedMethod encodedMethod) {
        assert (encodedMethod != null);
        return !encodedMethod.accessFlags.isConstructor() && !encodedMethod.isStatic();
    }

    private boolean isPrivateInstanceMethod(DexEncodedMethod encodedMethod) {
        assert (encodedMethod != null);
        return encodedMethod.isPrivateMethod() && this.isInstanceMethod(encodedMethod);
    }

    private boolean isPublicizedInstanceMethod(DexEncodedMethod encodedMethod) {
        assert (encodedMethod != null);
        return encodedMethod.isPublicized() && this.isInstanceMethod(encodedMethod);
    }

    final MethodAccessFlags getAccessibility() {
        return this.targetMethod == null ? null : this.targetMethod.accessFlags;
    }

    final boolean targetFoundInClass(DexType type) {
        return this.targetMethod != null && this.targetMethod.method.holder == type;
    }

    boolean delegatesToLambdaImplMethod() {
        DexString methodName = this.implHandle.asMethod().name;
        return methodName.toString().startsWith("lambda$");
    }

    final boolean isStateless() {
        return this.captures.isEmpty();
    }

    boolean needsAccessor(DexType accessedFrom) {
        if (this.delegatesToLambdaImplMethod()) {
            return false;
        }
        if (this.implHandle.type.isInvokeInterface()) {
            return false;
        }
        boolean staticTarget = this.implHandle.type.isInvokeStatic();
        boolean instanceTarget = this.implHandle.type.isInvokeInstance() || this.implHandle.type.isInvokeDirect();
        boolean initTarget = this.implHandle.type.isInvokeConstructor();
        assert (instanceTarget || staticTarget || initTarget);
        assert (!this.implHandle.type.isInvokeDirect() || this.isPrivateInstanceMethod(this.targetMethod));
        if (this.targetMethod == null) {
            if (staticTarget || initTarget) {
                boolean accessedFromSamePackage = accessedFrom.getPackageDescriptor().equals(this.implHandle.asMethod().holder.getPackageDescriptor());
                return !accessedFromSamePackage;
            }
            return true;
        }
        MethodAccessFlags flags = this.targetMethod.accessFlags;
        if (flags.isPrivate()) {
            return true;
        }
        if (flags.isPublic()) {
            return false;
        }
        boolean accessedFromSamePackage = accessedFrom.getPackageDescriptor().equals(this.targetMethod.method.holder.getPackageDescriptor());
        assert (flags.isProtected() || accessedFromSamePackage);
        return flags.isProtected() && !accessedFromSamePackage;
    }

    public static LambdaDescriptor tryInfer(DexCallSite callSite, AppInfo appInfo) {
        LambdaDescriptor descriptor = LambdaDescriptor.infer(callSite, appInfo);
        return descriptor == MATCH_FAILED ? null : descriptor;
    }

    static LambdaDescriptor infer(DexCallSite callSite, AppInfo appInfo) {
        if (!callSite.bootstrapMethod.type.isInvokeStatic()) {
            return MATCH_FAILED;
        }
        DexItemFactory factory = appInfo.dexItemFactory;
        DexMethod bootstrapMethod = callSite.bootstrapMethod.asMethod();
        if (!factory.isLambdaMetafactoryMethod(bootstrapMethod)) {
            return MATCH_FAILED;
        }
        DexString funcMethodName = callSite.methodName;
        DexValue.DexValueMethodType funcErasedSignature = LambdaDescriptor.getBootstrapArgument(callSite.bootstrapArgs, 0, DexValue.DexValueMethodType.class);
        DexMethodHandle lambdaImplMethodHandle = (DexMethodHandle)LambdaDescriptor.getBootstrapArgument(callSite.bootstrapArgs, (int)1, DexValue.DexValueMethodHandle.class).value;
        DexValue.DexValueMethodType funcEnforcedSignature = LambdaDescriptor.getBootstrapArgument(callSite.bootstrapArgs, 2, DexValue.DexValueMethodType.class);
        if (!LambdaDescriptor.isEnforcedSignatureValid(factory, (DexProto)funcEnforcedSignature.value, (DexProto)funcErasedSignature.value)) {
            throw new Unreachable("Enforced and erased signatures are inconsistent in " + callSite.toString());
        }
        DexProto lambdaFactoryProto = callSite.methodProto;
        DexType mainFuncInterface = lambdaFactoryProto.returnType;
        DexTypeList captures = lambdaFactoryProto.parameters;
        LambdaDescriptor match = new LambdaDescriptor(appInfo, callSite, funcMethodName, (DexProto)funcErasedSignature.value, (DexProto)funcEnforcedSignature.value, lambdaImplMethodHandle, mainFuncInterface, captures);
        if (bootstrapMethod == factory.metafactoryMethod) {
            if (callSite.bootstrapArgs.size() != 3) {
                throw new Unreachable("Unexpected number of metafactory method arguments in " + callSite.toString());
            }
        } else {
            LambdaDescriptor.extractAltMetafactory(factory, callSite.bootstrapArgs, interfaceType -> {
                if (!match.interfaces.contains(interfaceType)) {
                    match.interfaces.add((DexType)interfaceType);
                }
            }, match.bridges::add);
        }
        return match;
    }

    private static void extractAltMetafactory(DexItemFactory dexItemFactory, List<DexValue> bootstrapArgs, Consumer<DexType> interfaceConsumer, Consumer<DexProto> bridgeConsumer) {
        int i;
        int count;
        int argIndex = 3;
        int flagsArg = LambdaDescriptor.getBootstrapArgument(bootstrapArgs, (int)argIndex++, DexValue.DexValueInt.class).value;
        assert ((flagsArg & 0xFFFFFFF8) == 0);
        if ((flagsArg & 2) != 0) {
            count = LambdaDescriptor.getBootstrapArgument(bootstrapArgs, (int)argIndex++, DexValue.DexValueInt.class).value;
            for (i = 0; i < count; ++i) {
                DexType interfaceType = (DexType)LambdaDescriptor.getBootstrapArgument(bootstrapArgs, (int)argIndex++, DexValue.DexValueType.class).value;
                interfaceConsumer.accept(interfaceType);
            }
        }
        if ((flagsArg & 1) != 0) {
            interfaceConsumer.accept(dexItemFactory.serializableType);
        }
        if ((flagsArg & 4) != 0) {
            count = LambdaDescriptor.getBootstrapArgument(bootstrapArgs, (int)argIndex++, DexValue.DexValueInt.class).value;
            for (i = 0; i < count; ++i) {
                DexProto bridgeProto = (DexProto)LambdaDescriptor.getBootstrapArgument(bootstrapArgs, (int)argIndex++, DexValue.DexValueMethodType.class).value;
                bridgeConsumer.accept(bridgeProto);
            }
        }
        if (bootstrapArgs.size() != argIndex) {
            throw new Unreachable("Unexpected number of metafactory method arguments in DexCallSite");
        }
    }

    public static List<DexType> getInterfaces(DexCallSite callSite, AppInfo appInfo) {
        LambdaDescriptor descriptor = LambdaDescriptor.infer(callSite, appInfo);
        if (descriptor == MATCH_FAILED) {
            return null;
        }
        return descriptor.interfaces;
    }

    private static <T> T getBootstrapArgument(List<DexValue> bootstrapArgs, int i, Class<T> clazz) {
        if (bootstrapArgs.size() < i) {
            throw new Unreachable("Expected to find at least " + i + " bootstrap arguments in DexCallSite");
        }
        DexValue value = bootstrapArgs.get(i);
        if (!clazz.isAssignableFrom(value.getClass())) {
            throw new Unreachable("Unexpected type of bootstrap arguments #" + i + " in DexCallSite");
        }
        return (T)value;
    }

    private static boolean isEnforcedSignatureValid(DexItemFactory factory, DexProto enforced, DexProto erased) {
        if (!LambdaDescriptor.isSameOrDerived(factory, enforced.returnType, erased.returnType)) {
            return false;
        }
        DexType[] enforcedValues = enforced.parameters.values;
        int count = enforcedValues.length;
        DexType[] erasedValues = erased.parameters.values;
        if (count != erasedValues.length) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            if (LambdaDescriptor.isSameOrDerived(factory, enforcedValues[i], erasedValues[i])) continue;
            return false;
        }
        return true;
    }

    static boolean isSameOrDerived(DexItemFactory factory, DexType subType, DexType superType) {
        if (subType == superType || subType.isClassType() && superType.isClassType()) {
            return true;
        }
        if (subType.isArrayType()) {
            if (superType.isArrayType()) {
                return LambdaDescriptor.isSameOrDerived(factory, subType.toArrayElementType(factory), superType.toArrayElementType(factory));
            }
            return superType == factory.objectType;
        }
        return false;
    }
}

