/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.Keep;
import com.android.tools.r8.R8;
import com.android.tools.r8.Version;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.dex.ApplicationWriter;
import com.android.tools.r8.dex.Marker;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.origin.CommandLineOrigin;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.CfgPrinter;
import com.android.tools.r8.utils.ExceptionUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import com.android.tools.r8.utils.VersionProperties;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

@Keep
public final class D8 {
    private D8() {
    }

    public static void run(D8Command command) throws CompilationFailedException {
        AndroidApp app = command.getInputApp();
        InternalOptions options = command.getInternalOptions();
        ExecutorService executor = ThreadUtils.getExecutorService(options);
        ExceptionUtils.withD8CompilationHandler(command.getReporter(), () -> {
            try {
                D8.run(app, options, executor);
            }
            finally {
                executor.shutdown();
            }
        });
    }

    public static void run(D8Command command, ExecutorService executor) throws CompilationFailedException {
        AndroidApp app = command.getInputApp();
        InternalOptions options = command.getInternalOptions();
        ExceptionUtils.withD8CompilationHandler(command.getReporter(), () -> D8.run(app, options, executor));
    }

    private static void run(String[] args) throws CompilationFailedException {
        D8Command command = (D8Command)D8Command.parse(args, CommandLineOrigin.INSTANCE).build();
        if (command.isPrintHelp()) {
            System.out.println(D8Command.USAGE_MESSAGE);
            return;
        }
        if (command.isPrintVersion()) {
            Version.printToolVersion("D8");
            return;
        }
        InternalOptions options = command.getInternalOptions();
        AndroidApp app = command.getInputApp();
        D8.runForTesting(app, options);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println(D8Command.USAGE_MESSAGE);
            System.exit(1);
        }
        ExceptionUtils.withMainProgramHandler(() -> D8.run(args));
    }

    static void runForTesting(AndroidApp inputApp, InternalOptions options) throws CompilationFailedException {
        ExecutorService executor = ThreadUtils.getExecutorService(options);
        ExceptionUtils.withD8CompilationHandler(options.reporter, () -> {
            try {
                D8.run(inputApp, options, executor);
            }
            finally {
                executor.shutdown();
            }
        });
    }

    static Marker getMarker(InternalOptions options) {
        if (options.hasMarker()) {
            return options.getMarker();
        }
        if (options.testing.dontCreateMarkerInD8) {
            return null;
        }
        Marker marker = new Marker(Marker.Tool.D8).setVersion("1.3.36").setCompilationMode(options.debug ? CompilationMode.DEBUG : CompilationMode.RELEASE).setMinApi(options.minApiLevel);
        if (Version.isDev()) {
            marker.setSha1(VersionProperties.INSTANCE.getSha());
        }
        return marker;
    }

    private static void run(AndroidApp inputApp, InternalOptions options, ExecutorService executor) throws IOException {
        Timing timing = new Timing("D8");
        try {
            options.enableMinification = false;
            options.enableInlining = false;
            options.enableClassInlining = false;
            options.enableVerticalClassMerging = false;
            options.enableClassStaticizer = false;
            options.outline.enabled = false;
            DexApplication app = new ApplicationReader(inputApp, options, timing).read(executor);
            AppInfo appInfo = new AppInfo(app);
            app = D8.optimize(app, appInfo, options, timing, executor);
            if (options.hasMethodsFilter()) {
                System.out.println("Finished compilation with method filter: ");
                options.methodsFilter.forEach(m -> System.out.println("  - " + m));
            }
            boolean hasClassResources = false;
            for (DexProgramClass dexProgramClass : app.classes()) {
                if (!dexProgramClass.originatesFromClassResource()) continue;
                hasClassResources = true;
                break;
            }
            Marker marker = D8.getMarker(options);
            HashSet<Marker> markers = new HashSet<Marker>(app.dexItemFactory.extractMarkers());
            if (marker != null && hasClassResources) {
                markers.add(marker);
            }
            new ApplicationWriter(app, options, marker == null ? null : ImmutableList.copyOf(markers), null, GraphLense.getIdentityLense(), NamingLens.getIdentityLens(), null, null).write(executor);
            options.printWarnings();
        }
        catch (ExecutionException e) {
            throw R8.unwrapExecutionException(e);
        }
        finally {
            options.signalFinishedToConsumers();
            if (options.printTimes) {
                timing.report();
            }
        }
    }

    static DexApplication optimize(DexApplication application, AppInfo appInfo, InternalOptions options, Timing timing, ExecutorService executor) throws IOException, ExecutionException {
        CfgPrinter printer = options.printCfg ? new CfgPrinter() : null;
        IRConverter converter = new IRConverter(appInfo, options, timing, printer);
        application = converter.convertToDex(application, executor);
        if (options.printCfg) {
            if (options.printCfgFile == null || options.printCfgFile.isEmpty()) {
                System.out.print(printer.toString());
            } else {
                try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(options.printCfgFile), StandardCharsets.UTF_8);){
                    writer.write(printer.toString());
                }
            }
        }
        return application;
    }
}

