/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.DexAnnotationElement;
import com.android.tools.r8.graph.DexEncodedAnnotation;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.utils.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;

public class DexAnnotation
extends DexItem {
    public static final int VISIBILITY_BUILD = 0;
    public static final int VISIBILITY_RUNTIME = 1;
    public static final int VISIBILITY_SYSTEM = 2;
    public final int visibility;
    public final DexEncodedAnnotation annotation;

    public DexAnnotation(int visibility, DexEncodedAnnotation annotation) {
        this.visibility = visibility;
        this.annotation = annotation;
    }

    public int hashCode() {
        return this.visibility + this.annotation.hashCode() * 3;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof DexAnnotation) {
            DexAnnotation o = (DexAnnotation)other;
            return this.visibility == o.visibility && this.annotation.equals(o.annotation);
        }
        return false;
    }

    public String toString() {
        return this.visibility + " " + this.annotation;
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems, DexMethod method, int instructionOffset) {
        this.annotation.collectIndexedItems(indexedItems, method, instructionOffset);
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        mixedItems.add(this);
    }

    public static DexAnnotation createEnclosingClassAnnotation(DexType enclosingClass, DexItemFactory factory) {
        return DexAnnotation.createSystemValueAnnotation(factory.annotationEnclosingClass, factory, new DexValue.DexValueType(enclosingClass));
    }

    public static DexType getEnclosingClassFromAnnotation(DexAnnotation annotation, DexItemFactory factory) {
        DexValue.DexValueType typeValue = (DexValue.DexValueType)DexAnnotation.getSystemValueAnnotationValue(factory.annotationEnclosingClass, annotation);
        return typeValue == null ? null : (DexType)typeValue.value;
    }

    public static DexAnnotation createEnclosingMethodAnnotation(DexMethod enclosingMethod, DexItemFactory factory) {
        return DexAnnotation.createSystemValueAnnotation(factory.annotationEnclosingMethod, factory, new DexValue.DexValueMethod(enclosingMethod));
    }

    public static DexMethod getEnclosingMethodFromAnnotation(DexAnnotation annotation, DexItemFactory factory) {
        DexValue.DexValueMethod methodValue = (DexValue.DexValueMethod)DexAnnotation.getSystemValueAnnotationValue(factory.annotationEnclosingMethod, annotation);
        return methodValue == null ? null : (DexMethod)methodValue.value;
    }

    public static boolean isEnclosingClassAnnotation(DexAnnotation annotation, DexItemFactory factory) {
        return annotation.annotation.type == factory.annotationEnclosingClass;
    }

    public static boolean isEnclosingMethodAnnotation(DexAnnotation annotation, DexItemFactory factory) {
        return annotation.annotation.type == factory.annotationEnclosingMethod;
    }

    public static boolean isInnerClassAnnotation(DexAnnotation annotation, DexItemFactory factory) {
        return annotation.annotation.type == factory.annotationInnerClass;
    }

    public static boolean isMemberClassesAnnotation(DexAnnotation annotation, DexItemFactory factory) {
        return annotation.annotation.type == factory.annotationMemberClasses;
    }

    public static DexAnnotation createInnerClassAnnotation(DexString clazz, int access, DexItemFactory factory) {
        return new DexAnnotation(2, new DexEncodedAnnotation(factory.annotationInnerClass, new DexAnnotationElement[]{new DexAnnotationElement(factory.createString("accessFlags"), DexValue.DexValueInt.create(access)), new DexAnnotationElement(factory.createString("name"), clazz == null ? DexValue.DexValueNull.NULL : new DexValue.DexValueString(clazz))}));
    }

    public static Pair<DexString, Integer> getInnerClassFromAnnotation(DexAnnotation annotation, DexItemFactory factory) {
        assert (DexAnnotation.isInnerClassAnnotation(annotation, factory));
        DexAnnotationElement[] elements = annotation.annotation.elements;
        Pair<DexString, Integer> result = new Pair<DexString, Integer>();
        for (DexAnnotationElement element : elements) {
            if (element.name == factory.createString("name")) {
                if (!(element.value instanceof DexValue.DexValueString)) continue;
                result.setFirst(((DexValue.DexValueString)element.value).getValue());
                continue;
            }
            assert (element.name == factory.createString("accessFlags"));
            result.setSecond(((DexValue.DexValueInt)element.value).getValue());
        }
        return result;
    }

    public static DexAnnotation createMemberClassesAnnotation(List<DexType> classes, DexItemFactory factory) {
        DexValue[] values2 = new DexValue[classes.size()];
        for (int i = 0; i < classes.size(); ++i) {
            values2[i] = new DexValue.DexValueType(classes.get(i));
        }
        return DexAnnotation.createSystemValueAnnotation(factory.annotationMemberClasses, factory, new DexValue.DexValueArray(values2));
    }

    public static List<DexType> getMemberClassesFromAnnotation(DexAnnotation annotation, DexItemFactory factory) {
        DexValue.DexValueArray membersArray = (DexValue.DexValueArray)DexAnnotation.getSystemValueAnnotationValue(factory.annotationMemberClasses, annotation);
        if (membersArray == null) {
            return null;
        }
        ArrayList<DexType> types = new ArrayList<DexType>(membersArray.getValues().length);
        for (DexValue value : membersArray.getValues()) {
            types.add((DexType)((DexValue.DexValueType)value).value);
        }
        return types;
    }

    public static DexAnnotation createSourceDebugExtensionAnnotation(DexValue value, DexItemFactory factory) {
        return new DexAnnotation(2, new DexEncodedAnnotation(factory.annotationSourceDebugExtension, new DexAnnotationElement[]{new DexAnnotationElement(factory.createString("value"), value)}));
    }

    public static DexAnnotation createMethodParametersAnnotation(DexValue[] names, DexValue[] accessFlags, DexItemFactory factory) {
        assert (names.length == accessFlags.length);
        return new DexAnnotation(2, new DexEncodedAnnotation(factory.annotationMethodParameters, new DexAnnotationElement[]{new DexAnnotationElement(factory.createString("names"), new DexValue.DexValueArray(names)), new DexAnnotationElement(factory.createString("accessFlags"), new DexValue.DexValueArray(accessFlags))}));
    }

    public static DexAnnotation createAnnotationDefaultAnnotation(DexType type, List<DexAnnotationElement> defaults, DexItemFactory factory) {
        return DexAnnotation.createSystemValueAnnotation(factory.annotationDefault, factory, new DexValue.DexValueAnnotation(new DexEncodedAnnotation(type, defaults.toArray(new DexAnnotationElement[defaults.size()]))));
    }

    public static DexAnnotation createSignatureAnnotation(String signature, DexItemFactory factory) {
        return DexAnnotation.createSystemValueAnnotation(factory.annotationSignature, factory, DexAnnotation.compressSignature(signature, factory));
    }

    public static String getSignature(DexAnnotation signatureAnnotation) {
        DexValue.DexValueArray elements = (DexValue.DexValueArray)signatureAnnotation.annotation.elements[0].value;
        StringBuilder signature = new StringBuilder();
        for (DexValue element : elements.getValues()) {
            signature.append(((DexString)((DexValue.DexValueString)element).value).toString());
        }
        return signature.toString();
    }

    public static DexAnnotation createThrowsAnnotation(DexValue[] exceptions, DexItemFactory factory) {
        return DexAnnotation.createSystemValueAnnotation(factory.annotationThrows, factory, new DexValue.DexValueArray(exceptions));
    }

    private static DexAnnotation createSystemValueAnnotation(DexType type, DexItemFactory factory, DexValue value) {
        return new DexAnnotation(2, new DexEncodedAnnotation(type, new DexAnnotationElement[]{new DexAnnotationElement(factory.createString("value"), value)}));
    }

    private static DexValue getSystemValueAnnotationValue(DexType type, DexAnnotation annotation) {
        assert (annotation.visibility == 2);
        assert (annotation.annotation.type == type);
        return annotation.annotation.elements.length == 0 ? null : annotation.annotation.elements[0].value;
    }

    public static boolean isThrowingAnnotation(DexAnnotation annotation, DexItemFactory factory) {
        return annotation.annotation.type == factory.annotationThrows;
    }

    public static boolean isSignatureAnnotation(DexAnnotation annotation, DexItemFactory factory) {
        return annotation.annotation.type == factory.annotationSignature;
    }

    public static boolean isAnnotationDefaultAnnotation(DexAnnotation annotation, DexItemFactory factory) {
        return annotation.annotation.type == factory.annotationDefault;
    }

    public static boolean isSourceDebugExtension(DexAnnotation annotation, DexItemFactory factory) {
        return annotation.annotation.type == factory.annotationSourceDebugExtension;
    }

    public static boolean isParameterNameAnnotation(DexAnnotation annotation, DexItemFactory factory) {
        return annotation.annotation.type == factory.annotationMethodParameters;
    }

    private static DexValue compressSignature(String signature, DexItemFactory factory) {
        int length = signature.length();
        ArrayList<DexValue> parts = new ArrayList<DexValue>();
        int at = 0;
        while (at < length) {
            int endAt;
            char c = signature.charAt(at);
            if (c == 'L') {
                for (endAt = at + 1; endAt < length; ++endAt) {
                    c = signature.charAt(endAt);
                    if (c != ';' && c != '<') continue;
                    ++endAt;
                    break;
                }
            } else {
                while (endAt < length && (c = signature.charAt(endAt)) != 'L') {
                    ++endAt;
                }
            }
            parts.add(DexAnnotation.toDexValue(signature.substring(at, endAt), factory));
            at = endAt;
        }
        return new DexValue.DexValueArray(parts.toArray(new DexValue[parts.size()]));
    }

    private static DexValue toDexValue(String string, DexItemFactory factory) {
        return new DexValue.DexValueString(factory.createString(string));
    }

    public static Collection<DexType> readAnnotationSynthesizedClassMap(DexProgramClass programClass, DexItemFactory dexItemFactory) {
        DexAnnotation foundAnnotation = programClass.annotations.getFirstMatching(dexItemFactory.annotationSynthesizedClassMap);
        if (foundAnnotation != null) {
            if (foundAnnotation.annotation.elements.length != 1) {
                throw new CompilationError(DexAnnotation.getInvalidSynthesizedClassMapMessage(programClass, foundAnnotation));
            }
            DexAnnotationElement value = foundAnnotation.annotation.elements[0];
            if (!value.name.toSourceString().equals("value")) {
                throw new CompilationError(DexAnnotation.getInvalidSynthesizedClassMapMessage(programClass, foundAnnotation));
            }
            if (!(value.value instanceof DexValue.DexValueArray)) {
                throw new CompilationError(DexAnnotation.getInvalidSynthesizedClassMapMessage(programClass, foundAnnotation));
            }
            DexValue.DexValueArray existingList = (DexValue.DexValueArray)value.value;
            ArrayList<DexType> synthesized = new ArrayList<DexType>(existingList.values.length);
            for (DexValue element : existingList.getValues()) {
                if (!(element instanceof DexValue.DexValueType)) {
                    throw new CompilationError(DexAnnotation.getInvalidSynthesizedClassMapMessage(programClass, foundAnnotation));
                }
                synthesized.add((DexType)((DexValue.DexValueType)element).value);
            }
            return synthesized;
        }
        return Collections.emptyList();
    }

    private static String getInvalidSynthesizedClassMapMessage(DexProgramClass annotatedClass, DexAnnotation invalidAnnotation) {
        return annotatedClass.toSourceString() + " is annotated with invalid " + invalidAnnotation.annotation.type.toString() + ": " + invalidAnnotation.toString();
    }

    public static DexAnnotation createAnnotationSynthesizedClassMap(TreeSet<DexType> synthesized, DexItemFactory dexItemFactory) {
        DexValue[] values2 = (DexValue.DexValueType[])synthesized.stream().map(DexValue.DexValueType::new).toArray(DexValue.DexValueType[]::new);
        DexValue.DexValueArray array = new DexValue.DexValueArray(values2);
        DexAnnotationElement pair = new DexAnnotationElement(dexItemFactory.createString("value"), array);
        return new DexAnnotation(0, new DexEncodedAnnotation(dexItemFactory.annotationSynthesizedClassMap, new DexAnnotationElement[]{pair}));
    }

    public static boolean isSynthesizedClassMapAnnotation(DexAnnotation annotation, DexItemFactory factory) {
        return annotation.annotation.type == factory.annotationSynthesizedClassMap;
    }
}

