/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.cf.code.CfConstMethodHandle;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.ConstInstruction;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;

public class ConstMethodHandle
extends ConstInstruction {
    private final DexMethodHandle methodHandle;

    public ConstMethodHandle(Value dest, DexMethodHandle methodHandle) {
        super(dest);
        dest.markNeverNull();
        this.methodHandle = methodHandle;
    }

    public Value dest() {
        return this.outValue;
    }

    public DexMethodHandle getValue() {
        return this.methodHandle;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int dest = builder.allocatedRegister(this.dest(), this.getNumber());
        builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)new com.android.tools.r8.code.ConstMethodHandle(dest, this.methodHandle));
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfConstMethodHandle(this.methodHandle));
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isConstMethodHandle() && other.asConstMethodHandle().methodHandle == this.methodHandle;
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        return this.methodHandle.slowCompareTo(other.asConstMethodHandle().methodHandle);
    }

    @Override
    public int maxInValueRegister() {
        assert (false) : "ConstMethodHandle has no register arguments.";
        return 0;
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    @Override
    public String toString() {
        return super.toString() + " \"" + this.methodHandle + "\"";
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean isOutConstant() {
        return true;
    }

    @Override
    public boolean isConstMethodHandle() {
        return true;
    }

    @Override
    public ConstMethodHandle asConstMethodHandle() {
        return this;
    }

    @Override
    public TypeLatticeElement evaluate(AppInfo appInfo) {
        return TypeLatticeElement.fromDexType(appInfo, appInfo.dexItemFactory.methodHandleType, false);
    }

    @Override
    public DexType computeVerificationType(TypeVerificationHelper helper) {
        return helper.getFactory().methodHandleType;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.storeOutValue(this, it);
    }
}

