/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.ClassAccessFlags;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.ParameterAnnotationsList;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.synthetic.TemplateMethodCode;
import com.android.tools.r8.origin.SynthesizedOrigin;
import com.android.tools.r8.utils.InternalOptions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;

public final class TwrCloseResourceRewriter {
    public static final String UTILITY_CLASS_DESCRIPTOR = "L$r8$twr$utility;";
    private final IRConverter converter;
    private final DexItemFactory factory;
    private final DexMethod twrCloseResourceMethod;
    private final Set<DexProgramClass> referencingClasses = Sets.newConcurrentHashSet();

    public TwrCloseResourceRewriter(IRConverter converter) {
        this.converter = converter;
        this.factory = converter.appInfo.dexItemFactory;
        DexType twrUtilityClass = this.factory.createType(UTILITY_CLASS_DESCRIPTOR);
        DexProto twrCloseResourceProto = this.factory.createProto(this.factory.voidType, this.factory.throwableType, this.factory.objectType);
        this.twrCloseResourceMethod = this.factory.createMethod(twrUtilityClass, twrCloseResourceProto, this.factory.twrCloseResourceMethodName);
    }

    public void rewriteMethodCode(IRCode code) {
        InstructionIterator iterator2 = code.instructionIterator();
        while (iterator2.hasNext()) {
            InvokeStatic invoke;
            Instruction instruction = (Instruction)iterator2.next();
            if (!instruction.isInvokeStatic() || !TwrCloseResourceRewriter.isSynthesizedCloseResourceMethod((invoke = instruction.asInvokeStatic()).getInvokedMethod(), this.converter)) continue;
            assert (invoke.outValue() == null);
            assert (invoke.inValues().size() == 2);
            iterator2.replaceCurrentInstruction(new InvokeStatic(this.twrCloseResourceMethod, null, invoke.inValues()));
            this.referencingClasses.add(this.converter.appInfo.definitionFor(code.method.method.holder).asProgramClass());
        }
    }

    public static boolean isSynthesizedCloseResourceMethod(DexMethod method, IRConverter converter) {
        DexMethod original = converter.getGraphLense().getOriginalMethodSignature(method);
        assert (original != null);
        return original.name == converter.appInfo.dexItemFactory.twrCloseResourceMethodName && original.proto == converter.appInfo.dexItemFactory.twrCloseResourceMethodProto;
    }

    public void synthesizeUtilityClass(DexApplication.Builder<?> builder, InternalOptions options) {
        if (this.referencingClasses.isEmpty()) {
            return;
        }
        CloseResourceMethodCode code = new CloseResourceMethodCode(options, this.twrCloseResourceMethod);
        MethodAccessFlags flags = MethodAccessFlags.fromSharedAccessFlags(4105, false);
        DexEncodedMethod method = new DexEncodedMethod(this.twrCloseResourceMethod, flags, DexAnnotationSet.empty(), ParameterAnnotationsList.empty(), code);
        DexProgramClass utilityClass = new DexProgramClass(this.twrCloseResourceMethod.holder, null, new SynthesizedOrigin("twr utility class", this.getClass()), ClassAccessFlags.fromSharedAccessFlags(4097), this.factory.objectType, DexTypeList.empty(), null, null, Collections.emptyList(), DexAnnotationSet.empty(), DexEncodedField.EMPTY_ARRAY, DexEncodedField.EMPTY_ARRAY, new DexEncodedMethod[]{method}, DexEncodedMethod.EMPTY_ARRAY, this.factory.getSkipNameValidationForTesting(), this.referencingClasses);
        code.setUpContext(utilityClass);
        boolean addToMainDexList = this.referencingClasses.stream().anyMatch(clazz -> this.converter.appInfo.isInMainDexList(clazz.type));
        this.converter.optimizeSynthesizedClass(utilityClass);
        builder.addSynthesizedClass(utilityClass, addToMainDexList);
    }

    private static final class CloseResourceMethodCode
    extends TemplateMethodCode {
        private static final String TEMPLATE_METHOD_NAME = "closeResourceImpl";
        private static final String TEMPLATE_METHOD_DESC = "(Ljava/lang/Throwable;Ljava/lang/Object;)V";

        CloseResourceMethodCode(InternalOptions options, DexMethod method) {
            super(options, method, TEMPLATE_METHOD_NAME, TEMPLATE_METHOD_DESC);
        }

        public static void closeResourceImpl(Throwable throwable, Object resource) throws Throwable {
            block7: {
                try {
                    if (resource instanceof AutoCloseable) {
                        ((AutoCloseable)resource).close();
                        break block7;
                    }
                    try {
                        Method method = resource.getClass().getMethod("close", new Class[0]);
                        method.invoke(resource, new Object[0]);
                    }
                    catch (NoSuchMethodException | SecurityException e) {
                        throw new AssertionError(resource.getClass() + " does not have a close() method.", e);
                    }
                    catch (ExceptionInInitializerError | IllegalAccessException | IllegalArgumentException e) {
                        throw new AssertionError("Fail to call close() on " + resource.getClass(), e);
                    }
                    catch (InvocationTargetException e) {
                        throw e.getCause();
                    }
                }
                catch (Throwable e) {
                    throw throwable != null ? throwable : e;
                }
            }
        }
    }
}

