/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.jar;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.graph.JarApplicationReader;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.conversion.JarSourceCode;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.org.objectweb.asm.Type;
import com.android.tools.r8.org.objectweb.asm.tree.TryCatchBlockNode;
import com.android.tools.r8.shaking.Enqueuer;

public class InliningConstraintVisitor
extends MethodVisitor {
    private final JarApplicationReader application;
    private final Enqueuer.AppInfoWithLiveness appInfo;
    private final GraphLense graphLense;
    private final InliningConstraints inliningConstraints;
    private final DexEncodedMethod method;
    private final DexType invocationContext;
    private Inliner.ConstraintWithTarget constraint;

    public InliningConstraintVisitor(JarApplicationReader application, Enqueuer.AppInfoWithLiveness appInfo, GraphLense graphLense, DexEncodedMethod method, DexType invocationContext) {
        super(393216);
        assert (graphLense.isContextFreeForMethods());
        this.application = application;
        this.appInfo = appInfo;
        this.graphLense = graphLense;
        this.inliningConstraints = new InliningConstraints(appInfo, graphLense);
        this.method = method;
        this.invocationContext = invocationContext;
        this.constraint = method.accessFlags.isSynchronized() ? this.inliningConstraints.forMonitor() : Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget getConstraint() {
        return this.constraint;
    }

    private void updateConstraint(Inliner.ConstraintWithTarget other) {
        this.constraint = Inliner.ConstraintWithTarget.meet(this.constraint, other, this.appInfo);
    }

    public boolean isFinished() {
        return this.constraint == Inliner.ConstraintWithTarget.NEVER;
    }

    public void accept(TryCatchBlockNode tryCatchBlock) {
        this.updateConstraint(this.inliningConstraints.forMoveException());
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        DexField field = this.application.getField(owner, name, desc);
        switch (opcode) {
            case 180: {
                this.updateConstraint(this.inliningConstraints.forInstanceGet(field, this.invocationContext));
                break;
            }
            case 181: {
                this.updateConstraint(this.inliningConstraints.forInstancePut(field, this.invocationContext));
                break;
            }
            case 178: {
                this.updateConstraint(this.inliningConstraints.forStaticGet(field, this.invocationContext));
                break;
            }
            case 179: {
                this.updateConstraint(this.inliningConstraints.forStaticPut(field, this.invocationContext));
                break;
            }
            default: {
                throw new Unreachable("Unexpected opcode " + opcode);
            }
        }
    }

    @Override
    public void visitLdcInsn(Object cst) {
        if (cst instanceof Type && ((Type)cst).getSort() != 11) {
            DexType type = this.application.getType((Type)cst);
            this.updateConstraint(this.inliningConstraints.forConstClass(type, this.invocationContext));
        } else {
            this.updateConstraint(this.inliningConstraints.forConstInstruction());
        }
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        Invoke.Type type;
        DexType ownerType = this.application.getTypeFromName(owner);
        DexMethod target = this.application.getMethod(ownerType, name, desc);
        switch (opcode) {
            case 186: {
                Invoke.Type type2 = type = JarSourceCode.isCallToPolymorphicSignatureMethod(owner, name) ? Invoke.Type.POLYMORPHIC : Invoke.Type.CUSTOM;
                assert (this.noNeedToUseGraphLense(target, type));
                break;
            }
            case 185: {
                type = this.graphLense.lookupMethod(target, null, Invoke.Type.INTERFACE).getType();
                assert (type == Invoke.Type.INTERFACE || type == Invoke.Type.VIRTUAL);
                break;
            }
            case 183: {
                if (name.equals("<init>")) {
                    type = Invoke.Type.DIRECT;
                    assert (this.noNeedToUseGraphLense(target, type));
                    break;
                }
                if (ownerType == this.invocationContext) {
                    type = this.graphLense.lookupMethod(target, null, Invoke.Type.DIRECT).getType();
                    assert (type == Invoke.Type.DIRECT || type == Invoke.Type.VIRTUAL);
                    break;
                }
                type = Invoke.Type.SUPER;
                assert (this.noNeedToUseGraphLense(target, type));
                break;
            }
            case 184: {
                type = Invoke.Type.STATIC;
                assert (this.noNeedToUseGraphLense(target, type));
                break;
            }
            case 182: {
                DexClass clazz;
                type = Invoke.Type.VIRTUAL;
                if (target.holder == this.method.method.holder && (clazz = this.appInfo.definitionFor(target.holder)) != null && clazz.lookupDirectMethod(target) != null) {
                    type = Invoke.Type.DIRECT;
                }
                assert (this.noNeedToUseGraphLense(target, type));
                break;
            }
            default: {
                throw new Unreachable("Unexpected opcode " + opcode);
            }
        }
        this.updateConstraint(this.inliningConstraints.forInvoke(target, type, this.invocationContext));
    }

    private boolean noNeedToUseGraphLense(DexMethod method, Invoke.Type type) {
        assert (this.graphLense.lookupMethod(method, null, type).getType() == type);
        return true;
    }

    @Override
    public void visitInsn(int opcode) {
        switch (opcode) {
            case 194: 
            case 195: {
                this.updateConstraint(this.inliningConstraints.forMonitor());
                break;
            }
        }
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        DexType type = this.application.getTypeFromDescriptor(desc);
        this.updateConstraint(this.inliningConstraints.forInvokeMultiNewArray(type, this.invocationContext));
    }

    @Override
    public void visitTypeInsn(int opcode, String typeName) {
        DexType type = this.application.getTypeFromName(typeName);
        switch (opcode) {
            case 189: {
                this.updateConstraint(this.inliningConstraints.forNewArrayEmpty(type, this.invocationContext));
                break;
            }
            case 192: {
                this.updateConstraint(this.inliningConstraints.forCheckCast(type, this.invocationContext));
                break;
            }
            case 193: {
                this.updateConstraint(this.inliningConstraints.forInstanceOf(type, this.invocationContext));
                break;
            }
            case 187: {
                this.updateConstraint(this.inliningConstraints.forNewInstance(type, this.invocationContext));
                break;
            }
            default: {
                throw new Unreachable("Unexpected opcode " + opcode);
            }
        }
    }
}

