/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.cf.code.CfInvokeDynamic;
import com.android.tools.r8.code.Base3Format;
import com.android.tools.r8.code.InvokeCustomRange;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import java.util.List;

public final class InvokeCustom
extends Invoke {
    private final DexCallSite callSite;

    public InvokeCustom(DexCallSite callSite, Value result, List<Value> arguments) {
        super(result, arguments);
        assert (callSite != null);
        this.callSite = callSite;
    }

    @Override
    public DexType getReturnType() {
        return this.callSite.methodProto.returnType;
    }

    public DexCallSite getCallSite() {
        return this.callSite;
    }

    @Override
    public Invoke.Type getType() {
        return Invoke.Type.CUSTOM;
    }

    @Override
    protected String getTypeString() {
        return "Custom";
    }

    @Override
    public String toString() {
        return super.toString() + "; call site: " + this.callSite.toSourceString();
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Base3Format instruction;
        int argumentRegisters = this.requiredArgumentRegisters();
        builder.requestOutgoingRegisters(argumentRegisters);
        if (this.needsRangedInvoke(builder)) {
            assert (this.argumentsConsecutive(builder));
            int firstRegister = this.argumentRegisterValue(0, builder);
            instruction = new InvokeCustomRange(firstRegister, argumentRegisters, this.getCallSite());
        } else {
            int[] individualArgumentRegisters = new int[5];
            int argumentRegistersCount = this.fillArgumentRegisters(builder, individualArgumentRegisters);
            instruction = new com.android.tools.r8.code.InvokeCustom(argumentRegistersCount, this.getCallSite(), individualArgumentRegisters[0], individualArgumentRegisters[1], individualArgumentRegisters[2], individualArgumentRegisters[3], individualArgumentRegisters[4]);
        }
        this.addInvokeAndMoveResult(instruction, builder);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfInvokeDynamic(this.getCallSite()));
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isInvokeCustom() && this.callSite == other.asInvokeCustom().callSite;
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        assert (other.isInvokeCustom());
        assert (false) : "Not supported";
        return 0;
    }

    @Override
    public boolean isInvokeCustom() {
        return true;
    }

    @Override
    public InvokeCustom asInvokeCustom() {
        return this;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forInvokeCustom();
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
        if (this.getCallSite().methodProto.returnType.isVoidType()) {
            return;
        }
        if (this.outValue == null) {
            helper.popOutType(this.getCallSite().methodProto.returnType, this, it);
        } else {
            assert (this.outValue.isUsed());
            helper.storeOutValue(this, it);
        }
    }

    @Override
    public boolean hasInvariantOutType() {
        return true;
    }

    @Override
    public DexType computeVerificationType(TypeVerificationHelper helper) {
        return this.getCallSite().methodProto.returnType;
    }
}

