/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexLibraryClass;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DirectMappedDexApplication;
import com.android.tools.r8.shaking.ClassInlineRule;
import com.android.tools.r8.shaking.ClassMergingRule;
import com.android.tools.r8.shaking.DexStringCache;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.InlineRule;
import com.android.tools.r8.shaking.ProguardAssumeNoSideEffectRule;
import com.android.tools.r8.shaking.ProguardAssumeValuesRule;
import com.android.tools.r8.shaking.ProguardCheckDiscardRule;
import com.android.tools.r8.shaking.ProguardConfigurationRule;
import com.android.tools.r8.shaking.ProguardIdentifierNameStringRule;
import com.android.tools.r8.shaking.ProguardIfRule;
import com.android.tools.r8.shaking.ProguardKeepPackageNamesRule;
import com.android.tools.r8.shaking.ProguardKeepRule;
import com.android.tools.r8.shaking.ProguardKeepRuleModifiers;
import com.android.tools.r8.shaking.ProguardMemberRule;
import com.android.tools.r8.shaking.ProguardTypeMatcher;
import com.android.tools.r8.shaking.ProguardWhyAreYouKeepingRule;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.MethodSignatureEquivalence;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.ThreadUtils;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class RootSetBuilder {
    private final AppInfo appInfo;
    private final DirectMappedDexApplication application;
    private final Collection<ProguardConfigurationRule> rules;
    private final Map<DexDefinition, ProguardKeepRule> noShrinking = new IdentityHashMap<DexDefinition, ProguardKeepRule>();
    private final Set<DexDefinition> noOptimization = Sets.newIdentityHashSet();
    private final Set<DexDefinition> noObfuscation = Sets.newIdentityHashSet();
    private final Set<DexDefinition> reasonAsked = Sets.newIdentityHashSet();
    private final Set<DexDefinition> keepPackageName = Sets.newIdentityHashSet();
    private final Set<ProguardConfigurationRule> rulesThatUseExtendsOrImplementsWrong = Sets.newIdentityHashSet();
    private final Set<DexDefinition> checkDiscarded = Sets.newIdentityHashSet();
    private final Set<DexMethod> alwaysInline = Sets.newIdentityHashSet();
    private final Set<DexMethod> forceInline = Sets.newIdentityHashSet();
    private final Set<DexMethod> neverInline = Sets.newIdentityHashSet();
    private final Set<DexType> neverClassInline = Sets.newIdentityHashSet();
    private final Set<DexType> neverMerge = Sets.newIdentityHashSet();
    private final Map<DexDefinition, Map<DexDefinition, ProguardKeepRule>> dependentNoShrinking = new IdentityHashMap<DexDefinition, Map<DexDefinition, ProguardKeepRule>>();
    private final Map<DexDefinition, ProguardMemberRule> noSideEffects = new IdentityHashMap<DexDefinition, ProguardMemberRule>();
    private final Map<DexDefinition, ProguardMemberRule> assumedValues = new IdentityHashMap<DexDefinition, ProguardMemberRule>();
    private final Set<DexReference> identifierNameStrings = Sets.newIdentityHashSet();
    private final InternalOptions options;
    private final DexStringCache dexStringCache = new DexStringCache();
    private final Set<ProguardIfRule> ifRules = Sets.newIdentityHashSet();

    public RootSetBuilder(AppInfo appInfo, DexApplication application, List<ProguardConfigurationRule> rules, InternalOptions options) {
        this.appInfo = appInfo;
        this.application = application.asDirect();
        this.rules = rules == null ? null : Collections.unmodifiableCollection(rules);
        this.options = options;
    }

    RootSetBuilder(AppInfo appInfo, Set<ProguardIfRule> ifRules, InternalOptions options) {
        this.appInfo = appInfo;
        this.application = appInfo.app.asDirect();
        this.rules = Collections.unmodifiableCollection(ifRules);
        this.options = options;
    }

    private boolean anySuperTypeMatches(DexType type, Function<DexType, DexClass> definitionFor, ProguardTypeMatcher name, ProguardTypeMatcher annotation) {
        while (type != null) {
            DexClass clazz = definitionFor.apply(type);
            if (clazz == null) {
                return false;
            }
            if (name.matches(clazz.type) && RootSetBuilder.containsAnnotation(annotation, clazz.annotations)) {
                return true;
            }
            type = clazz.superType;
        }
        return false;
    }

    private boolean anyImplementedInterfaceMatches(DexClass clazz, Function<DexType, DexClass> definitionFor, ProguardTypeMatcher className, ProguardTypeMatcher annotation) {
        if (clazz == null) {
            return false;
        }
        for (DexType iface : clazz.interfaces.values) {
            DexClass ifaceClass = definitionFor.apply(iface);
            if (ifaceClass == null) {
                return false;
            }
            if ((!className.matches(iface) || !RootSetBuilder.containsAnnotation(annotation, ifaceClass.annotations)) && !this.anyImplementedInterfaceMatches(ifaceClass, definitionFor, className, annotation)) continue;
            return true;
        }
        if (clazz.superType == null) {
            return false;
        }
        DexClass superClass = definitionFor.apply(clazz.superType);
        if (superClass == null) {
            return false;
        }
        return this.anyImplementedInterfaceMatches(superClass, definitionFor, className, annotation);
    }

    private void process(DexClass clazz, ProguardConfigurationRule rule, ProguardIfRule ifRule) {
        if (!RootSetBuilder.satisfyClassType(rule, clazz)) {
            return;
        }
        if (!RootSetBuilder.satisfyAccessFlag(rule, clazz)) {
            return;
        }
        if (!RootSetBuilder.satisfyAnnotation(rule, clazz)) {
            return;
        }
        if (rule.hasInheritanceClassName()) {
            boolean extendsExpected = this.anySuperTypeMatches(clazz.superType, this.application::definitionFor, rule.getInheritanceClassName(), rule.getInheritanceAnnotation());
            boolean implementsExpected = false;
            if (!extendsExpected) {
                implementsExpected = this.anyImplementedInterfaceMatches(clazz, this.application::definitionFor, rule.getInheritanceClassName(), rule.getInheritanceAnnotation());
            }
            if (!extendsExpected && !implementsExpected) {
                return;
            }
            if (extendsExpected && !rule.getInheritanceIsExtends()) {
                if (this.rulesThatUseExtendsOrImplementsWrong.add(rule)) {
                    this.options.reporter.warning(new StringDiagnostic("The rule `" + rule + "` uses implements but actually matches extends."));
                }
            } else if (implementsExpected && rule.getInheritanceIsExtends() && this.rulesThatUseExtendsOrImplementsWrong.add(rule)) {
                this.options.reporter.warning(new StringDiagnostic("The rule `" + rule + "` uses extends but actually matches implements."));
            }
        }
        if (rule.getClassNames().matches(clazz.type)) {
            List<ProguardMemberRule> memberKeepRules = rule.getMemberRules();
            if (rule instanceof ProguardKeepRule) {
                switch (((ProguardKeepRule)rule).getType()) {
                    case KEEP_CLASS_MEMBERS: {
                        ImmutableMap<Predicate<DexDefinition>, DexDefinition> preconditionSupplier = ImmutableMap.of(definition -> true, clazz);
                        this.markMatchingVisibleMethods(clazz, memberKeepRules, rule, preconditionSupplier);
                        this.markMatchingVisibleFields(clazz, memberKeepRules, rule, preconditionSupplier);
                        break;
                    }
                    case KEEP_CLASSES_WITH_MEMBERS: {
                        if (!this.allRulesSatisfied(memberKeepRules, clazz)) break;
                    }
                    case KEEP: {
                        this.markClass(clazz, rule);
                        HashMap<Predicate<DexDefinition>, DexDefinition> preconditionSupplier = new HashMap<Predicate<DexDefinition>, DexDefinition>();
                        if (ifRule != null) {
                            preconditionSupplier.put(DexDefinition::isStaticMember, null);
                            preconditionSupplier.put(definition -> !definition.isStaticMember(), clazz);
                        } else {
                            preconditionSupplier.put(definition -> true, null);
                        }
                        this.markMatchingVisibleMethods(clazz, memberKeepRules, rule, preconditionSupplier);
                        this.markMatchingVisibleFields(clazz, memberKeepRules, rule, preconditionSupplier);
                        break;
                    }
                    case CONDITIONAL: {
                        throw new Unreachable("-if rule will be evaluated separately, not here.");
                    }
                }
            } else {
                if (rule instanceof ProguardIfRule) {
                    throw new Unreachable("-if rule will be evaluated separately, not here.");
                }
                if (rule instanceof ProguardCheckDiscardRule) {
                    if (memberKeepRules.isEmpty()) {
                        this.markClass(clazz, rule);
                    } else {
                        ImmutableMap<Predicate<DexDefinition>, DexDefinition> preconditionSupplier = ImmutableMap.of(definition -> true, clazz);
                        this.markMatchingFields(clazz, memberKeepRules, rule, preconditionSupplier);
                        this.markMatchingMethods(clazz, memberKeepRules, rule, preconditionSupplier);
                    }
                } else if (rule instanceof ProguardWhyAreYouKeepingRule || rule instanceof ProguardKeepPackageNamesRule) {
                    this.markClass(clazz, rule);
                    this.markMatchingVisibleMethods(clazz, memberKeepRules, rule, null);
                    this.markMatchingVisibleFields(clazz, memberKeepRules, rule, null);
                } else if (rule instanceof ProguardAssumeNoSideEffectRule) {
                    this.markMatchingVisibleMethods(clazz, memberKeepRules, rule, null);
                    this.markMatchingVisibleFields(clazz, memberKeepRules, rule, null);
                } else if (rule instanceof ClassMergingRule) {
                    if (this.allRulesSatisfied(memberKeepRules, clazz)) {
                        this.markClass(clazz, rule);
                    }
                } else if (rule instanceof InlineRule) {
                    this.markMatchingMethods(clazz, memberKeepRules, rule, null);
                } else if (rule instanceof ClassInlineRule) {
                    if (this.allRulesSatisfied(memberKeepRules, clazz)) {
                        this.markClass(clazz, rule);
                    }
                } else if (rule instanceof ProguardAssumeValuesRule) {
                    this.markMatchingVisibleMethods(clazz, memberKeepRules, rule, null);
                    this.markMatchingVisibleFields(clazz, memberKeepRules, rule, null);
                } else {
                    assert (rule instanceof ProguardIdentifierNameStringRule);
                    this.markMatchingFields(clazz, memberKeepRules, rule, null);
                    this.markMatchingMethods(clazz, memberKeepRules, rule, null);
                }
            }
        }
    }

    private void runPerRule(ExecutorService executorService, List<Future<?>> futures, ProguardConfigurationRule rule, ProguardIfRule ifRule) {
        List<DexType> specifics = rule.getClassNames().asSpecificDexTypes();
        if (specifics != null) {
            for (DexType type : specifics) {
                DexClass clazz = this.application.definitionFor(type);
                if (clazz == null) continue;
                this.process(clazz, rule, ifRule);
            }
        } else {
            futures.add(executorService.submit(() -> {
                for (DexProgramClass dexProgramClass : this.application.classes()) {
                    this.process(dexProgramClass, rule, ifRule);
                }
                if (rule.applyToLibraryClasses()) {
                    for (DexLibraryClass dexLibraryClass : this.application.libraryClasses()) {
                        this.process(dexLibraryClass, rule, ifRule);
                    }
                }
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RootSet run(ExecutorService executorService) throws ExecutionException {
        this.application.timing.begin("Build root set...");
        try {
            ArrayList futures = new ArrayList();
            if (this.rules != null) {
                for (ProguardConfigurationRule rule : this.rules) {
                    if (rule instanceof ProguardIfRule) {
                        ProguardIfRule ifRule = (ProguardIfRule)rule;
                        this.ifRules.add(ifRule);
                        continue;
                    }
                    this.runPerRule(executorService, futures, rule, null);
                }
                ThreadUtils.awaitFutures(futures);
            }
        }
        finally {
            this.application.timing.end();
        }
        return new RootSet(this.noShrinking, this.noOptimization, this.noObfuscation, this.reasonAsked, this.keepPackageName, this.checkDiscarded, this.alwaysInline, this.forceInline, this.neverInline, this.neverClassInline, this.neverMerge, this.noSideEffects, this.assumedValues, this.dependentNoShrinking, this.identifierNameStrings, this.ifRules);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConsequentRootSet runForIfRules(ExecutorService executorService, Set<DexType> liveTypes, Set<DexEncodedMethod> liveMethods, Set<DexEncodedField> liveFields) throws ExecutionException {
        this.application.timing.begin("Find consequent items for -if rules...");
        Function<DexType, DexClass> definitionForWithLiveTypes = type -> {
            DexClass clazz = this.appInfo.definitionFor((DexType)type);
            if (clazz != null && liveTypes.contains(clazz.type)) {
                return clazz;
            }
            return null;
        };
        try {
            ArrayList futures = new ArrayList();
            if (this.rules != null) {
                for (ProguardConfigurationRule rule : this.rules) {
                    assert (rule instanceof ProguardIfRule);
                    ProguardIfRule ifRule = (ProguardIfRule)rule;
                    for (DexType currentLiveType : liveTypes) {
                        DexClass currentLiveClass = this.appInfo.definitionFor(currentLiveType);
                        if (currentLiveClass == null || !RootSetBuilder.satisfyClassType(rule, currentLiveClass) || !RootSetBuilder.satisfyAccessFlag(rule, currentLiveClass) || !RootSetBuilder.satisfyAnnotation(rule, currentLiveClass) || ifRule.hasInheritanceClassName() && !this.satisfyInheritanceRule(currentLiveType, definitionForWithLiveTypes, ifRule) || !ifRule.getClassNames().matches(currentLiveType)) continue;
                        List<ProguardMemberRule> memberKeepRules = ifRule.getMemberRules();
                        if (memberKeepRules.isEmpty()) {
                            ProguardIfRule materializedRule = ifRule.materialize();
                            this.runPerRule(executorService, futures, materializedRule.subsequentRule, materializedRule);
                            continue;
                        }
                        Set filteredFields = liveFields.stream().filter(f -> f.field.getHolder() == currentLiveType).collect(Collectors.toSet());
                        Set filteredMethods = liveMethods.stream().filter(m -> m.method.getHolder() == currentLiveType).collect(Collectors.toSet());
                        if (filteredFields.size() + filteredMethods.size() < memberKeepRules.size()) continue;
                        Set combinationsOfMembers = Sets.combinations(Sets.union(filteredFields, filteredMethods), memberKeepRules.size());
                        for (Set combination : combinationsOfMembers) {
                            Set<DexEncodedField> fieldsInCombination = DexDefinition.filterDexEncodedField(combination.stream()).collect(Collectors.toSet());
                            Set<DexEncodedMethod> methodsInCombination = DexDefinition.filterDexEncodedMethod(combination.stream()).collect(Collectors.toSet());
                            boolean satisfied = true;
                            for (ProguardMemberRule memberRule : memberKeepRules) {
                                if (this.ruleSatisfiedByFields(memberRule, fieldsInCombination) || this.ruleSatisfiedByMethods(memberRule, methodsInCombination)) continue;
                                satisfied = false;
                                break;
                            }
                            if (!satisfied) continue;
                            ProguardIfRule materializedRule = ifRule.materialize();
                            this.runPerRule(executorService, futures, materializedRule.subsequentRule, materializedRule);
                        }
                    }
                }
                ThreadUtils.awaitFutures(futures);
            }
        }
        finally {
            this.application.timing.end();
        }
        return new ConsequentRootSet(this.noShrinking, this.noOptimization, this.noObfuscation, this.dependentNoShrinking);
    }

    private static DexDefinition testAndGetPrecondition(DexDefinition definition, Map<Predicate<DexDefinition>, DexDefinition> preconditionSupplier) {
        if (preconditionSupplier == null) {
            return null;
        }
        DexDefinition precondition = null;
        boolean conditionEverMatched = false;
        for (Map.Entry<Predicate<DexDefinition>, DexDefinition> entry : preconditionSupplier.entrySet()) {
            if (!entry.getKey().test(definition)) continue;
            precondition = entry.getValue();
            conditionEverMatched = true;
            break;
        }
        assert (conditionEverMatched);
        return precondition;
    }

    private void markMatchingVisibleMethods(DexClass clazz, Collection<ProguardMemberRule> memberKeepRules, ProguardConfigurationRule rule, Map<Predicate<DexDefinition>, DexDefinition> preconditionSupplier) {
        HashSet methodsMarked = this.options.forceProguardCompatibility ? null : new HashSet();
        DexClass startingClass = clazz;
        while (clazz != null) {
            if (clazz == startingClass || this.options.forceProguardCompatibility) {
                Arrays.stream(clazz.directMethods()).forEach(method -> {
                    DexDefinition precondition = RootSetBuilder.testAndGetPrecondition(method, preconditionSupplier);
                    this.markMethod((DexEncodedMethod)method, memberKeepRules, methodsMarked, rule, precondition);
                });
            }
            Arrays.stream(clazz.virtualMethods()).forEach(method -> {
                DexDefinition precondition = RootSetBuilder.testAndGetPrecondition(method, preconditionSupplier);
                this.markMethod((DexEncodedMethod)method, memberKeepRules, methodsMarked, rule, precondition);
            });
            clazz = clazz.superType == null ? null : this.application.definitionFor(clazz.superType);
        }
    }

    private void markMatchingMethods(DexClass clazz, Collection<ProguardMemberRule> memberKeepRules, ProguardConfigurationRule rule, Map<Predicate<DexDefinition>, DexDefinition> preconditionSupplier) {
        clazz.forEachMethod(method -> {
            DexDefinition precondition = RootSetBuilder.testAndGetPrecondition(method, preconditionSupplier);
            this.markMethod((DexEncodedMethod)method, memberKeepRules, null, rule, precondition);
        });
    }

    private void markMatchingVisibleFields(DexClass clazz, Collection<ProguardMemberRule> memberKeepRules, ProguardConfigurationRule rule, Map<Predicate<DexDefinition>, DexDefinition> preconditionSupplier) {
        while (clazz != null) {
            clazz.forEachField(field -> {
                DexDefinition precondition = RootSetBuilder.testAndGetPrecondition(field, preconditionSupplier);
                this.markField((DexEncodedField)field, memberKeepRules, rule, precondition);
            });
            clazz = clazz.superType == null ? null : this.application.definitionFor(clazz.superType);
        }
    }

    private void markMatchingFields(DexClass clazz, Collection<ProguardMemberRule> memberKeepRules, ProguardConfigurationRule rule, Map<Predicate<DexDefinition>, DexDefinition> preconditionSupplier) {
        clazz.forEachField(field -> {
            DexDefinition precondition = RootSetBuilder.testAndGetPrecondition(field, preconditionSupplier);
            this.markField((DexEncodedField)field, memberKeepRules, rule, precondition);
        });
    }

    public static void writeSeeds(Enqueuer.AppInfoWithLiveness appInfo, PrintStream out, Predicate<DexType> include) {
        for (DexReference seed : appInfo.getPinnedItems()) {
            if (seed.isDexType()) {
                if (!include.test(seed.asDexType())) continue;
                out.println(seed.toSourceString());
                continue;
            }
            if (seed.isDexField()) {
                DexField field = seed.asDexField();
                if (!include.test(field.clazz)) continue;
                out.println(field.clazz.toSourceString() + ": " + field.type.toSourceString() + " " + field.name.toSourceString());
                continue;
            }
            assert (seed.isDexMethod());
            DexMethod method = seed.asDexMethod();
            if (!include.test(method.holder)) continue;
            out.print(method.holder.toSourceString() + ": ");
            DexEncodedMethod encodedMethod = appInfo.definitionFor(method);
            if (encodedMethod.accessFlags.isConstructor()) {
                if (encodedMethod.accessFlags.isStatic()) {
                    out.print("<clinit>");
                } else {
                    String holderName = method.holder.toSourceString();
                    String constrName = holderName.substring(holderName.lastIndexOf(46) + 1);
                    out.print(constrName);
                }
            } else {
                out.print(method.proto.returnType.toSourceString() + " " + method.name.toSourceString());
            }
            boolean first = true;
            out.print("(");
            for (DexType param : method.proto.parameters.values) {
                if (!first) {
                    out.print(",");
                }
                first = false;
                out.print(param.toSourceString());
            }
            out.println(")");
        }
        out.close();
    }

    private static boolean satisfyClassType(ProguardConfigurationRule rule, DexClass clazz) {
        return rule.getClassType().matches(clazz) != rule.getClassTypeNegated();
    }

    private static boolean satisfyAccessFlag(ProguardConfigurationRule rule, DexClass clazz) {
        return rule.getClassAccessFlags().containsAll(clazz.accessFlags) && rule.getNegatedClassAccessFlags().containsNone(clazz.accessFlags);
    }

    private static boolean satisfyAnnotation(ProguardConfigurationRule rule, DexClass clazz) {
        return RootSetBuilder.containsAnnotation(rule.getClassAnnotation(), clazz.annotations);
    }

    private boolean satisfyInheritanceRule(DexType type, Function<DexType, DexClass> definitionFor, ProguardConfigurationRule rule) {
        DexClass clazz = definitionFor.apply(type);
        if (clazz == null) {
            return false;
        }
        return this.anySuperTypeMatches(clazz.superType, definitionFor, rule.getInheritanceClassName(), rule.getInheritanceAnnotation()) || this.anyImplementedInterfaceMatches(clazz, definitionFor, rule.getInheritanceClassName(), rule.getInheritanceAnnotation());
    }

    private boolean allRulesSatisfied(Collection<ProguardMemberRule> memberKeepRules, DexClass clazz) {
        for (ProguardMemberRule rule : memberKeepRules) {
            if (this.ruleSatisfied(rule, clazz)) continue;
            return false;
        }
        return true;
    }

    private boolean ruleSatisfied(ProguardMemberRule rule, DexClass clazz) {
        return this.ruleSatisfiedByMethods(rule, clazz.directMethods()) || this.ruleSatisfiedByMethods(rule, clazz.virtualMethods()) || this.ruleSatisfiedByFields(rule, clazz.staticFields()) || this.ruleSatisfiedByFields(rule, clazz.instanceFields());
    }

    private boolean ruleSatisfiedByMethods(ProguardMemberRule rule, Iterable<DexEncodedMethod> methods) {
        if (rule.getRuleType().includesMethods()) {
            for (DexEncodedMethod method : methods) {
                if (!rule.matches(method, this.dexStringCache)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean ruleSatisfiedByMethods(ProguardMemberRule rule, DexEncodedMethod[] methods) {
        if (rule.getRuleType().includesMethods()) {
            for (DexEncodedMethod method : methods) {
                if (!rule.matches(method, this.dexStringCache)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean ruleSatisfiedByFields(ProguardMemberRule rule, Iterable<DexEncodedField> fields) {
        if (rule.getRuleType().includesFields()) {
            for (DexEncodedField field : fields) {
                if (!rule.matches(field, this.dexStringCache)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean ruleSatisfiedByFields(ProguardMemberRule rule, DexEncodedField[] fields) {
        if (rule.getRuleType().includesFields()) {
            for (DexEncodedField field : fields) {
                if (!rule.matches(field, this.dexStringCache)) continue;
                return true;
            }
        }
        return false;
    }

    static boolean containsAnnotation(ProguardTypeMatcher classAnnotation, DexAnnotationSet annotations) {
        if (classAnnotation == null) {
            return true;
        }
        if (annotations.isEmpty()) {
            return false;
        }
        for (DexAnnotation annotation : annotations.annotations) {
            if (!classAnnotation.matches(annotation.annotation.type)) continue;
            return true;
        }
        return false;
    }

    private void markMethod(DexEncodedMethod method, Collection<ProguardMemberRule> rules, Set<Equivalence.Wrapper<DexMethod>> methodsMarked, ProguardConfigurationRule context, DexDefinition precondition) {
        if (methodsMarked != null && methodsMarked.contains(MethodSignatureEquivalence.get().wrap(method.method))) {
            return;
        }
        for (ProguardMemberRule rule : rules) {
            if (!rule.matches(method, this.dexStringCache)) continue;
            if (methodsMarked != null) {
                methodsMarked.add(MethodSignatureEquivalence.get().wrap(method.method));
            }
            this.addItemToSets(method, context, rule, precondition);
        }
    }

    private void markField(DexEncodedField field, Collection<ProguardMemberRule> rules, ProguardConfigurationRule context, DexDefinition precondition) {
        for (ProguardMemberRule rule : rules) {
            if (!rule.matches(field, this.dexStringCache)) continue;
            this.addItemToSets(field, context, rule, precondition);
        }
    }

    private void markClass(DexClass clazz, ProguardConfigurationRule rule) {
        this.addItemToSets(clazz, rule, null, null);
    }

    private void includeDescriptor(DexDefinition item, DexType type, ProguardKeepRule context) {
        if (type.isArrayType()) {
            type = type.toBaseType(this.application.dexItemFactory);
        }
        if (type.isPrimitiveType()) {
            return;
        }
        DexClass definition = this.appInfo.definitionFor(type);
        if (definition == null || definition.isLibraryClass()) {
            return;
        }
        this.dependentNoShrinking.computeIfAbsent(item, x -> new IdentityHashMap()).put(definition, context);
        this.noObfuscation.add(definition);
    }

    private void includeDescriptorClasses(DexDefinition item, ProguardKeepRule context) {
        if (item.isDexEncodedMethod()) {
            DexMethod method = item.asDexEncodedMethod().method;
            this.includeDescriptor(item, method.proto.returnType, context);
            for (DexType value : method.proto.parameters.values) {
                this.includeDescriptor(item, value, context);
            }
        } else if (item.isDexEncodedField()) {
            DexField field = item.asDexEncodedField().field;
            this.includeDescriptor(item, field.type, context);
        } else assert (item.isDexClass());
    }

    private synchronized void addItemToSets(DexDefinition item, ProguardConfigurationRule context, ProguardMemberRule rule, DexDefinition precondition) {
        block24: {
            block32: {
                block31: {
                    block30: {
                        block29: {
                            block28: {
                                block27: {
                                    block26: {
                                        block25: {
                                            block23: {
                                                if (!(context instanceof ProguardKeepRule)) break block23;
                                                ProguardKeepRule keepRule = (ProguardKeepRule)context;
                                                ProguardKeepRuleModifiers modifiers = keepRule.getModifiers();
                                                if (!modifiers.allowsShrinking) {
                                                    if (precondition != null) {
                                                        this.dependentNoShrinking.computeIfAbsent(precondition, x -> new IdentityHashMap()).put(item, keepRule);
                                                    } else {
                                                        this.noShrinking.put(item, keepRule);
                                                    }
                                                }
                                                if (!modifiers.allowsOptimization) {
                                                    this.noOptimization.add(item);
                                                }
                                                if (!modifiers.allowsObfuscation) {
                                                    this.noObfuscation.add(item);
                                                }
                                                if (modifiers.includeDescriptorClasses) {
                                                    this.includeDescriptorClasses(item, keepRule);
                                                }
                                                break block24;
                                            }
                                            if (!(context instanceof ProguardAssumeNoSideEffectRule)) break block25;
                                            this.noSideEffects.put(item, rule);
                                            break block24;
                                        }
                                        if (!(context instanceof ProguardWhyAreYouKeepingRule)) break block26;
                                        this.reasonAsked.add(item);
                                        break block24;
                                    }
                                    if (!(context instanceof ProguardKeepPackageNamesRule)) break block27;
                                    this.keepPackageName.add(item);
                                    break block24;
                                }
                                if (!(context instanceof ProguardAssumeValuesRule)) break block28;
                                this.assumedValues.put(item, rule);
                                break block24;
                            }
                            if (!(context instanceof ProguardCheckDiscardRule)) break block29;
                            this.checkDiscarded.add(item);
                            break block24;
                        }
                        if (!(context instanceof InlineRule)) break block30;
                        if (!item.isDexEncodedMethod()) break block24;
                        switch (((InlineRule)context).getType()) {
                            case ALWAYS: {
                                this.alwaysInline.add(item.asDexEncodedMethod().method);
                                break block24;
                            }
                            case FORCE: {
                                this.forceInline.add(item.asDexEncodedMethod().method);
                                break block24;
                            }
                            case NEVER: {
                                this.neverInline.add(item.asDexEncodedMethod().method);
                                break block24;
                            }
                            default: {
                                throw new Unreachable();
                            }
                        }
                    }
                    if (!(context instanceof ClassInlineRule)) break block31;
                    switch (((ClassInlineRule)context).getType()) {
                        case NEVER: {
                            if (item.isDexClass()) {
                                this.neverClassInline.add(item.asDexClass().type);
                            }
                            break block24;
                        }
                        default: {
                            throw new Unreachable();
                        }
                    }
                }
                if (!(context instanceof ClassMergingRule)) break block32;
                switch (((ClassMergingRule)context).getType()) {
                    case NEVER: {
                        if (item.isDexClass()) {
                            this.neverMerge.add(item.asDexClass().type);
                        }
                        break block24;
                    }
                    default: {
                        throw new Unreachable();
                    }
                }
            }
            if (context instanceof ProguardIdentifierNameStringRule) {
                if (item.isDexEncodedField()) {
                    this.identifierNameStrings.add(item.asDexEncodedField().field);
                } else if (item.isDexEncodedMethod()) {
                    this.identifierNameStrings.add(item.asDexEncodedMethod().method);
                }
            }
        }
    }

    static class ConsequentRootSet {
        final Map<DexDefinition, ProguardKeepRule> noShrinking;
        final Set<DexDefinition> noOptimization;
        final Set<DexDefinition> noObfuscation;
        final Map<DexDefinition, Map<DexDefinition, ProguardKeepRule>> dependentNoShrinking;

        private ConsequentRootSet(Map<DexDefinition, ProguardKeepRule> noShrinking, Set<DexDefinition> noOptimization, Set<DexDefinition> noObfuscation, Map<DexDefinition, Map<DexDefinition, ProguardKeepRule>> dependentNoShrinking) {
            this.noShrinking = Collections.unmodifiableMap(noShrinking);
            this.noOptimization = Collections.unmodifiableSet(noOptimization);
            this.noObfuscation = Collections.unmodifiableSet(noObfuscation);
            this.dependentNoShrinking = Collections.unmodifiableMap(dependentNoShrinking);
        }
    }

    public static class RootSet {
        public final Map<DexDefinition, ProguardKeepRule> noShrinking;
        public final Set<DexDefinition> noOptimization;
        public final Set<DexDefinition> noObfuscation;
        public final Set<DexDefinition> reasonAsked;
        public final Set<DexDefinition> keepPackageName;
        public final Set<DexDefinition> checkDiscarded;
        public final Set<DexMethod> alwaysInline;
        public final Set<DexMethod> forceInline;
        public final Set<DexMethod> neverInline;
        public final Set<DexType> neverClassInline;
        public final Set<DexType> neverMerge;
        public final Map<DexDefinition, ProguardMemberRule> noSideEffects;
        public final Map<DexDefinition, ProguardMemberRule> assumedValues;
        private final Map<DexDefinition, Map<DexDefinition, ProguardKeepRule>> dependentNoShrinking;
        public final Set<DexReference> identifierNameStrings;
        public final Set<ProguardIfRule> ifRules;

        private RootSet(Map<DexDefinition, ProguardKeepRule> noShrinking, Set<DexDefinition> noOptimization, Set<DexDefinition> noObfuscation, Set<DexDefinition> reasonAsked, Set<DexDefinition> keepPackageName, Set<DexDefinition> checkDiscarded, Set<DexMethod> alwaysInline, Set<DexMethod> forceInline, Set<DexMethod> neverInline, Set<DexType> neverClassInline, Set<DexType> neverMerge, Map<DexDefinition, ProguardMemberRule> noSideEffects, Map<DexDefinition, ProguardMemberRule> assumedValues, Map<DexDefinition, Map<DexDefinition, ProguardKeepRule>> dependentNoShrinking, Set<DexReference> identifierNameStrings, Set<ProguardIfRule> ifRules) {
            this.noShrinking = Collections.unmodifiableMap(noShrinking);
            this.noOptimization = noOptimization;
            this.noObfuscation = noObfuscation;
            this.reasonAsked = Collections.unmodifiableSet(reasonAsked);
            this.keepPackageName = Collections.unmodifiableSet(keepPackageName);
            this.checkDiscarded = Collections.unmodifiableSet(checkDiscarded);
            this.alwaysInline = Collections.unmodifiableSet(alwaysInline);
            this.forceInline = Collections.unmodifiableSet(forceInline);
            this.neverInline = Collections.unmodifiableSet(neverInline);
            this.neverClassInline = Collections.unmodifiableSet(neverClassInline);
            this.neverMerge = Collections.unmodifiableSet(neverMerge);
            this.noSideEffects = Collections.unmodifiableMap(noSideEffects);
            this.assumedValues = Collections.unmodifiableMap(assumedValues);
            this.dependentNoShrinking = dependentNoShrinking;
            this.identifierNameStrings = Collections.unmodifiableSet(identifierNameStrings);
            this.ifRules = Collections.unmodifiableSet(ifRules);
        }

        void addDependentItems(Map<DexDefinition, Map<DexDefinition, ProguardKeepRule>> dependentItems) {
            dependentItems.forEach((def, dependence) -> this.dependentNoShrinking.computeIfAbsent((DexDefinition)def, x -> new IdentityHashMap()).putAll(dependence));
        }

        Map<DexDefinition, ProguardKeepRule> getDependentItems(DexDefinition item) {
            return Collections.unmodifiableMap(this.dependentNoShrinking.getOrDefault(item, Collections.emptyMap()));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("RootSet");
            builder.append("\nnoShrinking: " + this.noShrinking.size());
            builder.append("\nnoOptimization: " + this.noOptimization.size());
            builder.append("\nnoObfuscation: " + this.noObfuscation.size());
            builder.append("\nreasonAsked: " + this.reasonAsked.size());
            builder.append("\nkeepPackageName: " + this.keepPackageName.size());
            builder.append("\ncheckDiscarded: " + this.checkDiscarded.size());
            builder.append("\nnoSideEffects: " + this.noSideEffects.size());
            builder.append("\nassumedValues: " + this.assumedValues.size());
            builder.append("\ndependentNoShrinking: " + this.dependentNoShrinking.size());
            builder.append("\nidentifierNameStrings: " + this.identifierNameStrings.size());
            builder.append("\nifRules: " + this.ifRules.size());
            builder.append("\n\nNo Shrinking:");
            this.noShrinking.keySet().stream().sorted(Comparator.comparing(DexItem::toSourceString)).forEach(a -> builder.append("\n").append(a.toSourceString()).append(" ").append(this.noShrinking.get(a)));
            builder.append("\n");
            return builder.toString();
        }
    }
}

