/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.synthetic;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.Argument;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.CatchHandlers;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.SourceCode;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;

public abstract class SyntheticSourceCode
implements SourceCode {
    protected static final Predicate<IRBuilder> doesNotEndBlock = x -> false;
    protected static final Predicate<IRBuilder> endsBlock = x -> true;
    protected final DexType receiver;
    protected final DexMethod method;
    protected final DexProto proto;
    private int nextRegister = 0;
    private final int receiverRegister;
    private int[] paramRegisters;
    private Value receiverValue;
    private Value[] paramValues;
    private List<Consumer<IRBuilder>> constructors = new ArrayList<Consumer<IRBuilder>>();
    private List<Predicate<IRBuilder>> traceEvents = new ArrayList<Predicate<IRBuilder>>();
    private final Position position;

    protected SyntheticSourceCode(DexType receiver, DexMethod method, Position callerPosition) {
        assert (method != null);
        this.receiver = receiver;
        this.method = method;
        this.proto = method.proto;
        this.receiverRegister = receiver != null ? this.nextRegister(ValueType.OBJECT) : -1;
        DexType[] params = this.proto.parameters.values;
        int paramCount = params.length;
        this.paramRegisters = new int[paramCount];
        this.paramValues = new Value[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            this.paramRegisters[i] = this.nextRegister(ValueType.fromDexType(params[i]));
        }
        this.position = Position.synthetic(0, method, callerPosition);
    }

    protected final void add(Consumer<IRBuilder> constructor) {
        this.add(constructor, doesNotEndBlock);
    }

    protected final void add(Consumer<IRBuilder> constructor, Predicate<IRBuilder> traceEvent) {
        this.constructors.add(constructor);
        this.traceEvents.add(traceEvent);
    }

    protected final int nextRegister(ValueType type) {
        int value = this.nextRegister;
        this.nextRegister += type.requiredRegisters();
        return value;
    }

    protected final Value getReceiverValue() {
        assert (this.receiver != null);
        assert (this.receiverValue != null);
        return this.receiverValue;
    }

    protected final int getReceiverRegister() {
        assert (this.receiver != null);
        assert (this.receiverRegister >= 0);
        return this.receiverRegister;
    }

    protected final Value getParamValue(int paramIndex) {
        assert (paramIndex >= 0);
        assert (paramIndex < this.paramValues.length);
        return this.paramValues[paramIndex];
    }

    protected final int getParamCount() {
        return this.paramValues.length;
    }

    protected final int getParamRegister(int paramIndex) {
        assert (paramIndex >= 0);
        assert (paramIndex < this.paramRegisters.length);
        return this.paramRegisters[paramIndex];
    }

    protected abstract void prepareInstructions();

    @Override
    public final int instructionCount() {
        return this.constructors.size();
    }

    protected final int lastInstructionIndex() {
        return this.constructors.size() - 1;
    }

    protected final int nextInstructionIndex() {
        return this.constructors.size();
    }

    @Override
    public final int instructionIndex(int instructionOffset) {
        return instructionOffset;
    }

    @Override
    public final int instructionOffset(int instructionIndex) {
        return instructionIndex;
    }

    @Override
    public DebugLocalInfo getIncomingLocalAtBlock(int register, int blockOffset) {
        return null;
    }

    @Override
    public DebugLocalInfo getIncomingLocal(int register) {
        return null;
    }

    @Override
    public DebugLocalInfo getOutgoingLocal(int register) {
        return null;
    }

    @Override
    public final int traceInstruction(int instructionIndex, IRBuilder builder) {
        return this.traceEvents.get(instructionIndex).test(builder) || instructionIndex == this.constructors.size() - 1 ? instructionIndex : -1;
    }

    @Override
    public final void setUp() {
        assert (this.constructors.isEmpty());
        this.prepareInstructions();
        assert (!this.constructors.isEmpty());
    }

    @Override
    public final void clear() {
        this.constructors = null;
        this.traceEvents = null;
        this.paramRegisters = null;
        this.paramValues = null;
        this.receiverValue = null;
    }

    @Override
    public final void buildPrelude(IRBuilder builder) {
        if (this.receiver != null) {
            this.receiverValue = builder.writeRegister(this.receiverRegister, ValueType.OBJECT, BasicBlock.ThrowingInfo.NO_THROW);
            builder.add(new Argument(this.receiverValue));
            this.receiverValue.markAsThis();
        }
        DexType[] parameters = this.proto.parameters.values;
        for (int i = 0; i < parameters.length; ++i) {
            Value paramValue;
            ValueType valueType = ValueType.fromDexType(parameters[i]);
            this.paramValues[i] = paramValue = builder.writeRegister(this.paramRegisters[i], valueType, BasicBlock.ThrowingInfo.NO_THROW);
            builder.add(new Argument(paramValue));
        }
    }

    @Override
    public final void buildPostlude(IRBuilder builder) {
    }

    @Override
    public final void buildInstruction(IRBuilder builder, int instructionIndex, boolean firstBlockInstruction) {
        this.constructors.get(instructionIndex).accept(builder);
    }

    @Override
    public void buildBlockTransfer(IRBuilder builder, int predecessorOffset, int successorOffset, boolean isExceptional) {
    }

    @Override
    public final void resolveAndBuildSwitch(int value, int fallthroughOffset, int payloadOffset, IRBuilder builder) {
        throw new Unreachable("Unexpected call to resolveAndBuildSwitch");
    }

    @Override
    public final void resolveAndBuildNewArrayFilledData(int arrayRef, int payloadOffset, IRBuilder builder) {
        throw new Unreachable("Unexpected call to resolveAndBuildNewArrayFilledData");
    }

    @Override
    public final CatchHandlers<Integer> getCurrentCatchHandlers() {
        return null;
    }

    @Override
    public int getMoveExceptionRegister(int instructionIndex) {
        throw new Unreachable();
    }

    @Override
    public Position getCanonicalDebugPositionAtOffset(int offset) {
        throw new Unreachable();
    }

    @Override
    public Position getCurrentPosition() {
        return this.position;
    }

    @Override
    public final boolean verifyCurrentInstructionCanThrow() {
        return true;
    }

    @Override
    public boolean verifyLocalInScope(DebugLocalInfo local) {
        return true;
    }

    @Override
    public final boolean verifyRegister(int register) {
        return true;
    }

    protected boolean endsSwitch(IRBuilder builder, int switchIndex, int fallthrough, int[] offsets) {
        for (int offset : offsets) {
            builder.ensureNormalSuccessorBlock(switchIndex, offset);
        }
        builder.ensureNormalSuccessorBlock(switchIndex, fallthrough);
        return true;
    }
}

