/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.position.Position;
import com.android.tools.r8.shaking.ProguardAccessFlags;
import com.android.tools.r8.shaking.ProguardCheckDiscardRule;
import com.android.tools.r8.shaking.ProguardClassNameList;
import com.android.tools.r8.shaking.ProguardClassSpecification;
import com.android.tools.r8.shaking.ProguardClassType;
import com.android.tools.r8.shaking.ProguardConfigurationRule;
import com.android.tools.r8.shaking.ProguardMemberRule;
import com.android.tools.r8.shaking.ProguardTypeMatcher;
import java.util.List;

public class InlineRule
extends ProguardConfigurationRule {
    private final Type type;

    private InlineRule(Origin origin, Position position, String source, ProguardTypeMatcher classAnnotation, ProguardAccessFlags classAccessFlags, ProguardAccessFlags negatedClassAccessFlags, boolean classTypeNegated, ProguardClassType classType, ProguardClassNameList classNames, ProguardTypeMatcher inheritanceAnnotation, ProguardTypeMatcher inheritanceClassName, boolean inheritanceIsExtends, List<ProguardMemberRule> memberRules, Type type) {
        super(origin, position, source, classAnnotation, classAccessFlags, negatedClassAccessFlags, classTypeNegated, classType, classNames, inheritanceAnnotation, inheritanceClassName, inheritanceIsExtends, memberRules);
        this.type = type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Type getType() {
        return this.type;
    }

    public ProguardCheckDiscardRule asProguardCheckDiscardRule() {
        assert (this.type == Type.FORCE);
        ProguardCheckDiscardRule.Builder builder = ProguardCheckDiscardRule.builder();
        builder.setClassAnnotation(this.getClassAnnotation());
        builder.setClassAccessFlags(this.getClassAccessFlags());
        builder.setNegatedClassAccessFlags(this.getNegatedClassAccessFlags());
        builder.setClassTypeNegated(this.getClassTypeNegated());
        builder.setClassType(this.getClassType());
        builder.setClassNames(this.getClassNames());
        builder.setInheritanceAnnotation(this.getInheritanceAnnotation());
        builder.setInheritanceIsExtends(this.getInheritanceIsExtends());
        builder.setMemberRules(this.getMemberRules());
        return builder.build();
    }

    @Override
    String typeString() {
        switch (this.type) {
            case ALWAYS: {
                return "alwaysinline";
            }
            case FORCE: {
                return "forceinline";
            }
            case NEVER: {
                return "neverinline";
            }
        }
        throw new Unreachable("Unknown inline type " + (Object)((Object)this.type));
    }

    public static class Builder
    extends ProguardClassSpecification.Builder<InlineRule, Builder> {
        Type type;

        private Builder() {
        }

        @Override
        public Builder self() {
            return this;
        }

        public Builder setType(Type type) {
            this.type = type;
            return this;
        }

        @Override
        public InlineRule build() {
            return new InlineRule(this.origin, this.getPosition(), this.source, this.classAnnotation, this.classAccessFlags, this.negatedClassAccessFlags, this.classTypeNegated, this.classType, this.classNames, this.inheritanceAnnotation, this.inheritanceClassName, this.inheritanceIsExtends, this.memberRules, this.type);
        }
    }

    public static enum Type {
        ALWAYS,
        FORCE,
        NEVER;

    }
}

