/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

public class ReferenceTypeLatticeElement
extends TypeLatticeElement {
    private static final ReferenceTypeLatticeElement NULL_INSTANCE = new ReferenceTypeLatticeElement(DexItemFactory.nullValueType, true);
    private static final ReferenceTypeLatticeElement REFERENCE_INSTANCE = new ReferenceTypeLatticeElement(DexItemFactory.unknownType, true);
    final DexType type;
    final Set<DexType> interfaces;

    ReferenceTypeLatticeElement(DexType type, boolean isNullable) {
        this(type, isNullable, ImmutableSet.of());
    }

    ReferenceTypeLatticeElement(DexType type, boolean isNullable, Set<DexType> interfaces) {
        super(isNullable);
        this.type = type;
        this.interfaces = Collections.unmodifiableSet(interfaces);
    }

    static ReferenceTypeLatticeElement getNullTypeLatticeElement() {
        return NULL_INSTANCE;
    }

    static ReferenceTypeLatticeElement getReferenceTypeLatticeElement() {
        return REFERENCE_INSTANCE;
    }

    @Override
    public boolean isNull() {
        return this.type == DexItemFactory.nullValueType;
    }

    @Override
    public boolean isReferenceInstance() {
        return this.type == DexItemFactory.unknownType;
    }

    @Override
    TypeLatticeElement asNullable() {
        assert (this.isNull() || this.isReferenceInstance());
        return this;
    }

    @Override
    public boolean isReference() {
        return true;
    }

    @Override
    public TypeLatticeElement arrayGet(AppInfo appInfo) {
        return this.isNull() ? this : BOTTOM;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.isNullableString()).append(this.type.toString());
        if (!this.interfaces.isEmpty()) {
            builder.append(" [");
            builder.append(this.interfaces.stream().map(DexType::toString).collect(Collectors.joining(", ")));
            builder.append("]");
        }
        return builder.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        ReferenceTypeLatticeElement other = (ReferenceTypeLatticeElement)o;
        if (!this.type.equals(other.type)) {
            return false;
        }
        if (this.interfaces.size() != other.interfaces.size()) {
            return false;
        }
        return this.interfaces.containsAll(other.interfaces);
    }

    @Override
    public int hashCode() {
        int prime = this.type.isUnknown() ? 3 : (this.type.isArrayType() ? 7 : 5);
        return super.hashCode() * this.type.hashCode() * prime;
    }
}

