/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.ConstInstruction;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;

public class Move
extends Instruction {
    private static final String ERROR_MESSAGE = "This DEX-specific instruction should not be seen in the CF backend";

    public Move(Value dest, Value src) {
        super(dest, src);
        if (src.isNeverNull() && dest.canBeNull()) {
            dest.markNeverNull();
        }
    }

    @Override
    boolean computeNeverNull() {
        return this.src().isNeverNull();
    }

    public Value dest() {
        return this.outValue;
    }

    public Value src() {
        return (Value)this.inValues.get(0);
    }

    @Override
    public void buildDex(DexBuilder builder) {
        builder.addMove(this);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        throw new Unreachable(ERROR_MESSAGE);
    }

    @Override
    public int maxInValueRegister() {
        return 65535;
    }

    @Override
    public int maxOutValueRegister() {
        return 65535;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isMove();
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        assert (other.isMove());
        return 0;
    }

    @Override
    public String toString() {
        return super.toString() + " (" + (Object)((Object)this.outType()) + ")";
    }

    @Override
    public boolean isOutConstant() {
        return this.src().isConstant();
    }

    @Override
    public ConstInstruction getOutConstantConstInstruction() {
        assert (this.isOutConstant());
        return this.src().definition.getOutConstantConstInstruction();
    }

    @Override
    public boolean isMove() {
        return true;
    }

    @Override
    public Move asMove() {
        return this;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forMove();
    }

    @Override
    public TypeLatticeElement evaluate(AppInfo appInfo) {
        return this.src().getTypeLattice();
    }

    @Override
    public boolean hasInvariantOutType() {
        return false;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        throw new Unreachable(ERROR_MESSAGE);
    }
}

