/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.IRBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class TypeConstraintResolver {
    private final Map<Value, Value> unificationParents = new HashMap<Value, Value>();

    public void resolve(IRCode code, IRBuilder builder) {
        ArrayList<Value> impreciseValues = new ArrayList<Value>();
        for (BasicBlock block : code.blocks) {
            for (Phi phi : block.getPhis()) {
                if (!phi.outType().isPreciseType()) {
                    impreciseValues.add(phi);
                }
                for (Value value : phi.getOperands()) {
                    this.merge(phi, value);
                }
            }
            for (Instruction instruction : block.getInstructions()) {
                if (instruction.outValue() != null && !instruction.outType().isPreciseType()) {
                    impreciseValues.add(instruction.outValue());
                }
                if (!instruction.isIf() || instruction.inValues().size() != 2) continue;
                If ifInstruction = instruction.asIf();
                assert (!ifInstruction.isZeroTest());
                If.Type type = ifInstruction.getType();
                if (type != If.Type.EQ && type != If.Type.NE) continue;
                this.merge(ifInstruction.inValues().get(0), ifInstruction.inValues().get(1));
            }
        }
        for (Value value : impreciseValues) {
            builder.constrainType(value, this.getPreciseType(value));
        }
    }

    private void merge(Value value1, Value value2) {
        this.link(this.canonical(value1), this.canonical(value2));
    }

    private ValueType getPreciseType(Value value) {
        ValueType type = this.canonical(value).outType();
        return type != ValueType.INT_OR_FLOAT_OR_NULL ? type : ValueType.INT_OR_FLOAT;
    }

    private void link(Value canonical1, Value canonical2) {
        if (canonical1 == canonical2) {
            return;
        }
        ValueType type1 = canonical1.outType();
        ValueType type2 = canonical2.outType();
        if (type1.isPreciseType() && type2.isPreciseType()) {
            if (type1 != type2) {
                throw new CompilationError("Cannot unify types for values " + canonical1 + ":" + (Object)((Object)type1) + " and " + canonical2 + ":" + (Object)((Object)type2));
            }
            return;
        }
        if (type1.isPreciseType()) {
            this.unificationParents.put(canonical2, canonical1);
        } else {
            this.unificationParents.put(canonical1, canonical2);
        }
    }

    private Value canonical(Value value) {
        Value parent = value;
        while (parent != null) {
            Value grandparent = this.unificationParents.get(parent);
            if (grandparent != null) {
                this.unificationParents.put(value, grandparent);
            }
            value = parent;
            parent = grandparent;
        }
        return value;
    }
}

