/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar;

import com.android.tools.r8.com.google.common.collect.Lists;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.ConstString;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeCustom;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.NewInstance;
import com.android.tools.r8.ir.code.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class StringConcatRewriter {
    private static final String CONCAT_FACTORY_TYPE_DESCR = "Ljava/lang/invoke/StringConcatFactory;";
    private static final String CALLSITE_TYPE_DESCR = "Ljava/lang/invoke/CallSite;";
    private static final String LOOKUP_TYPE_DESCR = "Ljava/lang/invoke/MethodHandles$Lookup;";
    private static final String METHOD_TYPE_TYPE_DESCR = "Ljava/lang/invoke/MethodType;";
    private static final String MAKE_CONCAT = "makeConcat";
    private static final String MAKE_CONCAT_WITH_CONSTANTS = "makeConcatWithConstants";
    private static final String TO_STRING = "toString";
    private static final String APPEND = "append";
    private final AppInfo appInfo;
    private final DexItemFactory factory;
    private final DexMethod makeConcat;
    private final DexMethod makeConcatWithConstants;
    private final DexMethod stringBuilderInit;
    private final DexMethod stringBuilderToString;
    private final Map<DexType, DexMethod> paramTypeToAppendMethod = new IdentityHashMap<DexType, DexMethod>();
    private final DexMethod defaultAppendMethod;

    public StringConcatRewriter(AppInfo appInfo) {
        this.appInfo = appInfo;
        assert (appInfo.dexItemFactory != null);
        this.factory = appInfo.dexItemFactory;
        DexType factoryType = this.factory.createType(CONCAT_FACTORY_TYPE_DESCR);
        DexType callSiteType = this.factory.createType(CALLSITE_TYPE_DESCR);
        DexType lookupType = this.factory.createType(LOOKUP_TYPE_DESCR);
        DexType methodTypeType = this.factory.createType(METHOD_TYPE_TYPE_DESCR);
        this.makeConcat = this.factory.createMethod(factoryType, this.factory.createProto(callSiteType, lookupType, this.factory.stringType, methodTypeType), this.factory.createString(MAKE_CONCAT));
        this.makeConcatWithConstants = this.factory.createMethod(factoryType, this.factory.createProto(callSiteType, lookupType, this.factory.stringType, methodTypeType, this.factory.stringType, this.factory.objectArrayType), this.factory.createString(MAKE_CONCAT_WITH_CONSTANTS));
        this.stringBuilderInit = this.factory.createMethod(this.factory.stringBuilderType, this.factory.createProto(this.factory.voidType, new DexType[0]), this.factory.createString("<init>"));
        this.stringBuilderToString = this.factory.createMethod(this.factory.stringBuilderType, this.factory.createProto(this.factory.stringType, new DexType[0]), this.factory.createString(TO_STRING));
        DexType stringBuilderType = this.factory.stringBuilderType;
        this.paramTypeToAppendMethod.put(this.factory.booleanType, this.factory.createMethod(stringBuilderType, this.factory.createProto(stringBuilderType, this.factory.booleanType), APPEND));
        this.paramTypeToAppendMethod.put(this.factory.charType, this.factory.createMethod(stringBuilderType, this.factory.createProto(stringBuilderType, this.factory.charType), APPEND));
        this.paramTypeToAppendMethod.put(this.factory.byteType, this.factory.createMethod(stringBuilderType, this.factory.createProto(stringBuilderType, this.factory.intType), APPEND));
        this.paramTypeToAppendMethod.put(this.factory.shortType, this.factory.createMethod(stringBuilderType, this.factory.createProto(stringBuilderType, this.factory.intType), APPEND));
        this.paramTypeToAppendMethod.put(this.factory.intType, this.factory.createMethod(stringBuilderType, this.factory.createProto(stringBuilderType, this.factory.intType), APPEND));
        this.paramTypeToAppendMethod.put(this.factory.longType, this.factory.createMethod(stringBuilderType, this.factory.createProto(stringBuilderType, this.factory.longType), APPEND));
        this.paramTypeToAppendMethod.put(this.factory.floatType, this.factory.createMethod(stringBuilderType, this.factory.createProto(stringBuilderType, this.factory.floatType), APPEND));
        this.paramTypeToAppendMethod.put(this.factory.doubleType, this.factory.createMethod(stringBuilderType, this.factory.createProto(stringBuilderType, this.factory.doubleType), APPEND));
        this.paramTypeToAppendMethod.put(this.factory.stringType, this.factory.createMethod(stringBuilderType, this.factory.createProto(stringBuilderType, this.factory.stringType), APPEND));
        this.defaultAppendMethod = this.factory.createMethod(stringBuilderType, this.factory.createProto(stringBuilderType, this.factory.objectType), APPEND);
    }

    public void desugarStringConcats(DexMethod method, IRCode code) {
        ListIterator<BasicBlock> blocks = code.listIterator();
        while (blocks.hasNext()) {
            BasicBlock block = blocks.next();
            InstructionListIterator instructions = block.listIterator();
            while (instructions.hasNext()) {
                Instruction instruction = (Instruction)instructions.next();
                if (!instruction.isInvokeCustom()) continue;
                InvokeCustom invokeCustom = instruction.asInvokeCustom();
                DexCallSite callSite = invokeCustom.getCallSite();
                if (!callSite.bootstrapMethod.type.isInvokeStatic()) continue;
                DexMethod bootstrapMethod = callSite.bootstrapMethod.asMethod();
                if (bootstrapMethod == this.makeConcat) {
                    this.rewriteMakeConcat(method, code, blocks, instructions, invokeCustom);
                    continue;
                }
                if (bootstrapMethod != this.makeConcatWithConstants) continue;
                this.rewriteMakeConcatWithConstants(method, code, blocks, instructions, invokeCustom);
            }
        }
    }

    private void rewriteMakeConcat(DexMethod method, IRCode code, ListIterator<BasicBlock> blocks, InstructionListIterator instructions, InvokeCustom invokeCustom) {
        DexProto proto = invokeCustom.getCallSite().methodProto;
        DexType[] parameters = proto.parameters.values;
        int paramCount = parameters.length;
        List<Value> arguments = invokeCustom.inValues();
        if (paramCount != arguments.size()) {
            throw StringConcatRewriter.error(method, "inconsistent arguments: expected " + paramCount + ", actual " + arguments.size());
        }
        ConcatBuilder builder = new ConcatBuilder(this.appInfo, code, blocks, instructions);
        for (int i = 0; i < paramCount; ++i) {
            builder.addChunk(arguments.get(i), this.paramTypeToAppendMethod.getOrDefault(parameters[i], this.defaultAppendMethod));
        }
        builder.desugar();
    }

    private void rewriteMakeConcatWithConstants(DexMethod method, IRCode code, ListIterator<BasicBlock> blocks, InstructionListIterator instructions, InvokeCustom invokeCustom) {
        DexCallSite callSite = invokeCustom.getCallSite();
        DexProto proto = callSite.methodProto;
        DexType[] parameters = proto.parameters.values;
        int paramCount = parameters.length;
        List<Value> callArgs = invokeCustom.inValues();
        List<DexValue> bootstrapArgs = callSite.bootstrapArgs;
        if (paramCount != callArgs.size()) {
            throw StringConcatRewriter.error(method, "inconsistent arguments: expected " + paramCount + ", actual " + callArgs.size());
        }
        if (bootstrapArgs.size() == 0) {
            throw StringConcatRewriter.error(method, "bootstrap method misses `recipe` argument");
        }
        ArrayList<DexValue> constArgs = new ArrayList<DexValue>();
        for (int i = 1; i < bootstrapArgs.size(); ++i) {
            constArgs.add(bootstrapArgs.get(i));
        }
        DexValue recipeValue = bootstrapArgs.get(0);
        if (!(recipeValue instanceof DexValue.DexValueString)) {
            throw StringConcatRewriter.error(method, "bootstrap method argument `recipe` must be a string");
        }
        String recipe = ((DexValue.DexValueString)recipeValue).getValue().toString();
        ConcatBuilder builder = new ConcatBuilder(this.appInfo, code, blocks, instructions);
        StringBuilder acc = new StringBuilder();
        int argIndex = 0;
        int constArgIndex = 0;
        int length = recipe.length();
        for (int i = 0; i < length; ++i) {
            char c = recipe.charAt(i);
            if (c == '\u0001') {
                if (acc.length() > 0) {
                    builder.addChunk(acc.toString(), this.paramTypeToAppendMethod.get(this.factory.stringType));
                    acc.setLength(0);
                }
                if (argIndex >= paramCount) {
                    throw StringConcatRewriter.error(method, "too many argument references in `recipe`");
                }
                builder.addChunk(callArgs.get(argIndex), this.paramTypeToAppendMethod.getOrDefault(parameters[argIndex], this.defaultAppendMethod));
                ++argIndex;
                continue;
            }
            if (c == '\u0002') {
                if (constArgIndex >= constArgs.size()) {
                    throw StringConcatRewriter.error(method, "too many constant references in `recipe`");
                }
                acc.append(StringConcatRewriter.convertToString(method, (DexValue)constArgs.get(constArgIndex++)));
                continue;
            }
            acc.append(c);
        }
        if (argIndex != paramCount) {
            throw StringConcatRewriter.error(method, "too few argument references in `recipe`, expected " + paramCount + ", referenced: " + argIndex);
        }
        if (constArgIndex != constArgs.size()) {
            throw StringConcatRewriter.error(method, "too few constant references in `recipe`, expected " + constArgs.size() + ", referenced: " + constArgIndex);
        }
        if (acc.length() > 0) {
            builder.addChunk(acc.toString(), this.paramTypeToAppendMethod.get(this.factory.stringType));
        }
        builder.desugar();
    }

    private static String convertToString(DexMethod method, DexValue value) {
        if (value instanceof DexValue.DexValueString) {
            return ((DexValue.DexValueString)value).getValue().toString();
        }
        throw StringConcatRewriter.error(method, "const arg referenced from `recipe` is not supported: " + value.getClass().getName());
    }

    private static CompilationError error(DexMethod method, String message) {
        return new CompilationError("String concatenation desugaring error (method: " + method.qualifiedName() + "): " + message);
    }

    private final class ConcatBuilder {
        private final AppInfo appInfo;
        private final IRCode code;
        private final ListIterator<BasicBlock> blocks;
        private final InstructionListIterator instructions;
        private final Instruction invokeCustom;
        private final BasicBlock currentBlock;
        private final List<Chunk> chunks = new ArrayList<Chunk>();

        private ConcatBuilder(AppInfo appInfo, IRCode code, ListIterator<BasicBlock> blocks, InstructionListIterator instructions) {
            this.appInfo = appInfo;
            this.code = code;
            this.blocks = blocks;
            this.instructions = instructions;
            this.invokeCustom = instructions.peekPrevious();
            assert (this.invokeCustom.isInvokeCustom());
            this.currentBlock = this.invokeCustom.getBlock();
        }

        private void appendInstruction(Instruction instruction) {
            instruction.setPosition(this.invokeCustom.getPosition());
            this.instructions.add(instruction);
        }

        final void addChunk(Value value, DexMethod method) {
            this.chunks.add(new ArgumentChunk(value, method));
        }

        final void addChunk(String str, DexMethod method) {
            this.chunks.add(new ConstantChunk(str, method));
        }

        final void desugar() {
            this.instructions.previous();
            TypeLatticeElement stringBuilderTypeLattice = TypeLatticeElement.fromDexType(((StringConcatRewriter)StringConcatRewriter.this).factory.stringBuilderType, this.appInfo, false);
            Value sbInstance = this.code.createValue(stringBuilderTypeLattice);
            this.appendInstruction(new NewInstance(((StringConcatRewriter)StringConcatRewriter.this).factory.stringBuilderType, sbInstance));
            this.appendInstruction(new InvokeDirect(StringConcatRewriter.this.stringBuilderInit, null, Collections.singletonList(sbInstance)));
            for (Chunk chunk : this.chunks) {
                chunk.addAppendCall(sbInstance);
            }
            Instruction nextInstruction = (Instruction)this.instructions.next();
            assert (this.invokeCustom == nextInstruction);
            Value concatValue = this.invokeCustom.outValue();
            if (concatValue == null) {
                concatValue = this.code.createValue(TypeLatticeElement.stringClassType(this.appInfo));
            }
            this.instructions.replaceCurrentInstruction(new InvokeVirtual(StringConcatRewriter.this.stringBuilderToString, concatValue, Collections.singletonList(sbInstance)));
            if (!this.currentBlock.hasCatchHandlers()) {
                return;
            }
            ArrayList<BasicBlock> newBlocks = new ArrayList<BasicBlock>();
            InstructionListIterator it = this.currentBlock.listIterator();
            while (it.hasNext()) {
                Instruction instruction = (Instruction)it.next();
                if (!instruction.instructionTypeCanThrow() || !it.hasNext()) continue;
                BasicBlock newBlock = it.split(this.code, this.blocks);
                newBlocks.add(newBlock);
                it = newBlock.listIterator();
            }
            for (BasicBlock newBlock : newBlocks) {
                newBlock.copyCatchHandlers(this.code, this.blocks, this.currentBlock);
            }
        }

        private final class ConstantChunk
        extends Chunk {
            final String str;

            ConstantChunk(String str, DexMethod method) {
                super(method);
                this.str = str;
            }

            @Override
            Value getOrCreateValue() {
                Value value = ConcatBuilder.this.code.createValue(TypeLatticeElement.stringClassType(ConcatBuilder.this.appInfo));
                ConcatBuilder.this.appendInstruction(new ConstString(value, StringConcatRewriter.this.factory.createString(this.str)));
                return value;
            }
        }

        private final class ArgumentChunk
        extends Chunk {
            final Value value;

            ArgumentChunk(Value value, DexMethod method) {
                super(method);
                this.value = value;
            }

            @Override
            Value getOrCreateValue() {
                return this.value;
            }
        }

        private abstract class Chunk {
            final DexMethod method;

            Chunk(DexMethod method) {
                this.method = method;
            }

            abstract Value getOrCreateValue();

            final void addAppendCall(Value sbInstance) {
                ConcatBuilder.this.appendInstruction(new InvokeVirtual(this.method, null, Lists.newArrayList(sbInstance, this.getOrCreateValue())));
            }
        }
    }
}

