/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import com.android.tools.r8.ir.code.InvokePolymorphic;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CallSiteInformation;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningInfo;
import com.android.tools.r8.ir.optimize.InliningOracle;
import com.android.tools.r8.ir.optimize.InliningStrategy;
import com.android.tools.r8.ir.optimize.NonNullTracker;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.IteratorUtils;
import java.util.BitSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.function.Predicate;

final class DefaultInliningOracle
implements InliningOracle,
InliningStrategy {
    private final AppView<? extends Enqueuer.AppInfoWithLiveness> appView;
    private final Inliner inliner;
    private final DexEncodedMethod method;
    private final IRCode code;
    private final CallSiteInformation callSiteInformation;
    private final Predicate<DexEncodedMethod> isProcessedConcurrently;
    private final InliningInfo info;
    private final InternalOptions options;
    private final int inliningInstructionLimit;
    private int instructionAllowance;

    DefaultInliningOracle(AppView<? extends Enqueuer.AppInfoWithLiveness> appView, Inliner inliner, DexEncodedMethod method, IRCode code, CallSiteInformation callSiteInformation, Predicate<DexEncodedMethod> isProcessedConcurrently, InternalOptions options, int inliningInstructionLimit, int inliningInstructionAllowance) {
        this.appView = appView;
        this.inliner = inliner;
        this.method = method;
        this.code = code;
        this.callSiteInformation = callSiteInformation;
        this.isProcessedConcurrently = isProcessedConcurrently;
        this.info = null;
        this.options = options;
        this.inliningInstructionLimit = inliningInstructionLimit;
        this.instructionAllowance = inliningInstructionAllowance;
    }

    @Override
    public void finish() {
    }

    private DexEncodedMethod validateCandidate(InvokeMethod invoke, DexType invocationContext) {
        DexEncodedMethod candidate = invoke.lookupSingleTarget(this.inliner.appView.appInfo(), invocationContext);
        if (candidate == null || candidate.getCode() == null || this.inliner.appView.appInfo().definitionFor(candidate.method.getHolder()).isLibraryClass()) {
            if (this.info != null) {
                this.info.exclude(invoke, "No inlinee");
            }
            return null;
        }
        int numberOfArguments = invoke.arguments().size() - (invoke.isInvokeMethodWithReceiver() ? 1 : 0);
        if (numberOfArguments != candidate.method.getArity()) {
            if (this.info != null) {
                this.info.exclude(invoke, "Argument number mismatch");
            }
            return null;
        }
        return candidate;
    }

    private Inliner.Reason computeInliningReason(DexEncodedMethod target) {
        if (target.getOptimizationInfo().forceInline() || this.inliner.appView.appInfo().hasLiveness() && this.inliner.appView.withLiveness().appInfo().forceInline.contains(target.method)) {
            return Inliner.Reason.FORCE;
        }
        if (this.inliner.appView.appInfo().hasLiveness() && this.inliner.appView.withLiveness().appInfo().alwaysInline.contains(target.method)) {
            return Inliner.Reason.ALWAYS;
        }
        if (this.callSiteInformation.hasSingleCallSite(target)) {
            return Inliner.Reason.SINGLE_CALLER;
        }
        if (this.isDoubleInliningTarget(target)) {
            return Inliner.Reason.DUAL_CALLER;
        }
        return Inliner.Reason.SIMPLE;
    }

    private boolean canInlineStaticInvoke(DexEncodedMethod method, DexEncodedMethod target) {
        DexType targetHolder = target.method.getHolder();
        if (method.method.getHolder() == targetHolder) {
            return true;
        }
        DexClass clazz = this.inliner.appView.appInfo().definitionFor(targetHolder);
        assert (clazz != null);
        if (target.getOptimizationInfo().triggersClassInitBeforeAnySideEffect()) {
            return true;
        }
        return this.classInitializationHasNoSideffects(targetHolder);
    }

    private boolean classInitializationHasNoSideffects(DexType classToCheck) {
        DexClass clazz = this.inliner.appView.appInfo().definitionFor(classToCheck);
        if (clazz == null || clazz.hasNonTrivialClassInitializer() || clazz.defaultValuesForStaticFieldsMayTriggerAllocation()) {
            return false;
        }
        for (DexType iface : clazz.interfaces.values) {
            if (this.classInitializationHasNoSideffects(iface)) continue;
            return false;
        }
        return clazz.superType == null || this.classInitializationHasNoSideffects(clazz.superType);
    }

    private synchronized boolean isDoubleInliningTarget(DexEncodedMethod candidate) {
        return this.inliner.isDoubleInliningTarget(this.callSiteInformation, candidate) && candidate.getCode().estimatedSizeForInliningAtMost(10);
    }

    private boolean passesInliningConstraints(InvokeMethod invoke, DexEncodedMethod candidate, Inliner.Reason reason) {
        int instructionLimit;
        Code code;
        if (candidate.getOptimizationInfo().neverInline()) {
            return false;
        }
        if (this.method == candidate) {
            assert (!candidate.getOptimizationInfo().forceInline());
            if (this.info != null) {
                this.info.exclude(invoke, "direct recursion");
            }
            return false;
        }
        if (reason != Inliner.Reason.FORCE && this.isProcessedConcurrently.test(candidate)) {
            if (this.info != null) {
                this.info.exclude(invoke, "is processed in parallel");
            }
            return false;
        }
        if (this.options.testing.validInliningReasons != null && !this.options.testing.validInliningReasons.contains((Object)reason)) {
            return false;
        }
        if (!this.inliner.hasInliningAccess(this.method, candidate)) {
            if (this.info != null) {
                this.info.exclude(invoke, "target does not have right access");
            }
            return false;
        }
        DexClass holder = this.inliner.appView.appInfo().definitionFor(candidate.method.getHolder());
        if (holder.isInterface()) {
            if (this.info != null) {
                this.info.exclude(invoke, "Do not inline target if method holder is an interface class");
            }
            return false;
        }
        if (holder.isLibraryClass()) {
            return false;
        }
        if (candidate.accessFlags.isSynchronized()) {
            if (this.info != null) {
                this.info.exclude(invoke, "target is synchronized");
            }
            return false;
        }
        if (reason == Inliner.Reason.DUAL_CALLER && this.inliner.doubleInlining(this.method, candidate) == null) {
            if (this.info != null) {
                this.info.exclude(invoke, "target is not ready for double inlining");
            }
            return false;
        }
        return reason != Inliner.Reason.SIMPLE || (code = candidate.getCode()).estimatedSizeForInliningAtMost(instructionLimit = this.computeInstructionLimit(invoke, candidate));
    }

    private int computeInstructionLimit(InvokeMethod invoke, DexEncodedMethod candidate) {
        int instructionLimit = this.inliningInstructionLimit;
        BitSet hints = candidate.getOptimizationInfo().getKotlinNotNullParamHints();
        if (hints != null) {
            List<Value> arguments = invoke.inValues();
            if (invoke.isInvokeMethodWithReceiver()) {
                arguments = arguments.subList(1, arguments.size());
            }
            for (int index = 0; index < arguments.size(); ++index) {
                Value argument = arguments.get(index);
                if (!argument.isNeverNull() || !hints.get(index)) continue;
                instructionLimit += 4;
            }
        }
        return instructionLimit;
    }

    @Override
    public Inliner.InlineAction computeForInvokeWithReceiver(InvokeMethodWithReceiver invoke, DexType invocationContext) {
        boolean receiverIsNeverNull;
        DexEncodedMethod candidate = this.validateCandidate(invoke, invocationContext);
        if (candidate == null || this.inliner.isBlackListed(candidate)) {
            return null;
        }
        boolean bl = receiverIsNeverNull = !invoke.getReceiver().getTypeLattice().isNullable();
        if (!receiverIsNeverNull && !candidate.getOptimizationInfo().checksNullReceiverBeforeAnySideEffect()) {
            if (this.info != null) {
                this.info.exclude(invoke, "receiver for candidate can be null");
            }
            assert (!this.inliner.appView.appInfo().forceInline.contains(candidate.method));
            return null;
        }
        Inliner.Reason reason = this.computeInliningReason(candidate);
        if (!candidate.isInliningCandidate(this.method, reason, (AppInfoWithSubtyping)this.inliner.appView.appInfo())) {
            if (this.info != null) {
                this.info.exclude(invoke, "target is not identified for inlining");
            }
            return null;
        }
        if (!this.passesInliningConstraints(invoke, candidate, reason)) {
            return null;
        }
        if (this.info != null) {
            this.info.include(invoke.getType(), candidate);
        }
        return new Inliner.InlineAction(candidate, invoke, reason);
    }

    @Override
    public Inliner.InlineAction computeForInvokeStatic(InvokeStatic invoke, DexType invocationContext) {
        DexEncodedMethod candidate = this.validateCandidate(invoke, invocationContext);
        if (candidate == null || this.inliner.isBlackListed(candidate)) {
            return null;
        }
        Inliner.Reason reason = this.computeInliningReason(candidate);
        if (!candidate.isInliningCandidate(this.method, reason, (AppInfoWithSubtyping)this.inliner.appView.appInfo())) {
            if (this.info != null) {
                this.info.exclude(invoke, "target is not identified for inlining");
            }
            return null;
        }
        if (!this.canInlineStaticInvoke(this.method, candidate)) {
            if (this.info != null) {
                this.info.exclude(invoke, "target is static but we cannot guarantee class has been initialized");
            }
            return null;
        }
        if (!this.passesInliningConstraints(invoke, candidate, reason)) {
            return null;
        }
        if (this.info != null) {
            this.info.include(invoke.getType(), candidate);
        }
        return new Inliner.InlineAction(candidate, invoke, reason);
    }

    @Override
    public Inliner.InlineAction computeForInvokePolymorphic(InvokePolymorphic invoke, DexType invocationContext) {
        if (this.info != null) {
            this.info.exclude(invoke, "inlining through invoke signature polymorpic is not supported");
        }
        return null;
    }

    @Override
    public void ensureMethodProcessed(DexEncodedMethod target, IRCode inlinee) {
        if (!target.isProcessed()) {
            this.inliner.performInlining(target, inlinee, this.isProcessedConcurrently, this.callSiteInformation);
        }
    }

    @Override
    public boolean isValidTarget(InvokeMethod invoke, DexEncodedMethod target, IRCode inlinee) {
        return !target.isInstanceInitializer() || this.inliner.legalConstructorInline(this.method, invoke, inlinee);
    }

    @Override
    public boolean exceededAllowance() {
        return this.instructionAllowance < 0;
    }

    @Override
    public void markInlined(IRCode inlinee) {
        this.instructionAllowance -= this.inliner.numberOfInstructions(inlinee);
    }

    @Override
    public void updateTypeInformationIfNeeded(IRCode inlinee, ListIterator<BasicBlock> blockIterator, BasicBlock block) {
        if (this.inliner.options.enableNonNullTracking) {
            BasicBlock state = IteratorUtils.peekNext(blockIterator);
            while (blockIterator.hasPrevious() && blockIterator.previous() != block) {
            }
            assert (IteratorUtils.peekNext(blockIterator) == block);
            Set<Value> nonNullValues = new NonNullTracker(this.appView.appInfo()).addNonNullInPart(this.code, blockIterator, inlinee.blocks::contains);
            assert (!blockIterator.hasNext());
            while (blockIterator.hasPrevious() && blockIterator.previous() != state) {
            }
            assert (IteratorUtils.peekNext(blockIterator) == state);
            new TypeAnalysis(this.inliner.appView.appInfo(), this.code.method).narrowing(nonNullValues);
        }
    }

    @Override
    public DexType getReceiverTypeIfKnown(InvokeMethod invoke) {
        return null;
    }
}

