/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.naming.DictionaryReader;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.position.Position;
import com.android.tools.r8.shaking.FilteredClassPath;
import com.android.tools.r8.shaking.ProguardClassFilter;
import com.android.tools.r8.shaking.ProguardClassNameList;
import com.android.tools.r8.shaking.ProguardConfigurationRule;
import com.android.tools.r8.shaking.ProguardKeepAttributes;
import com.android.tools.r8.shaking.ProguardKeepRule;
import com.android.tools.r8.shaking.ProguardPathFilter;
import com.android.tools.r8.shaking.ProguardPathList;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Reporter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ProguardConfiguration {
    private final String parsedConfiguration;
    private final DexItemFactory dexItemFactory;
    private final ImmutableList<FilteredClassPath> injars;
    private final ImmutableList<FilteredClassPath> libraryjars;
    private final InternalOptions.PackageObfuscationMode packageObfuscationMode;
    private final String packagePrefix;
    private final boolean allowAccessModification;
    private final boolean ignoreWarnings;
    private final boolean optimizing;
    private final boolean obfuscating;
    private final boolean shrinking;
    private final boolean printConfiguration;
    private final Path printConfigurationFile;
    private final boolean printUsage;
    private final Path printUsageFile;
    private final boolean printMapping;
    private final Path printMappingFile;
    private final Path applyMappingFile;
    private final boolean verbose;
    private final String renameSourceFileAttribute;
    private final ProguardKeepAttributes keepAttributes;
    private final ProguardClassFilter dontWarnPatterns;
    private final ProguardClassFilter dontNotePatterns;
    protected final ImmutableList<ProguardConfigurationRule> rules;
    private final boolean printSeeds;
    private final Path seedFile;
    private final boolean overloadAggressively;
    private final ImmutableList<String> obfuscationDictionary;
    private final ImmutableList<String> classObfuscationDictionary;
    private final ImmutableList<String> packageObfuscationDictionary;
    private final boolean useUniqueClassMemberNames;
    private final boolean keepParameterNames;
    private final ProguardClassFilter adaptClassStrings;
    private final ProguardPathFilter adaptResourceFilenames;
    private final ProguardPathFilter adaptResourceFileContents;
    private final ProguardPathFilter keepDirectories;

    private ProguardConfiguration(String parsedConfiguration, DexItemFactory factory, List<FilteredClassPath> injars, List<FilteredClassPath> libraryjars, InternalOptions.PackageObfuscationMode packageObfuscationMode, String packagePrefix, boolean allowAccessModification, boolean ignoreWarnings, boolean optimizing, boolean obfuscating, boolean shrinking, boolean printConfiguration, Path printConfigurationFile, boolean printUsage, Path printUsageFile, boolean printMapping, Path printMappingFile, Path applyMappingFile, boolean verbose, String renameSourceFileAttribute, ProguardKeepAttributes keepAttributes, ProguardClassFilter dontWarnPatterns, ProguardClassFilter dontNotePatterns, Set<ProguardConfigurationRule> rules, boolean printSeeds, Path seedFile, boolean overloadAggressively, ImmutableList<String> obfuscationDictionary, ImmutableList<String> classObfuscationDictionary, ImmutableList<String> packageObfuscationDictionary, boolean useUniqueClassMemberNames, boolean keepParameterNames, ProguardClassFilter adaptClassStrings, ProguardPathFilter adaptResourceFilenames, ProguardPathFilter adaptResourceFileContents, ProguardPathFilter keepDirectories) {
        this.parsedConfiguration = parsedConfiguration;
        this.dexItemFactory = factory;
        this.injars = ImmutableList.copyOf(injars);
        this.libraryjars = ImmutableList.copyOf(libraryjars);
        this.packageObfuscationMode = packageObfuscationMode;
        this.packagePrefix = packagePrefix;
        this.allowAccessModification = allowAccessModification;
        this.ignoreWarnings = ignoreWarnings;
        this.optimizing = optimizing;
        this.obfuscating = obfuscating;
        this.shrinking = shrinking;
        this.printConfiguration = printConfiguration;
        this.printConfigurationFile = printConfigurationFile;
        this.printUsage = printUsage;
        this.printUsageFile = printUsageFile;
        this.printMapping = printMapping;
        this.printMappingFile = printMappingFile;
        this.applyMappingFile = applyMappingFile;
        this.verbose = verbose;
        this.renameSourceFileAttribute = renameSourceFileAttribute;
        this.keepAttributes = keepAttributes;
        this.dontWarnPatterns = dontWarnPatterns;
        this.dontNotePatterns = dontNotePatterns;
        this.rules = ImmutableList.copyOf(rules);
        this.printSeeds = printSeeds;
        this.seedFile = seedFile;
        this.overloadAggressively = overloadAggressively;
        this.obfuscationDictionary = obfuscationDictionary;
        this.classObfuscationDictionary = classObfuscationDictionary;
        this.packageObfuscationDictionary = packageObfuscationDictionary;
        this.useUniqueClassMemberNames = useUniqueClassMemberNames;
        this.keepParameterNames = keepParameterNames;
        this.adaptClassStrings = adaptClassStrings;
        this.adaptResourceFilenames = adaptResourceFilenames;
        this.adaptResourceFileContents = adaptResourceFileContents;
        this.keepDirectories = keepDirectories;
    }

    public static Builder builder(DexItemFactory dexItemFactory, Reporter reporter) {
        return new Builder(dexItemFactory, reporter);
    }

    public String getParsedConfiguration() {
        return this.parsedConfiguration;
    }

    public DexItemFactory getDexItemFactory() {
        return this.dexItemFactory;
    }

    public ImmutableList<FilteredClassPath> getInjars() {
        return this.injars;
    }

    public ImmutableList<FilteredClassPath> getLibraryjars() {
        return this.libraryjars;
    }

    public InternalOptions.PackageObfuscationMode getPackageObfuscationMode() {
        return this.packageObfuscationMode;
    }

    public String getPackagePrefix() {
        return this.packagePrefix;
    }

    public boolean isAccessModificationAllowed() {
        return this.allowAccessModification;
    }

    public boolean isPrintMapping() {
        return this.printMapping;
    }

    public Path getPrintMappingFile() {
        return this.printMappingFile;
    }

    public boolean hasApplyMappingFile() {
        return this.applyMappingFile != null;
    }

    public Path getApplyMappingFile() {
        return this.applyMappingFile;
    }

    public boolean isIgnoreWarnings() {
        return this.ignoreWarnings;
    }

    public boolean isOptimizing() {
        return this.optimizing;
    }

    public boolean isObfuscating() {
        return this.obfuscating;
    }

    public boolean isShrinking() {
        return this.shrinking;
    }

    public boolean isPrintConfiguration() {
        return this.printConfiguration;
    }

    public Path getPrintConfigurationFile() {
        return this.printConfigurationFile;
    }

    public boolean isPrintUsage() {
        return this.printUsage;
    }

    public Path getPrintUsageFile() {
        return this.printUsageFile;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public String getRenameSourceFileAttribute() {
        return this.renameSourceFileAttribute;
    }

    public ProguardKeepAttributes getKeepAttributes() {
        return this.keepAttributes;
    }

    public ProguardClassFilter getDontWarnPatterns() {
        return this.dontWarnPatterns;
    }

    public ProguardClassFilter getDontNotePatterns() {
        return this.dontNotePatterns;
    }

    public ImmutableList<ProguardConfigurationRule> getRules() {
        return this.rules;
    }

    public boolean isOverloadAggressivelyWithoutUseUniqueClassMemberNames() {
        return this.overloadAggressively && !this.useUniqueClassMemberNames;
    }

    public ImmutableList<String> getObfuscationDictionary() {
        return this.obfuscationDictionary;
    }

    public ImmutableList<String> getClassObfuscationDictionary() {
        return this.classObfuscationDictionary;
    }

    public ImmutableList<String> getPackageObfuscationDictionary() {
        return this.packageObfuscationDictionary;
    }

    public boolean isUseUniqueClassMemberNames() {
        return this.useUniqueClassMemberNames;
    }

    public boolean isKeepParameterNames() {
        return this.keepParameterNames;
    }

    public ProguardClassFilter getAdaptClassStrings() {
        return this.adaptClassStrings;
    }

    public ProguardPathFilter getAdaptResourceFilenames() {
        return this.adaptResourceFilenames;
    }

    public ProguardPathFilter getAdaptResourceFileContents() {
        return this.adaptResourceFileContents;
    }

    public ProguardPathFilter getKeepDirectories() {
        return this.keepDirectories;
    }

    public static ProguardConfiguration defaultConfiguration(DexItemFactory dexItemFactory, Reporter reporter) {
        return ProguardConfiguration.builder(dexItemFactory, reporter).build();
    }

    public boolean isPrintSeeds() {
        return this.printSeeds;
    }

    public Path getSeedFile() {
        return this.seedFile;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (!this.keepAttributes.isEmpty()) {
            this.keepAttributes.append(builder);
            builder.append('\n');
        }
        for (ProguardConfigurationRule rule : this.rules) {
            rule.append(builder, true);
            builder.append('\n');
        }
        return builder.toString();
    }

    public static class Builder {
        private final List<String> parsedConfiguration = new ArrayList<String>();
        private final List<FilteredClassPath> injars = new ArrayList<FilteredClassPath>();
        private final List<FilteredClassPath> libraryjars = new ArrayList<FilteredClassPath>();
        private final Reporter reporter;
        private InternalOptions.PackageObfuscationMode packageObfuscationMode = InternalOptions.PackageObfuscationMode.NONE;
        private String packagePrefix = "";
        private boolean allowAccessModification;
        private boolean ignoreWarnings;
        private boolean optimizing = true;
        private boolean obfuscating = true;
        private boolean shrinking = true;
        private boolean printConfiguration;
        private Path printConfigurationFile;
        private boolean printUsage;
        private Path printUsageFile;
        private boolean printMapping;
        private Path printMappingFile;
        private Path applyMappingFile;
        private boolean verbose;
        private String renameSourceFileAttribute;
        private final List<String> keepAttributePatterns = new ArrayList<String>();
        private final ProguardClassFilter.Builder dontWarnPatterns = ProguardClassFilter.builder();
        private final ProguardClassFilter.Builder dontNotePatterns = ProguardClassFilter.builder();
        protected final Set<ProguardConfigurationRule> rules = Sets.newLinkedHashSet();
        private final DexItemFactory dexItemFactory;
        private boolean printSeeds;
        private Path seedFile;
        private Path obfuscationDictionary;
        private Path classObfuscationDictionary;
        private Path packageObfuscationDictionary;
        private boolean useUniqueClassMemberNames;
        private boolean keepParameterNames;
        private Origin keepParameterNamesOptionOrigin;
        private Position keepParameterNamesOptionPosition;
        private final ProguardClassFilter.Builder adaptClassStrings = ProguardClassFilter.builder();
        private final ProguardPathFilter.Builder adaptResourceFilenames = ProguardPathFilter.builder().disable();
        private final ProguardPathFilter.Builder adaptResourceFileContents = ProguardPathFilter.builder().disable();
        private final ProguardPathFilter.Builder keepDirectories = ProguardPathFilter.builder().disable();
        private boolean forceProguardCompatibility = false;
        private boolean overloadAggressively;

        private Builder(DexItemFactory dexItemFactory, Reporter reporter) {
            this.dexItemFactory = dexItemFactory;
            this.reporter = reporter;
        }

        public void addParsedConfiguration(String source) {
            this.parsedConfiguration.add(source);
        }

        public void addInjars(List<FilteredClassPath> injars) {
            this.injars.addAll(injars);
        }

        public void addLibraryJars(List<FilteredClassPath> libraryJars) {
            this.libraryjars.addAll(libraryJars);
        }

        public InternalOptions.PackageObfuscationMode getPackageObfuscationMode() {
            return this.packageObfuscationMode;
        }

        public void setPackagePrefix(String packagePrefix) {
            this.packageObfuscationMode = InternalOptions.PackageObfuscationMode.REPACKAGE;
            this.packagePrefix = packagePrefix;
        }

        public void setFlattenPackagePrefix(String packagePrefix) {
            this.packageObfuscationMode = InternalOptions.PackageObfuscationMode.FLATTEN;
            this.packagePrefix = packagePrefix;
        }

        public void setAllowAccessModification(boolean allowAccessModification) {
            this.allowAccessModification = allowAccessModification;
        }

        public void setIgnoreWarnings(boolean ignoreWarnings) {
            this.ignoreWarnings = ignoreWarnings;
        }

        public void disableOptimization() {
            this.optimizing = false;
        }

        public void disableObfuscation() {
            this.obfuscating = false;
        }

        boolean isObfuscating() {
            return this.obfuscating;
        }

        public boolean isOptimizing() {
            return this.optimizing;
        }

        public boolean isShrinking() {
            return this.shrinking;
        }

        public void disableShrinking() {
            this.shrinking = false;
        }

        public void setPrintConfiguration(boolean printConfiguration) {
            this.printConfiguration = printConfiguration;
        }

        public void setPrintConfigurationFile(Path file) {
            assert (this.printConfiguration);
            this.printConfigurationFile = file;
        }

        public void setPrintUsage(boolean printUsage) {
            this.printUsage = printUsage;
        }

        public void setPrintUsageFile(Path printUsageFile) {
            this.printUsageFile = printUsageFile;
        }

        public void setPrintMapping(boolean printMapping) {
            this.printMapping = printMapping;
        }

        public void setPrintMappingFile(Path file) {
            assert (this.printMapping);
            this.printMappingFile = file;
        }

        public void setApplyMappingFile(Path file) {
            this.applyMappingFile = file;
        }

        public void setVerbose(boolean verbose) {
            this.verbose = verbose;
        }

        public void setRenameSourceFileAttribute(String renameSourceFileAttribute) {
            this.renameSourceFileAttribute = renameSourceFileAttribute;
        }

        public void addKeepAttributePatterns(List<String> keepAttributePatterns) {
            this.keepAttributePatterns.addAll(keepAttributePatterns);
        }

        public void addRule(ProguardConfigurationRule rule) {
            this.rules.add(rule);
        }

        public void addDontWarnPattern(ProguardClassNameList pattern) {
            this.dontWarnPatterns.addPattern(pattern);
        }

        public void addDontNotePattern(ProguardClassNameList pattern) {
            this.dontNotePatterns.addPattern(pattern);
        }

        public void setSeedFile(Path seedFile) {
            this.seedFile = seedFile;
        }

        public void setPrintSeeds(boolean printSeeds) {
            this.printSeeds = printSeeds;
        }

        public void setObfuscationDictionary(Path obfuscationDictionary) {
            this.obfuscationDictionary = obfuscationDictionary;
        }

        public void setClassObfuscationDictionary(Path classObfuscationDictionary) {
            this.classObfuscationDictionary = classObfuscationDictionary;
        }

        public void setPackageObfuscationDictionary(Path packageObfuscationDictionary) {
            this.packageObfuscationDictionary = packageObfuscationDictionary;
        }

        public void setUseUniqueClassMemberNames(boolean useUniqueClassMemberNames) {
            this.useUniqueClassMemberNames = useUniqueClassMemberNames;
        }

        boolean isUseUniqueClassMemberNames() {
            return this.useUniqueClassMemberNames;
        }

        boolean isOverloadAggressively() {
            return this.overloadAggressively;
        }

        public void setKeepParameterNames(boolean keepParameterNames, Origin optionOrigin, Position optionPosition) {
            assert (optionOrigin != null || !keepParameterNames);
            this.keepParameterNames = keepParameterNames;
            this.keepParameterNamesOptionOrigin = optionOrigin;
            this.keepParameterNamesOptionPosition = optionPosition;
        }

        boolean isKeepParameterNames() {
            return this.keepParameterNames;
        }

        Origin getKeepParameterNamesOptionOrigin() {
            return this.keepParameterNamesOptionOrigin;
        }

        Position getKeepParameterNamesOptionPosition() {
            return this.keepParameterNamesOptionPosition;
        }

        public void addAdaptClassStringsPattern(ProguardClassNameList pattern) {
            this.adaptClassStrings.addPattern(pattern);
        }

        public void enableAdaptResourceFilenames() {
            this.adaptResourceFilenames.enable();
        }

        public void addAdaptResourceFilenames(ProguardPathList pattern) {
            this.adaptResourceFilenames.addPattern(pattern);
        }

        public void enableAdaptResourceFileContents() {
            this.adaptResourceFileContents.enable();
        }

        public void addAdaptResourceFileContents(ProguardPathList pattern) {
            this.adaptResourceFileContents.addPattern(pattern);
        }

        public void enableKeepDirectories() {
            this.keepDirectories.enable();
        }

        public void addKeepDirectories(ProguardPathList pattern) {
            this.keepDirectories.addPattern(pattern);
        }

        public void setForceProguardCompatibility(boolean forceProguardCompatibility) {
            this.forceProguardCompatibility = forceProguardCompatibility;
        }

        public void setOverloadAggressively(boolean overloadAggressively) {
            this.overloadAggressively = overloadAggressively;
        }

        public ProguardConfiguration buildRaw() {
            ProguardConfiguration configuration = new ProguardConfiguration(String.join((CharSequence)System.lineSeparator(), this.parsedConfiguration), this.dexItemFactory, this.injars, this.libraryjars, this.packageObfuscationMode, this.packagePrefix, this.allowAccessModification, this.ignoreWarnings, this.optimizing, this.obfuscating, this.shrinking, this.printConfiguration, this.printConfigurationFile, this.printUsage, this.printUsageFile, this.printMapping, this.printMappingFile, this.applyMappingFile, this.verbose, this.renameSourceFileAttribute, ProguardKeepAttributes.fromPatterns(this.keepAttributePatterns), this.dontWarnPatterns.build(), this.dontNotePatterns.build(), this.rules, this.printSeeds, this.seedFile, this.overloadAggressively, DictionaryReader.readAllNames(this.obfuscationDictionary, this.reporter), DictionaryReader.readAllNames(this.classObfuscationDictionary, this.reporter), DictionaryReader.readAllNames(this.packageObfuscationDictionary, this.reporter), this.useUniqueClassMemberNames, this.keepParameterNames, this.adaptClassStrings.build(), this.adaptResourceFilenames.build(), this.adaptResourceFileContents.build(), this.keepDirectories.build());
            this.reporter.failIfPendingErrors();
            return configuration;
        }

        public ProguardConfiguration build() {
            boolean rulesWasEmpty = this.rules.isEmpty();
            if (this.rules.isEmpty()) {
                this.disableObfuscation();
                this.disableShrinking();
            }
            if (this.keepAttributePatterns.isEmpty() && rulesWasEmpty || this.forceProguardCompatibility && !this.isObfuscating() || !this.isShrinking()) {
                this.keepAttributePatterns.addAll(ProguardKeepAttributes.KEEP_ALL);
            }
            if (!(this.isShrinking() && this.isObfuscating() && this.isOptimizing())) {
                this.addRule(ProguardKeepRule.defaultKeepAllRule(modifiers -> {
                    modifiers.setAllowsShrinking(this.isShrinking());
                    modifiers.setAllowsOptimization(this.isOptimizing());
                    modifiers.setAllowsObfuscation(this.isObfuscating());
                }));
            }
            return this.buildRaw();
        }
    }
}

