/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.testing;

import com.android.builder.internal.testing.CustomTestRunListener;
import com.android.builder.testing.TestData;
import com.android.builder.testing.api.DeviceConnector;
import com.android.builder.testing.api.DeviceException;
import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.testrunner.IRemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.RemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.ddmlib.testrunner.TestRunResult;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class SimpleTestCallable
implements Callable<Boolean> {
    public static final String FILE_COVERAGE_EC = "coverage.ec";
    private static final String TMP = "/data/local/tmp/";
    private final RemoteAndroidTestRunner runner;
    private final String projectName;
    private final DeviceConnector device;
    private final String flavorName;
    private final TestData testData;
    private final File resultsDir;
    private final File coverageDir;
    private final List<File> testedApks;
    private final Collection<String> installOptions;
    private final ILogger logger;
    private final Set<File> helperApks;
    private final int timeoutInMs;

    public SimpleTestCallable(DeviceConnector device, String projectName, RemoteAndroidTestRunner runner, String flavorName, List<File> testedApks, TestData testData, Set<File> helperApks, File resultsDir, File coverageDir, int timeoutInMs, Collection<String> installOptions, ILogger logger) {
        this.projectName = projectName;
        this.device = device;
        this.runner = runner;
        this.flavorName = flavorName;
        this.helperApks = helperApks;
        this.resultsDir = resultsDir;
        this.coverageDir = coverageDir;
        this.testedApks = testedApks;
        this.testData = testData;
        this.timeoutInMs = timeoutInMs;
        this.installOptions = installOptions;
        this.logger = logger;
    }

    @Override
    public Boolean call() throws Exception {
        String coverageFile;
        String deviceName = this.device.getName();
        boolean isInstalled = false;
        CustomTestRunListener runListener = new CustomTestRunListener(deviceName, this.projectName, this.flavorName, this.logger);
        runListener.setReportDir(this.resultsDir);
        long time = System.currentTimeMillis();
        boolean success = false;
        switch (this.runner.getCoverageOutputType()) {
            case DIR: {
                coverageFile = "/data/data/" + this.testData.getTestedApplicationId() + "/coverage_data/";
                break;
            }
            case FILE: {
                coverageFile = String.format("/data/data/%s/%s", this.testData.getTestedApplicationId(), FILE_COVERAGE_EC);
                break;
            }
            default: {
                throw new AssertionError((Object)"Unknown coverage type.");
            }
        }
        try {
            this.device.connect(this.timeoutInMs, this.logger);
            if (!this.testedApks.isEmpty()) {
                this.logger.verbose("DeviceConnector '%s': installing %s", new Object[]{deviceName, Joiner.on((String)", ").join(this.testedApks)});
                if (this.testedApks.size() > 1 && this.device.getApiLevel() < 21) {
                    throw new InstallException("Internal error, file a bug, multi-apk applications require a device with API level 21+");
                }
                if (this.testedApks.size() > 1) {
                    this.device.installPackages(this.testedApks, this.installOptions, this.timeoutInMs, this.logger);
                } else {
                    this.device.installPackage(this.testedApks.get(0), this.installOptions, this.timeoutInMs, this.logger);
                }
            }
            for (File file : this.helperApks) {
                this.logger.verbose("DeviceConnector '%s': installing helper APK %s", new Object[]{deviceName, file});
                this.device.installPackage(file, this.installOptions, this.timeoutInMs, this.logger);
            }
            this.logger.verbose("DeviceConnector '%s': installing %s", new Object[]{deviceName, this.testData.getTestApk()});
            this.device.installPackage(this.testData.getTestApk(), this.installOptions, this.timeoutInMs, this.logger);
            isInstalled = true;
            for (Map.Entry entry : this.testData.getInstrumentationRunnerArguments().entrySet()) {
                this.runner.addInstrumentationArg((String)entry.getKey(), (String)entry.getValue());
            }
            if (this.testData.isTestCoverageEnabled()) {
                this.runner.addInstrumentationArg("coverage", "true");
                if (this.runner.getCoverageOutputType() == IRemoteAndroidTestRunner.CoverageOutput.DIR) {
                    this.setUpDirectories(coverageFile);
                }
                this.runner.setCoverageReportLocation(coverageFile);
            }
            if (this.testData.getAnimationsDisabled()) {
                this.runner.setRunOptions("--no_window_animation");
            }
            this.runner.setRunName(deviceName);
            this.runner.setMaxtimeToOutputResponse(this.timeoutInMs);
            this.runner.run(new ITestRunListener[]{runListener});
            TestRunResult testRunResult = runListener.getRunResult();
            success = true;
            if (testRunResult.getNumTests() == 0) {
                CustomTestRunListener customTestRunListener = new CustomTestRunListener(deviceName, this.projectName, this.flavorName, this.logger);
                customTestRunListener.setReportDir(this.resultsDir);
                Map<String, String> emptyMetrics = Collections.emptyMap();
                TestIdentifier fakeTest = new TestIdentifier(this.device.getClass().getName(), "No tests found.");
                customTestRunListener.testStarted(fakeTest);
                customTestRunListener.testFailed(fakeTest, "No tests found. This usually means that your test classes are not in the form that your test runner expects (e.g. don't inherit from TestCase or lack @Test annotations).");
                customTestRunListener.testEnded(fakeTest, emptyMetrics);
                customTestRunListener.testRunEnded(System.currentTimeMillis() - time, emptyMetrics);
                Boolean bl = false;
                return bl;
            }
            Boolean bl = !testRunResult.hasFailedTests() && !testRunResult.isRunFailure();
            return bl;
        }
        catch (Exception e) {
            Map<String, String> map2 = Collections.emptyMap();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(baos, true);
            e.printStackTrace(pw);
            TestIdentifier fakeTest = new TestIdentifier(this.device.getClass().getName(), "runTests");
            runListener.testStarted(fakeTest);
            runListener.testFailed(fakeTest, baos.toString());
            runListener.testEnded(fakeTest, map2);
            runListener.testRunEnded(System.currentTimeMillis() - time, map2);
            throw e;
        }
        finally {
            if (isInstalled) {
                if (success && this.testData.isTestCoverageEnabled()) {
                    this.pullCoverageData(deviceName, coverageFile, this.runner.getCoverageOutputType());
                }
                this.uninstall(this.testData.getTestApk(), this.testData.getApplicationId(), deviceName);
                for (File testedApk : this.testedApks) {
                    this.uninstall(testedApk, this.testData.getTestedApplicationId(), deviceName);
                }
            }
            this.device.disconnect(this.timeoutInMs, this.logger);
        }
    }

    private MultiLineReceiver getOutputReceiver() {
        return new MultiLineReceiver(){

            public void processNewLines(String[] lines) {
                for (String line : lines) {
                    SimpleTestCallable.this.logger.verbose(line, new Object[0]);
                }
            }

            public boolean isCancelled() {
                return false;
            }
        };
    }

    private static String cleanUpDir(String path) {
        return String.format("if [ -d %s ]; then rm -r %s; fi && mkdir %s", path, path, path);
    }

    private void setUpDirectories(String userCoverageDir) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        MultiLineReceiver receiver = this.getOutputReceiver();
        String cleanUpTmp = SimpleTestCallable.cleanUpDir(this.getCoverageTmp());
        this.executeShellCommand(cleanUpTmp, receiver);
        String cleanUpUser = SimpleTestCallable.cleanUpDir(userCoverageDir);
        this.execAsScript(cleanUpUser, "tmpScript.sh", true);
    }

    private void execAsScript(String command, String scriptName, boolean withRunAs) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        String scriptPath = this.getCoverageTmp() + "/" + scriptName;
        MultiLineReceiver receiver = this.getOutputReceiver();
        this.executeShellCommand("echo '" + command + "' > " + scriptPath, receiver);
        String finalCommand = "sh " + scriptPath;
        if (withRunAs) {
            finalCommand = this.asTestedApplication(finalCommand);
        }
        this.executeShellCommand(finalCommand, receiver);
    }

    private String asTestedApplication(String ... command) {
        Iterator iterator2 = Arrays.stream(command).map(s -> "run-as " + this.testData.getTestedApplicationId() + " " + s).iterator();
        return Joiner.on((String)" && ").join(iterator2);
    }

    private void pullCoverageData(String deviceName, String coverageFile, IRemoteAndroidTestRunner.CoverageOutput coverageOutput) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        switch (coverageOutput) {
            case DIR: {
                this.pullCoverageFromDir(deviceName, coverageFile);
                break;
            }
            case FILE: {
                this.pullSingleCoverageFile(deviceName, coverageFile);
                break;
            }
            default: {
                throw new AssertionError((Object)"Unknown coverage type.");
            }
        }
    }

    private void pullSingleCoverageFile(String deviceName, String coverageFile) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        String temporaryCoverageCopy = TMP + this.testData.getTestedApplicationId() + "." + FILE_COVERAGE_EC;
        MultiLineReceiver outputReceiver = this.getOutputReceiver();
        this.logger.verbose("DeviceConnector '%s': fetching coverage data from %s", new Object[]{deviceName, coverageFile});
        this.executeShellCommand(this.asTestedApplication(" cat " + coverageFile) + " | cat > " + temporaryCoverageCopy, outputReceiver);
        this.device.pullFile(temporaryCoverageCopy, new File(this.coverageDir, deviceName + "-" + FILE_COVERAGE_EC).getPath());
        this.executeShellCommand("rm " + temporaryCoverageCopy, outputReceiver);
    }

    private void pullCoverageFromDir(String deviceName, String coverageDir) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        String coverageTmp = this.getCoverageTmp();
        MultiLineReceiver outputReceiver = this.getOutputReceiver();
        this.logger.verbose("DeviceConnector '%s': fetching coverage dir from %s", new Object[]{deviceName, coverageDir});
        String listFiles = this.asTestedApplication("ls " + coverageDir);
        String copyScript = String.format("for i in $(%s); do run-as %s cat %s$i > %s/$i; done", listFiles, this.testData.getTestedApplicationId(), coverageDir, coverageTmp);
        this.execAsScript(copyScript, "copyFromUser.sh", false);
        String coveragePaths = coverageTmp + "/paths.txt";
        this.executeShellCommand("ls " + coverageTmp + " > " + coveragePaths, outputReceiver);
        File hostCoverage = new File(this.coverageDir, deviceName);
        FileUtils.cleanOutputDir((File)hostCoverage);
        File hostCoveragePaths = new File(hostCoverage, "coverage_file_paths.txt");
        this.device.pullFile(coveragePaths, hostCoveragePaths.getPath());
        List<String> reportPaths = Files.readAllLines(hostCoveragePaths.toPath());
        for (String reportPath : reportPaths) {
            if (!reportPath.endsWith(".ec")) continue;
            File hostSingleReport = new File(hostCoverage, reportPath);
            this.device.pullFile(coverageTmp + "/" + reportPath, hostSingleReport.getPath());
        }
        FileUtils.delete((File)hostCoveragePaths);
        this.executeShellCommand("rm -r " + coverageTmp, outputReceiver);
    }

    private void executeShellCommand(String command, MultiLineReceiver receiver) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        this.device.executeShellCommand(command, (IShellOutputReceiver)receiver, (long)DdmPreferences.getTimeOut(), TimeUnit.MILLISECONDS);
    }

    private String getCoverageTmp() {
        return TMP + this.testData.getTestedApplicationId() + "-coverage_data";
    }

    private void uninstall(File apkFile, String packageName, String deviceName) throws DeviceException {
        if (packageName != null) {
            this.logger.verbose("DeviceConnector '%s': uninstalling %s", new Object[]{deviceName, packageName});
            this.device.uninstallPackage(packageName, this.timeoutInMs, this.logger);
        } else {
            this.logger.verbose("DeviceConnector '%s': unable to uninstall %s: unable to get package name", new Object[]{deviceName, apkFile});
        }
    }
}

