/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.com.google.common.collect.ImmutableCollection;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Streams;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.ArrayTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.BottomTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.ClassTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.DoubleTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.FloatTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.IntTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.LongTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.NullLatticeElement;
import com.android.tools.r8.ir.analysis.type.PrimitiveTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.ReferenceTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.SingleTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.TopTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.WideTypeLatticeElement;
import com.android.tools.r8.ir.code.MemberType;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.stream.Stream;

public abstract class TypeLatticeElement {
    public static final BottomTypeLatticeElement BOTTOM = BottomTypeLatticeElement.getInstance();
    public static final TopTypeLatticeElement TOP = TopTypeLatticeElement.getInstance();
    public static final IntTypeLatticeElement INT = IntTypeLatticeElement.getInstance();
    public static final FloatTypeLatticeElement FLOAT = FloatTypeLatticeElement.getInstance();
    public static final SingleTypeLatticeElement SINGLE = SingleTypeLatticeElement.getInstance();
    public static final LongTypeLatticeElement LONG = LongTypeLatticeElement.getInstance();
    public static final DoubleTypeLatticeElement DOUBLE = DoubleTypeLatticeElement.getInstance();
    public static final WideTypeLatticeElement WIDE = WideTypeLatticeElement.getInstance();
    public static final ReferenceTypeLatticeElement NULL = ReferenceTypeLatticeElement.getNullTypeLatticeElement();
    public static final ReferenceTypeLatticeElement REFERENCE = ReferenceTypeLatticeElement.getReferenceTypeLatticeElement();
    private final boolean isNullable;

    TypeLatticeElement(boolean isNullable) {
        this.isNullable = isNullable;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public NullLatticeElement nullElement() {
        if (this.isNull()) {
            return NullLatticeElement.definitelyNull();
        }
        if (!this.isNullable()) {
            return NullLatticeElement.definitelyNotNull();
        }
        return NullLatticeElement.maybeNull();
    }

    public abstract TypeLatticeElement asNullable();

    public TypeLatticeElement asNonNullable() {
        return BOTTOM;
    }

    String isNullableString() {
        return this.isNullable() ? "" : "@NonNull ";
    }

    public TypeLatticeElement join(TypeLatticeElement other, AppInfo appInfo) {
        boolean isNullable;
        if (this.isBottom()) {
            return other;
        }
        if (other.isBottom()) {
            return this;
        }
        if (this.isTop() || other.isTop()) {
            return TOP;
        }
        if (this.isNull()) {
            return other.asNullable();
        }
        if (other.isNull()) {
            return this.asNullable();
        }
        if (this.isPrimitive()) {
            return other.isPrimitive() ? PrimitiveTypeLatticeElement.join(this.asPrimitiveTypeLatticeElement(), other.asPrimitiveTypeLatticeElement()) : TOP;
        }
        if (other.isPrimitive()) {
            return TOP;
        }
        assert (this.isReference() && other.isReference());
        if (!this.isPreciseType() || !other.isPreciseType()) {
            if (this.isReferenceInstance()) {
                return this;
            }
            assert (other.isReferenceInstance());
            return other;
        }
        boolean bl = isNullable = this.isNullable() || other.isNullable();
        if (this.getClass() != other.getClass()) {
            return TypeLatticeElement.objectClassType(appInfo, isNullable);
        }
        if (this.isArrayType()) {
            assert (other.isArrayType());
            ArrayTypeLatticeElement a1 = this.asArrayTypeLatticeElement();
            ArrayTypeLatticeElement a2 = other.asArrayTypeLatticeElement();
            if (a1.getArrayType() == a2.getArrayType()) {
                return a1.isNullable() ? a1 : a2;
            }
            DexType a1BaseReferenceType = a1.getArrayBaseType(appInfo.dexItemFactory);
            int a1Nesting = a1.getNesting();
            if (a1BaseReferenceType.isPrimitiveType()) {
                --a1Nesting;
                a1BaseReferenceType = appInfo.dexItemFactory.objectType;
            }
            DexType a2BaseReferenceType = a2.getArrayBaseType(appInfo.dexItemFactory);
            int a2Nesting = a2.getNesting();
            if (a2BaseReferenceType.isPrimitiveType()) {
                --a2Nesting;
                a2BaseReferenceType = appInfo.dexItemFactory.objectType;
            }
            assert (a1BaseReferenceType.isClassType() && a2BaseReferenceType.isClassType());
            if (a1Nesting == 0 || a2Nesting == 0) {
                return TypeLatticeElement.objectClassType(appInfo, isNullable);
            }
            if (a1Nesting != a2Nesting) {
                int min = Math.min(a1Nesting, a2Nesting);
                return TypeLatticeElement.objectArrayType(appInfo, min, isNullable);
            }
            DexType lub = a1BaseReferenceType.computeLeastUpperBoundOfClasses(appInfo, a2BaseReferenceType);
            DexType arrayTypeLub = appInfo.dexItemFactory.createArrayType(a1Nesting, lub);
            return new ArrayTypeLatticeElement(arrayTypeLub, isNullable);
        }
        if (this.isClassType()) {
            assert (other.isClassType());
            ClassTypeLatticeElement c1 = this.asClassTypeLatticeElement();
            ClassTypeLatticeElement c2 = other.asClassTypeLatticeElement();
            DexType lubType = c1.getClassType().computeLeastUpperBoundOfClasses(appInfo, c2.getClassType());
            return new ClassTypeLatticeElement(lubType, isNullable, TypeLatticeElement.computeLeastUpperBoundOfInterfaces(appInfo, c1.getInterfaces(), c2.getInterfaces()));
        }
        throw new Unreachable("unless a new type lattice is introduced.");
    }

    static Set<DexType> computeLeastUpperBoundOfInterfaces(AppInfo appInfo, Set<DexType> s1, Set<DexType> s2) {
        IdentityHashMap<DexType, Set> seen = new IdentityHashMap<DexType, Set>();
        ArrayDeque<InterfaceWithMarker> worklist = new ArrayDeque<InterfaceWithMarker>();
        for (DexType itf1 : s1) {
            worklist.add(new InterfaceWithMarker(itf1, InterfaceMarker.LEFT));
        }
        for (DexType itf2 : s2) {
            worklist.add(new InterfaceWithMarker(itf2, InterfaceMarker.RIGHT));
        }
        while (!worklist.isEmpty()) {
            InterfaceWithMarker item = (InterfaceWithMarker)worklist.poll();
            DexType itf = item.itf;
            InterfaceMarker interfaceMarker = item.marker;
            Set markers = seen.computeIfAbsent(itf, k -> new HashSet());
            if (markers.contains((Object)interfaceMarker)) continue;
            if (markers.size() == 1) {
                markers.add(interfaceMarker);
                continue;
            }
            markers.add(interfaceMarker);
            DexClass itfClass = appInfo.definitionFor(itf);
            if (itfClass == null) continue;
            for (DexType superItf : itfClass.interfaces.values) {
                markers = seen.computeIfAbsent(superItf, k -> new HashSet());
                if (markers.contains((Object)interfaceMarker)) continue;
                worklist.add(new InterfaceWithMarker(superItf, interfaceMarker));
            }
        }
        ImmutableSet.Builder commonBuilder = ImmutableSet.builder();
        for (Map.Entry entry : seen.entrySet()) {
            if (((Set)entry.getValue()).size() < 2) continue;
            commonBuilder.add((DexType)entry.getKey());
        }
        ImmutableCollection commonlyVisited = commonBuilder.build();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (DexType itf : commonlyVisited) {
            if (commonlyVisited.stream().anyMatch(other -> other.isStrictSubtypeOf(itf, appInfo))) continue;
            builder.add(itf);
        }
        return builder.build();
    }

    private static Set<DexType> computeLeastUpperBoundOfInterfaces(AppInfo appInfo, Set<DexType> interfaces) {
        return TypeLatticeElement.computeLeastUpperBoundOfInterfaces(appInfo, interfaces, interfaces);
    }

    public static BinaryOperator<TypeLatticeElement> joiner(AppInfo appInfo) {
        return (l1, l2) -> l1.join((TypeLatticeElement)l2, appInfo);
    }

    public static TypeLatticeElement join(Stream<TypeLatticeElement> types, AppInfo appInfo) {
        BinaryOperator<TypeLatticeElement> joiner = TypeLatticeElement.joiner(appInfo);
        return types.reduce(BottomTypeLatticeElement.getInstance(), joiner, joiner);
    }

    public static TypeLatticeElement joinTypes(Iterable<DexType> types, boolean isNullable, AppInfo appInfo) {
        return TypeLatticeElement.join(Streams.stream(types).map(t -> TypeLatticeElement.fromDexType(t, isNullable, appInfo)), appInfo);
    }

    public boolean strictlyLessThan(TypeLatticeElement other, AppInfo appInfo) {
        if (this.equals(other)) {
            return false;
        }
        TypeLatticeElement lub = this.join(other, appInfo);
        return !this.equals(lub) && other.equals(lub);
    }

    public boolean lessThanOrEqual(TypeLatticeElement other, AppInfo appInfo) {
        return this.equals(other) || this.strictlyLessThan(other, appInfo);
    }

    public boolean isTop() {
        return false;
    }

    public boolean isBottom() {
        return false;
    }

    public boolean isReference() {
        return false;
    }

    public boolean isArrayType() {
        return false;
    }

    public ArrayTypeLatticeElement asArrayTypeLatticeElement() {
        return null;
    }

    public boolean isClassType() {
        return false;
    }

    public ClassTypeLatticeElement asClassTypeLatticeElement() {
        return null;
    }

    public boolean isPrimitive() {
        return false;
    }

    public PrimitiveTypeLatticeElement asPrimitiveTypeLatticeElement() {
        return null;
    }

    public boolean isSingle() {
        return false;
    }

    public boolean isWide() {
        return false;
    }

    public boolean isInt() {
        return false;
    }

    public boolean isFloat() {
        return false;
    }

    public boolean isLong() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean isPreciseType() {
        return this.isArrayType() || this.isClassType() || this.isInt() || this.isFloat() || this.isLong() || this.isDouble();
    }

    public boolean isNull() {
        return false;
    }

    public boolean isReferenceInstance() {
        return false;
    }

    public int requiredRegisters() {
        assert (!this.isBottom() && !this.isTop());
        return this.isWide() ? 2 : 1;
    }

    public static ClassTypeLatticeElement objectClassType(AppInfo appInfo, boolean isNullable) {
        return new ClassTypeLatticeElement(appInfo.dexItemFactory.objectType, isNullable);
    }

    static ArrayTypeLatticeElement objectArrayType(AppInfo appInfo, int nesting, boolean isNullable) {
        return new ArrayTypeLatticeElement(appInfo.dexItemFactory.createArrayType(nesting, appInfo.dexItemFactory.objectType), isNullable);
    }

    public static TypeLatticeElement classClassType(AppInfo appInfo) {
        return TypeLatticeElement.fromDexType(appInfo.dexItemFactory.classType, false, appInfo);
    }

    public static TypeLatticeElement stringClassType(AppInfo appInfo) {
        return TypeLatticeElement.fromDexType(appInfo.dexItemFactory.stringType, false, appInfo);
    }

    public static TypeLatticeElement fromDexType(DexType type, boolean isNullable, AppInfo appInfo) {
        if (type == DexItemFactory.nullValueType) {
            return NULL;
        }
        if (type.isPrimitiveType()) {
            return PrimitiveTypeLatticeElement.fromDexType(type);
        }
        if (type.isClassType()) {
            if (!type.isUnknown() && type.isInterface()) {
                return new ClassTypeLatticeElement(appInfo.dexItemFactory.objectType, isNullable, ImmutableSet.of(type));
            }
            return new ClassTypeLatticeElement(type, isNullable, TypeLatticeElement.computeLeastUpperBoundOfInterfaces(appInfo, type.implementedInterfaces(appInfo)));
        }
        assert (type.isArrayType());
        return new ArrayTypeLatticeElement(type, isNullable);
    }

    public static TypeLatticeElement fromDexType(DexType type) {
        if (type == DexItemFactory.nullValueType) {
            return NULL;
        }
        return TypeLatticeElement.fromTypeDescriptorChar((char)type.descriptor.content[0]);
    }

    public static TypeLatticeElement fromTypeDescriptorChar(char descriptor) {
        switch (descriptor) {
            case 'L': 
            case '[': {
                return REFERENCE;
            }
        }
        return PrimitiveTypeLatticeElement.fromTypeDescriptorChar(descriptor);
    }

    public static TypeLatticeElement fromMemberType(MemberType type) {
        switch (type) {
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: {
                return INT;
            }
            case FLOAT: {
                return FLOAT;
            }
            case INT_OR_FLOAT: {
                return SINGLE;
            }
            case LONG: {
                return LONG;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case LONG_OR_DOUBLE: {
                return WIDE;
            }
            case OBJECT: {
                return REFERENCE;
            }
        }
        throw new Unreachable("Unexpected member type: " + (Object)((Object)type));
    }

    public static TypeLatticeElement newArray(DexType arrayType, boolean isNullable) {
        return new ArrayTypeLatticeElement(arrayType, isNullable);
    }

    public TypeLatticeElement arrayGet(AppInfo appInfo) {
        return BOTTOM;
    }

    public TypeLatticeElement checkCast(AppInfo appInfo, DexType castType) {
        TypeLatticeElement castTypeLattice = TypeLatticeElement.fromDexType(castType, this.isNullable(), appInfo);
        if (this.lessThanOrEqual(castTypeLattice, appInfo)) {
            return this;
        }
        return castTypeLattice;
    }

    public abstract String toString();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        TypeLatticeElement otherElement = (TypeLatticeElement)o;
        return otherElement.isNullable() == this.isNullable;
    }

    public int hashCode() {
        return this.isNullable ? 1 : -1;
    }

    private static class InterfaceWithMarker {
        final DexType itf;
        final InterfaceMarker marker;

        InterfaceWithMarker(DexType itf, InterfaceMarker marker) {
            this.itf = itf;
            this.marker = marker;
        }
    }

    private static enum InterfaceMarker {
        LEFT,
        RIGHT;

    }
}

