/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf;

import com.android.tools.r8.cf.FixedLocalValue;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.StackValue;
import com.android.tools.r8.ir.code.StackValues;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.regalloc.LinearScanRegisterAllocator;
import com.android.tools.r8.ir.regalloc.LiveIntervals;
import com.android.tools.r8.ir.regalloc.RegisterAllocator;
import com.android.tools.r8.utils.InternalOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.PriorityQueue;
import java.util.SortedSet;
import java.util.TreeSet;

public class CfRegisterAllocator
implements RegisterAllocator {
    private final IRCode code;
    private final InternalOptions options;
    private Map<BasicBlock, IRCode.LiveAtEntrySets> liveAtEntrySets;
    private final List<LiveIntervals> liveIntervals = new ArrayList<LiveIntervals>();
    private final List<LiveIntervals> active = new LinkedList<LiveIntervals>();
    private final List<LiveIntervals> inactive = new LinkedList<LiveIntervals>();
    private final PriorityQueue<LiveIntervals> unhandled = new PriorityQueue();
    private NavigableSet<Integer> freeRegisters = new TreeSet<Integer>();
    private int nextUnusedRegisterNumber = 0;
    private int maxRegisterNumber = 0;

    public CfRegisterAllocator(IRCode code, InternalOptions options) {
        this.code = code;
        this.options = options;
    }

    @Override
    public int registersUsed() {
        return this.maxRegisterNumber + 1;
    }

    @Override
    public int getRegisterForValue(Value value, int instructionNumber) {
        return this.getRegisterForValue(value);
    }

    public int getRegisterForValue(Value value) {
        if (value instanceof FixedLocalValue) {
            return ((FixedLocalValue)value).getRegister(this);
        }
        assert (!value.getLiveIntervals().hasSplits());
        return value.getLiveIntervals().getRegister();
    }

    @Override
    public int getArgumentOrAllocateRegisterForValue(Value value, int instructionNumber) {
        return this.getRegisterForValue(value);
    }

    @Override
    public InternalOptions getOptions() {
        return this.options;
    }

    @Override
    public void allocateRegisters(boolean debug) {
        assert (this.options.debug == debug);
        this.allocateRegisters();
    }

    public void allocateRegisters() {
        this.computeNeedsRegister();
        ImmutableList<BasicBlock> blocks = this.computeLivenessInformation();
        this.performLinearScan();
        if (this.options.debug) {
            LinearScanRegisterAllocator.computeDebugInfo(blocks, this.liveIntervals, this, this.liveAtEntrySets);
        }
    }

    private void computeNeedsRegister() {
        InstructionIterator it = this.code.instructionIterator();
        while (it.hasNext()) {
            Instruction next = (Instruction)it.next();
            Value outValue = next.outValue();
            if (outValue == null) continue;
            boolean isStackValue = outValue instanceof StackValue || outValue instanceof StackValues;
            outValue.setNeedsRegister(!isStackValue);
        }
    }

    private ImmutableList<BasicBlock> computeLivenessInformation() {
        ImmutableList<BasicBlock> blocks = this.code.numberInstructions();
        this.liveAtEntrySets = this.code.computeLiveAtEntrySets();
        LinearScanRegisterAllocator.computeLiveRanges(this.options, this.code, this.liveAtEntrySets, this.liveIntervals);
        return blocks;
    }

    private void performLinearScan() {
        this.unhandled.addAll(this.liveIntervals);
        while (!this.unhandled.isEmpty() && this.unhandled.peek().getValue().isArgument()) {
            LiveIntervals argument = this.unhandled.poll();
            this.assignRegisterToUnhandledInterval(argument, this.getNextFreeRegister(argument.getType().isWide()));
        }
        while (!this.unhandled.isEmpty()) {
            int register;
            LiveIntervals unhandledInterval = this.unhandled.poll();
            assert (!unhandledInterval.getValue().isArgument());
            int start = unhandledInterval.getStart();
            Iterator<LiveIntervals> it = this.active.iterator();
            while (it.hasNext()) {
                LiveIntervals activeIntervals = it.next();
                if (start >= activeIntervals.getEnd()) {
                    it.remove();
                    this.freeRegistersForIntervals(activeIntervals);
                    continue;
                }
                if (activeIntervals.overlapsPosition(start)) continue;
                assert (activeIntervals.getRegister() != Integer.MIN_VALUE);
                it.remove();
                this.inactive.add(activeIntervals);
                this.freeRegistersForIntervals(activeIntervals);
            }
            it = this.inactive.iterator();
            while (it.hasNext()) {
                LiveIntervals inactiveIntervals = it.next();
                if (start >= inactiveIntervals.getEnd()) {
                    it.remove();
                    continue;
                }
                if (!inactiveIntervals.overlapsPosition(start)) continue;
                it.remove();
                assert (inactiveIntervals.getRegister() != Integer.MIN_VALUE);
                this.active.add(inactiveIntervals);
                this.takeRegistersForIntervals(inactiveIntervals);
            }
            boolean wide = unhandledInterval.getType().isWide();
            TreeSet<Integer> previousFreeRegisters = new TreeSet<Integer>((SortedSet<Integer>)this.freeRegisters);
            while (true) {
                register = this.getNextFreeRegister(wide);
                boolean overlapsInactiveInterval = false;
                for (LiveIntervals inactiveIntervals : this.inactive) {
                    if (!unhandledInterval.hasConflictingRegisters(inactiveIntervals) || !unhandledInterval.overlaps(inactiveIntervals)) continue;
                    overlapsInactiveInterval = true;
                    break;
                }
                if (!overlapsInactiveInterval) break;
                this.freeRegisters.remove(register);
            }
            this.freeRegisters = previousFreeRegisters;
            this.assignRegisterToUnhandledInterval(unhandledInterval, register);
        }
    }

    private int getNextFreeRegister(boolean isWide) {
        if (!this.freeRegisters.isEmpty()) {
            if (isWide) {
                for (Integer register : this.freeRegisters) {
                    if (!this.freeRegisters.contains(register + 1) && this.nextUnusedRegisterNumber != register + 1) continue;
                    return register;
                }
                return this.nextUnusedRegisterNumber;
            }
            return (Integer)this.freeRegisters.first();
        }
        return this.nextUnusedRegisterNumber;
    }

    private void freeRegistersForIntervals(LiveIntervals intervals) {
        int register = intervals.getRegister();
        this.freeRegisters.add(register);
        if (intervals.getType().isWide()) {
            this.freeRegisters.add(register + 1);
        }
    }

    private void takeRegistersForIntervals(LiveIntervals intervals) {
        int register = intervals.getRegister();
        this.freeRegisters.remove(register);
        if (intervals.getType().isWide()) {
            this.freeRegisters.remove(register + 1);
        }
    }

    private void assignRegisterToUnhandledInterval(LiveIntervals unhandledInterval, int register) {
        this.assignRegister(unhandledInterval, register);
        this.takeRegistersForIntervals(unhandledInterval);
        this.updateRegisterState(register, unhandledInterval.getType().isWide());
        this.active.add(unhandledInterval);
    }

    private void updateRegisterState(int register, boolean needsRegisterPair) {
        int maxRegister = register + (needsRegisterPair ? 1 : 0);
        if (maxRegister >= this.nextUnusedRegisterNumber) {
            this.nextUnusedRegisterNumber = maxRegister + 1;
        }
        this.maxRegisterNumber = Math.max(this.maxRegisterNumber, maxRegister);
    }

    private void assignRegister(LiveIntervals intervals, int register) {
        intervals.setRegister(register);
    }

    public void addToLiveAtEntrySet(BasicBlock block, Collection<Phi> phis) {
        this.liveAtEntrySets.get((Object)block).liveValues.addAll(phis);
    }

    public Collection<Value> getLocalsAtBlockEntry(BasicBlock block) {
        return this.liveAtEntrySets.get((Object)block).liveValues;
    }
}

