/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.code;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.ValueType;

public enum MoveType {
    SINGLE,
    WIDE,
    OBJECT;


    public static MoveType fromValueType(ValueType type) {
        switch (type) {
            case OBJECT: {
                return OBJECT;
            }
            case INT: 
            case FLOAT: 
            case INT_OR_FLOAT: 
            case INT_OR_FLOAT_OR_NULL: {
                return SINGLE;
            }
            case LONG: 
            case DOUBLE: 
            case LONG_OR_DOUBLE: {
                return WIDE;
            }
        }
        throw new Unreachable("Unexpected value type: " + (Object)((Object)type));
    }

    public TypeLatticeElement toTypeLattice() {
        switch (this) {
            case SINGLE: {
                return TypeLatticeElement.SINGLE;
            }
            case WIDE: {
                return TypeLatticeElement.WIDE;
            }
            case OBJECT: {
                return TypeLatticeElement.REFERENCE;
            }
        }
        throw new Unreachable("Unexpected move type: " + (Object)((Object)this));
    }

    public int requiredRegisters() {
        return this == WIDE ? 2 : 1;
    }
}

