/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.CheckCast;
import com.android.tools.r8.ir.code.ConstClass;
import com.android.tools.r8.ir.code.ConstMethodHandle;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.InstanceGet;
import com.android.tools.r8.ir.code.InstanceOf;
import com.android.tools.r8.ir.code.InstancePut;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeCustom;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeMultiNewArray;
import com.android.tools.r8.ir.code.InvokeNewArray;
import com.android.tools.r8.ir.code.NewArrayEmpty;
import com.android.tools.r8.ir.code.NewInstance;
import com.android.tools.r8.ir.code.StaticGet;
import com.android.tools.r8.ir.code.StaticPut;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.shaking.VerticalClassMerger;
import com.android.tools.r8.utils.InternalOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class LensCodeRewriter {
    private final AppInfoWithSubtyping appInfo;
    private final GraphLense graphLense;
    private final VerticalClassMerger.VerticallyMergedClasses verticallyMergedClasses;
    private final InternalOptions options;
    private final Map<DexProto, DexProto> protoFixupCache = new ConcurrentHashMap<DexProto, DexProto>();

    public LensCodeRewriter(AppView<? extends AppInfoWithSubtyping> appView, InternalOptions options) {
        this.appInfo = appView.appInfo();
        this.graphLense = appView.graphLense();
        this.verticallyMergedClasses = appView.verticallyMergedClasses();
        this.options = options;
    }

    private Value makeOutValue(Instruction insn, IRCode code, Set<Value> collector) {
        if (insn.outValue() == null) {
            return null;
        }
        Value newValue = code.createValue(insn.outValue().getTypeLattice(), insn.getLocalInfo());
        collector.add(newValue);
        return newValue;
    }

    public void rewrite(IRCode code, DexEncodedMethod method) {
        Set<Value> newSSAValues = Sets.newIdentityHashSet();
        ListIterator<BasicBlock> blocks = code.blocks.listIterator();
        while (blocks.hasNext()) {
            BasicBlock block = (BasicBlock)blocks.next();
            InstructionListIterator iterator2 = block.listIterator();
            while (iterator2.hasNext()) {
                Instruction newNewArray;
                DexType newType;
                DexField actualField;
                DexField field;
                Instruction current = (Instruction)iterator2.next();
                if (current.isInvokeCustom()) {
                    InvokeCustom invokeCustom = current.asInvokeCustom();
                    DexCallSite callSite = invokeCustom.getCallSite();
                    DexProto newMethodProto = this.appInfo.dexItemFactory.applyClassMappingToProto(callSite.methodProto, this.graphLense::lookupType, this.protoFixupCache);
                    DexMethodHandle newBootstrapMethod = this.rewriteDexMethodHandle(callSite.bootstrapMethod, method, UseRegistry.MethodHandleUse.NOT_ARGUMENT_TO_LAMBDA_METAFACTORY);
                    boolean isLambdaMetaFactory = this.appInfo.dexItemFactory.isLambdaMetafactoryMethod(callSite.bootstrapMethod.asMethod());
                    UseRegistry.MethodHandleUse methodHandleUse = isLambdaMetaFactory ? UseRegistry.MethodHandleUse.ARGUMENT_TO_LAMBDA_METAFACTORY : UseRegistry.MethodHandleUse.NOT_ARGUMENT_TO_LAMBDA_METAFACTORY;
                    List<DexValue> newArgs = this.rewriteBootstrapArgs(callSite.bootstrapArgs, method, methodHandleUse);
                    if (newMethodProto.equals(callSite.methodProto) && newBootstrapMethod == callSite.bootstrapMethod && newArgs.equals(callSite.bootstrapArgs)) continue;
                    DexCallSite newCallSite = this.appInfo.dexItemFactory.createCallSite(callSite.methodName, newMethodProto, newBootstrapMethod, newArgs);
                    InvokeCustom newInvokeCustom = new InvokeCustom(newCallSite, invokeCustom.outValue(), invokeCustom.inValues());
                    iterator2.replaceCurrentInstruction(newInvokeCustom);
                    continue;
                }
                if (current.isConstMethodHandle()) {
                    DexMethodHandle handle = current.asConstMethodHandle().getValue();
                    DexMethodHandle newHandle = this.rewriteDexMethodHandle(handle, method, UseRegistry.MethodHandleUse.NOT_ARGUMENT_TO_LAMBDA_METAFACTORY);
                    if (newHandle == handle) continue;
                    ConstMethodHandle newInstruction = new ConstMethodHandle(this.makeOutValue(current, code, newSSAValues), newHandle);
                    iterator2.replaceCurrentInstruction(newInstruction);
                    continue;
                }
                if (current.isInvokeMethod()) {
                    InvokeMethod invoke = current.asInvokeMethod();
                    DexMethod invokedMethod = invoke.getInvokedMethod();
                    DexType invokedHolder = invokedMethod.getHolder();
                    if (!invokedHolder.isClassType()) continue;
                    if (invoke.isInvokeDirect()) {
                        this.checkInvokeDirect(method.method, invoke.asInvokeDirect());
                    }
                    GraphLense.GraphLenseLookupResult lenseLookup = this.graphLense.lookupMethod(invokedMethod, method, invoke.getType());
                    DexMethod actualTarget = lenseLookup.getMethod();
                    Invoke.Type invokeType = lenseLookup.getType();
                    if (actualTarget == invokedMethod && invoke.getType() == invokeType) continue;
                    Invoke newInvoke = Invoke.create(invokeType, actualTarget, null, invoke.outValue(), invoke.inValues());
                    iterator2.replaceCurrentInstruction(newInvoke);
                    if (actualTarget.proto.returnType == invokedMethod.proto.returnType || newInvoke.outValue() == null) continue;
                    Value newValue = this.makeOutValue(newInvoke, code, newSSAValues);
                    newInvoke.outValue().replaceUsers(newValue);
                    CheckCast cast = new CheckCast(newValue, newInvoke.outValue(), this.graphLense.lookupType(invokedMethod.proto.returnType));
                    cast.setPosition(current.getPosition());
                    iterator2.add(cast);
                    if (!newInvoke.getBlock().hasCatchHandlers()) continue;
                    iterator2.previous();
                    iterator2.split(code, 1, blocks);
                    continue;
                }
                if (current.isInstanceGet()) {
                    InstanceGet instanceGet = current.asInstanceGet();
                    field = instanceGet.getField();
                    actualField = this.graphLense.lookupField(field);
                    if (actualField == field) continue;
                    InstanceGet newInstanceGet = new InstanceGet(instanceGet.getType(), instanceGet.dest(), instanceGet.object(), actualField);
                    iterator2.replaceCurrentInstruction(newInstanceGet);
                    continue;
                }
                if (current.isInstancePut()) {
                    InstancePut instancePut = current.asInstancePut();
                    field = instancePut.getField();
                    actualField = this.graphLense.lookupField(field);
                    if (actualField == field) continue;
                    InstancePut newInstancePut = new InstancePut(instancePut.getType(), actualField, instancePut.object(), instancePut.value());
                    iterator2.replaceCurrentInstruction(newInstancePut);
                    continue;
                }
                if (current.isStaticGet()) {
                    StaticGet staticGet = current.asStaticGet();
                    field = staticGet.getField();
                    actualField = this.graphLense.lookupField(field);
                    if (actualField == field) continue;
                    StaticGet newStaticGet = new StaticGet(staticGet.getType(), staticGet.dest(), actualField);
                    iterator2.replaceCurrentInstruction(newStaticGet);
                    continue;
                }
                if (current.isStaticPut()) {
                    StaticPut staticPut = current.asStaticPut();
                    field = staticPut.getField();
                    actualField = this.graphLense.lookupField(field);
                    if (actualField == field) continue;
                    StaticPut newStaticPut = new StaticPut(staticPut.getType(), staticPut.inValue(), actualField);
                    iterator2.replaceCurrentInstruction(newStaticPut);
                    continue;
                }
                if (current.isCheckCast()) {
                    CheckCast checkCast = current.asCheckCast();
                    newType = this.graphLense.lookupType(checkCast.getType());
                    if (newType == checkCast.getType()) continue;
                    CheckCast newCheckCast = new CheckCast(this.makeOutValue(checkCast, code, newSSAValues), checkCast.object(), newType);
                    iterator2.replaceCurrentInstruction(newCheckCast);
                    continue;
                }
                if (current.isConstClass()) {
                    ConstClass constClass = current.asConstClass();
                    newType = this.graphLense.lookupType(constClass.getValue());
                    if (newType == constClass.getValue()) continue;
                    ConstClass newConstClass = new ConstClass(this.makeOutValue(constClass, code, newSSAValues), newType);
                    iterator2.replaceCurrentInstruction(newConstClass);
                    continue;
                }
                if (current.isInstanceOf()) {
                    InstanceOf instanceOf = current.asInstanceOf();
                    newType = this.graphLense.lookupType(instanceOf.type());
                    if (newType == instanceOf.type()) continue;
                    InstanceOf newInstanceOf = new InstanceOf(this.makeOutValue(instanceOf, code, newSSAValues), instanceOf.value(), newType);
                    iterator2.replaceCurrentInstruction(newInstanceOf);
                    continue;
                }
                if (current.isInvokeMultiNewArray()) {
                    InvokeMultiNewArray multiNewArray = current.asInvokeMultiNewArray();
                    newType = this.graphLense.lookupType(multiNewArray.getArrayType());
                    if (newType == multiNewArray.getArrayType()) continue;
                    InvokeMultiNewArray newMultiNewArray = new InvokeMultiNewArray(newType, this.makeOutValue(multiNewArray, code, newSSAValues), multiNewArray.inValues());
                    iterator2.replaceCurrentInstruction(newMultiNewArray);
                    continue;
                }
                if (current.isInvokeNewArray()) {
                    InvokeNewArray newArray = current.asInvokeNewArray();
                    newType = this.graphLense.lookupType(newArray.getArrayType());
                    if (newType == newArray.getArrayType()) continue;
                    newNewArray = new InvokeNewArray(newType, this.makeOutValue(newArray, code, newSSAValues), newArray.inValues());
                    iterator2.replaceCurrentInstruction(newNewArray);
                    continue;
                }
                if (current.isNewArrayEmpty()) {
                    NewArrayEmpty newArrayEmpty = current.asNewArrayEmpty();
                    newType = this.graphLense.lookupType(newArrayEmpty.type);
                    if (newType == newArrayEmpty.type) continue;
                    newNewArray = new NewArrayEmpty(this.makeOutValue(newArrayEmpty, code, newSSAValues), newArrayEmpty.size(), newType);
                    iterator2.replaceCurrentInstruction(newNewArray);
                    continue;
                }
                if (!current.isNewInstance()) continue;
                NewInstance newInstance = current.asNewInstance();
                DexType newClazz = this.graphLense.lookupType(newInstance.clazz);
                if (newClazz == newInstance.clazz) continue;
                NewInstance newNewInstance = new NewInstance(newClazz, this.makeOutValue(newInstance, code, newSSAValues));
                iterator2.replaceCurrentInstruction(newNewInstance);
            }
        }
        if (!newSSAValues.isEmpty()) {
            new TypeAnalysis(this.appInfo, method).widening(newSSAValues);
        }
        assert (code.isConsistentSSA());
    }

    private void checkInvokeDirect(DexMethod method, InvokeDirect invoke) {
        if (this.verticallyMergedClasses == null) {
            return;
        }
        DexMethod invokedMethod = invoke.getInvokedMethod();
        if (invokedMethod.name != this.appInfo.dexItemFactory.constructorMethodName) {
            return;
        }
        if (invoke.arguments().isEmpty()) {
            return;
        }
        Value receiver = invoke.arguments().get(0);
        if (!receiver.isPhi() && receiver.definition.isNewInstance()) {
            NewInstance newInstance = receiver.definition.asNewInstance();
            if (newInstance.clazz != invokedMethod.holder && this.verticallyMergedClasses.hasBeenMergedIntoSubtype(invokedMethod.holder)) {
                throw this.options.reporter.fatalError(String.format("Unable to rewrite `invoke-direct %s.<init>(new %s, ...)` in method `%s` after type `%s` was merged into `%s`. Please add the following rule to your Proguard configuration file: `-keep,allowobfuscation class %s`.", invokedMethod.holder.toSourceString(), newInstance.clazz, method.toSourceString(), invokedMethod.holder, this.verticallyMergedClasses.getTargetFor(invokedMethod.holder), invokedMethod.holder.toSourceString()));
            }
        }
    }

    private List<DexValue> rewriteBootstrapArgs(List<DexValue> bootstrapArgs, DexEncodedMethod method, UseRegistry.MethodHandleUse use2) {
        List<DexValue> newBoostrapArgs = null;
        boolean changed = false;
        for (int i = 0; i < bootstrapArgs.size(); ++i) {
            DexType oldType;
            DexType newType;
            DexValue argument = bootstrapArgs.get(i);
            DexValue.NestedDexValue newArgument = null;
            if (argument instanceof DexValue.DexValueMethodHandle) {
                DexMethodHandle oldHandle = (DexMethodHandle)((DexValue.DexValueMethodHandle)argument).value;
                DexMethodHandle newHandle = this.rewriteDexMethodHandle(oldHandle, method, use2);
                if (newHandle != oldHandle) {
                    newArgument = new DexValue.DexValueMethodHandle(newHandle);
                }
            } else if (argument instanceof DexValue.DexValueMethodType) {
                DexProto oldProto = (DexProto)((DexValue.DexValueMethodType)argument).value;
                DexProto newProto = this.appInfo.dexItemFactory.applyClassMappingToProto(oldProto, this.graphLense::lookupType, this.protoFixupCache);
                if (newProto != oldProto) {
                    newArgument = new DexValue.DexValueMethodType(newProto);
                }
            } else if (argument instanceof DexValue.DexValueType && (newType = this.graphLense.lookupType(oldType = (DexType)((DexValue.DexValueType)argument).value)) != oldType) {
                newArgument = new DexValue.DexValueType(newType);
            }
            if (newArgument != null) {
                if (newBoostrapArgs == null) {
                    newBoostrapArgs = new ArrayList<DexValue>(bootstrapArgs.subList(0, i));
                }
                newBoostrapArgs.add(newArgument);
                changed = true;
                continue;
            }
            if (newBoostrapArgs == null) continue;
            newBoostrapArgs.add(argument);
        }
        return changed ? newBoostrapArgs : bootstrapArgs;
    }

    private DexMethodHandle rewriteDexMethodHandle(DexMethodHandle methodHandle, DexEncodedMethod context, UseRegistry.MethodHandleUse use2) {
        if (methodHandle.isMethodHandle()) {
            DexMethodHandle.MethodHandleType newType;
            DexMethod actualTarget;
            DexMethod invokedMethod = methodHandle.asMethod();
            DexMethodHandle.MethodHandleType oldType = methodHandle.type;
            GraphLense.GraphLenseLookupResult lenseLookup = this.graphLense.lookupMethod(invokedMethod, context, oldType.toInvokeType());
            DexMethod rewrittenTarget = lenseLookup.getMethod();
            if (use2 == UseRegistry.MethodHandleUse.ARGUMENT_TO_LAMBDA_METAFACTORY) {
                actualTarget = rewrittenTarget;
                newType = lenseLookup.getType().toMethodHandle(actualTarget);
            } else {
                assert (use2 == UseRegistry.MethodHandleUse.NOT_ARGUMENT_TO_LAMBDA_METAFACTORY);
                actualTarget = this.appInfo.dexItemFactory.createMethod(invokedMethod.holder, rewrittenTarget.proto, rewrittenTarget.name);
                newType = oldType;
                if (oldType.isInvokeDirect()) {
                    assert (rewrittenTarget.holder == actualTarget.holder);
                    newType = lenseLookup.getType().toMethodHandle(actualTarget);
                    assert (newType == DexMethodHandle.MethodHandleType.INVOKE_DIRECT || newType == DexMethodHandle.MethodHandleType.INVOKE_INSTANCE);
                }
            }
            if (newType != oldType || actualTarget != invokedMethod || rewrittenTarget != actualTarget) {
                return new DexMethodHandle(newType, actualTarget, rewrittenTarget != actualTarget ? rewrittenTarget : null);
            }
        } else {
            DexField field = methodHandle.asField();
            DexField actualField = this.graphLense.lookupField(field);
            if (actualField != field) {
                return new DexMethodHandle(methodHandle.type, actualField);
            }
        }
        return methodHandle;
    }
}

