/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.classinliner;

import com.android.tools.r8.com.google.common.collect.Streams;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.desugar.LambdaRewriter;
import com.android.tools.r8.ir.optimize.CodeRewriter;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningOracle;
import com.android.tools.r8.ir.optimize.classinliner.InlineCandidateProcessor;
import com.android.tools.r8.shaking.Enqueuer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class ClassInliner {
    private final DexItemFactory factory;
    private final LambdaRewriter lambdaRewriter;
    private final int totalMethodInstructionLimit;
    private final ConcurrentHashMap<DexClass, Boolean> knownClasses = new ConcurrentHashMap();

    public ClassInliner(DexItemFactory factory, LambdaRewriter lambdaRewriter, int totalMethodInstructionLimit) {
        this.factory = factory;
        this.lambdaRewriter = lambdaRewriter;
        this.totalMethodInstructionLimit = totalMethodInstructionLimit;
    }

    public final void processMethodCode(Enqueuer.AppInfoWithLiveness appInfo, CodeRewriter codeRewriter, DexEncodedMethod method, IRCode code, Predicate<DexEncodedMethod> isProcessedConcurrently, InlinerAction inliner, Supplier<InliningOracle> defaultOracle) {
        boolean repeat;
        List roots = Streams.stream(code.instructionIterator()).filter(insn -> insn.isNewInstance() || insn.isStaticGet()).collect(Collectors.toList());
        boolean anyInlinedMethods = false;
        do {
            repeat = false;
            Iterator rootsIterator = roots.iterator();
            while (rootsIterator.hasNext()) {
                Instruction root = (Instruction)rootsIterator.next();
                InlineCandidateProcessor processor = new InlineCandidateProcessor(this.factory, appInfo, this.lambdaRewriter, clazz -> this.isClassEligible(appInfo, (DexClass)clazz), isProcessedConcurrently, method, root);
                if (!processor.isInstanceEligible() || !processor.isClassAndUsageEligible()) {
                    rootsIterator.remove();
                    continue;
                }
                if (!processor.areInstanceUsersEligible(method.method.getHolder(), defaultOracle) || processor.getEstimatedCombinedSizeForInlining() >= this.totalMethodInstructionLimit) continue;
                anyInlinedMethods |= processor.processInlining(code, inliner);
                code.removeAllTrivialPhis();
                assert (code.isConsistentSSA());
                rootsIterator.remove();
                repeat = true;
            }
        } while (repeat);
        if (anyInlinedMethods) {
            codeRewriter.removeTrivialCheckCastAndInstanceOfInstructions(code);
            codeRewriter.simplifyIf(code);
        }
    }

    private boolean isClassEligible(AppInfo appInfo, DexClass clazz) {
        Boolean eligible = this.knownClasses.get(clazz);
        if (eligible == null) {
            Boolean computed = this.computeClassEligible(appInfo, clazz);
            Boolean existing = this.knownClasses.putIfAbsent(clazz, computed);
            assert (existing == null || existing == computed);
            eligible = existing == null ? computed : existing;
        }
        return eligible;
    }

    private boolean computeClassEligible(AppInfo appInfo, DexClass clazz) {
        if (clazz == null || clazz.isLibraryClass() || clazz.accessFlags.isAbstract() || clazz.accessFlags.isInterface()) {
            return false;
        }
        for (DexEncodedMethod method : clazz.virtualMethods()) {
            if (method.method.name != this.factory.finalizeMethodName || method.method.proto != this.factory.objectMethods.finalize.proto) continue;
            return false;
        }
        return !appInfo.canTriggerStaticInitializer(clazz, true);
    }

    public static interface InlinerAction {
        public void inline(Map<InvokeMethod, Inliner.InliningInfo> var1);
    }
}

