/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.Maps;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.shaking.MainDexDirectReferenceTracer;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MainDexListBuilder {
    private final Set<DexType> baseClasses;
    private final AppInfoWithSubtyping appInfo;
    private final Set<DexType> mainDexTypes = new HashSet<DexType>();
    private final Map<DexType, Boolean> annotationTypeContainEnum;
    private final DexApplication dexApplication;

    public MainDexListBuilder(Set<DexType> baseClasses, DexApplication application) {
        this.dexApplication = application;
        this.appInfo = new AppInfoWithSubtyping(this.dexApplication);
        this.baseClasses = baseClasses.stream().filter(this::isProgramClass).collect(Collectors.toSet());
        DexClass enumType = this.appInfo.definitionFor(this.appInfo.dexItemFactory.enumType);
        if (enumType == null) {
            throw new CompilationError("Tracing for legacy multi dex is not possible without all classpath libraries (java.lang.Enum is missing)");
        }
        DexClass annotationType = this.appInfo.definitionFor(this.appInfo.dexItemFactory.annotationType);
        if (annotationType == null) {
            throw new CompilationError("Tracing for legacy multi dex is not possible without all classpath libraries (java.lang.annotation.Annotation is missing)");
        }
        this.annotationTypeContainEnum = Maps.newHashMapWithExpectedSize(this.appInfo.subtypes(this.appInfo.dexItemFactory.annotationType).size());
    }

    public Set<DexType> run() {
        this.traceMainDexDirectDependencies();
        this.traceRuntimeAnnotationsWithEnumForMainDex();
        return this.mainDexTypes.stream().filter(this::isProgramClass).collect(Collectors.toSet());
    }

    private void traceRuntimeAnnotationsWithEnumForMainDex() {
        for (DexProgramClass clazz : this.dexApplication.classes()) {
            DexType dexType = clazz.type;
            if (this.mainDexTypes.contains(dexType)) continue;
            if (this.isAnnotation(dexType) && this.isAnnotationWithEnum(dexType)) {
                this.addMainDexType(dexType);
                continue;
            }
            clazz.forEachAnnotation(annotation -> {
                if (!this.mainDexTypes.contains(dexType) && annotation.visibility == 1 && this.isAnnotationWithEnum(annotation.annotation.type)) {
                    this.addMainDexType(dexType);
                }
            });
        }
    }

    private boolean isAnnotationWithEnum(DexType dexType) {
        Boolean value = this.annotationTypeContainEnum.get(dexType);
        if (value == null) {
            DexClass clazz = this.appInfo.definitionFor(dexType);
            if (clazz == null) {
                value = Boolean.TRUE;
            } else {
                value = Boolean.FALSE;
                for (DexEncodedMethod method : clazz.virtualMethods()) {
                    DexProto proto = method.method.proto;
                    if (!proto.parameters.isEmpty()) continue;
                    DexType valueType = proto.returnType.toBaseType(this.appInfo.dexItemFactory);
                    if (this.isEnum(valueType)) {
                        value = Boolean.TRUE;
                        break;
                    }
                    if (!this.isAnnotation(valueType) || !this.isAnnotationWithEnum(valueType)) continue;
                    value = Boolean.TRUE;
                    break;
                }
            }
            this.annotationTypeContainEnum.put(dexType, value);
        }
        return value;
    }

    private boolean isEnum(DexType valueType) {
        return valueType.isSubtypeOf(this.appInfo.dexItemFactory.enumType, this.appInfo);
    }

    private boolean isAnnotation(DexType valueType) {
        return valueType.isSubtypeOf(this.appInfo.dexItemFactory.annotationType, this.appInfo);
    }

    private boolean isProgramClass(DexType dexType) {
        DexClass clazz = this.appInfo.definitionFor(dexType);
        return clazz != null && clazz.isProgramClass();
    }

    private void traceMainDexDirectDependencies() {
        new MainDexDirectReferenceTracer(this.appInfo, this::addMainDexType).run(this.baseClasses);
    }

    private void addMainDexType(DexType type) {
        if (!(type = type.toBaseType(this.appInfo.dexItemFactory)).isClassType()) {
            return;
        }
        DexClass clazz = this.appInfo.definitionFor(type);
        if (clazz == null) {
            return;
        }
        this.addMainDexType(clazz);
    }

    private void addMainDexType(DexClass dexClass) {
        DexType type = dexClass.type;
        if (this.mainDexTypes.add(type)) {
            if (dexClass.superType != null) {
                this.addMainDexType(dexClass.superType);
            }
            for (DexType interfaze : dexClass.interfaces.values) {
                this.addMainDexType(interfaze);
            }
        }
    }
}

