/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.classinliner;

import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Lists;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ParameterUsagesInfo;
import com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.InstanceGet;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.desugar.LambdaRewriter;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningOracle;
import com.android.tools.r8.ir.optimize.classinliner.ClassInliner;
import com.android.tools.r8.ir.optimize.classinliner.FieldValueHelper;
import com.android.tools.r8.kotlin.KotlinInfo;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.utils.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;

final class InlineCandidateProcessor {
    private static final ImmutableSet<If.Type> ALLOWED_ZERO_TEST_TYPES = ImmutableSet.of(If.Type.EQ, If.Type.NE);
    private final DexItemFactory factory;
    private final Enqueuer.AppInfoWithLiveness appInfo;
    private final LambdaRewriter lambdaRewriter;
    private final Predicate<DexClass> isClassEligible;
    private final Predicate<DexEncodedMethod> isProcessedConcurrently;
    private final DexEncodedMethod method;
    private final Instruction root;
    private Value eligibleInstance;
    private DexType eligibleClass;
    private DexClass eligibleClassDefinition;
    private boolean isDesugaredLambda;
    private final Map<InvokeMethod, Inliner.InliningInfo> methodCallsOnInstance = new IdentityHashMap<InvokeMethod, Inliner.InliningInfo>();
    private final Map<InvokeMethod, Inliner.InliningInfo> extraMethodCalls = new IdentityHashMap<InvokeMethod, Inliner.InliningInfo>();
    private final List<Pair<InvokeMethod, Integer>> unusedArguments = new ArrayList<Pair<InvokeMethod, Integer>>();
    private int estimatedCombinedSizeForInlining = 0;

    InlineCandidateProcessor(DexItemFactory factory, Enqueuer.AppInfoWithLiveness appInfo, LambdaRewriter lambdaRewriter, Predicate<DexClass> isClassEligible, Predicate<DexEncodedMethod> isProcessedConcurrently, DexEncodedMethod method, Instruction root) {
        this.factory = factory;
        this.lambdaRewriter = lambdaRewriter;
        this.isClassEligible = isClassEligible;
        this.method = method;
        this.root = root;
        this.appInfo = appInfo;
        this.isProcessedConcurrently = isProcessedConcurrently;
    }

    int getEstimatedCombinedSizeForInlining() {
        return this.estimatedCombinedSizeForInlining;
    }

    boolean isInstanceEligible() {
        this.eligibleInstance = this.root.outValue();
        if (this.eligibleInstance == null) {
            return false;
        }
        this.eligibleClass = this.isNewInstance() ? this.root.asNewInstance().clazz : this.root.asStaticGet().getField().type;
        this.eligibleClassDefinition = this.appInfo.definitionFor(this.eligibleClass);
        if (this.eligibleClassDefinition == null && this.lambdaRewriter != null) {
            this.eligibleClassDefinition = this.lambdaRewriter.getLambdaClass(this.eligibleClass);
            this.isDesugaredLambda = this.eligibleClassDefinition != null;
        }
        return this.eligibleClassDefinition != null;
    }

    boolean isClassAndUsageEligible() {
        if (!this.isClassEligible.test(this.eligibleClassDefinition)) {
            return false;
        }
        if (this.isNewInstance()) {
            return !this.eligibleClassDefinition.hasClassInitializer();
        }
        assert (this.root.isStaticGet());
        if (this.isDesugaredLambda) {
            return true;
        }
        if (this.eligibleClassDefinition.instanceFields().length > 0 || !this.eligibleClassDefinition.accessFlags.isFinal()) {
            return false;
        }
        DexEncodedMethod classInitializer = this.eligibleClassDefinition.getClassInitializer();
        if (classInitializer == null || this.isProcessedConcurrently.test(classInitializer)) {
            return false;
        }
        DexEncodedMethod.TrivialInitializer info = classInitializer.getOptimizationInfo().getTrivialInitializerInfo();
        assert (info == null || info instanceof DexEncodedMethod.TrivialInitializer.TrivialClassInitializer);
        DexField instanceField = this.root.asStaticGet().getField();
        return info != null && ((DexEncodedMethod.TrivialInitializer.TrivialClassInitializer)info).field == instanceField && !this.appInfo.isPinned(this.eligibleClassDefinition.lookupStaticField((DexField)instanceField).field);
    }

    boolean areInstanceUsersEligible(DexType invocationContext, Supplier<InliningOracle> defaultOracle) {
        if (this.eligibleInstance.numberOfPhiUsers() > 0) {
            return false;
        }
        Set<Instruction> currentUsers = this.eligibleInstance.uniqueUsers();
        while (!currentUsers.isEmpty()) {
            HashSet<Instruction> indirectUsers = new HashSet<Instruction>();
            for (Instruction user : currentUsers) {
                Inliner.InliningInfo inliningInfo;
                if (user.isInstanceGet() || user.isInstancePut() && user.asInstancePut().value() != this.eligibleInstance) {
                    DexField field = user.asFieldInstruction().getField();
                    if (field.clazz == this.eligibleClass && this.eligibleClassDefinition.lookupInstanceField(field) != null) continue;
                    return false;
                }
                if (user.isInvokeDirect() && this.root.isNewInstance() && (inliningInfo = this.isEligibleConstructorCall(user.asInvokeDirect())) != null) {
                    this.methodCallsOnInstance.put(user.asInvokeDirect(), inliningInfo);
                    continue;
                }
                if ((user.isInvokeVirtual() || user.isInvokeInterface()) && (inliningInfo = this.isEligibleDirectVirtualMethodCall(user.asInvokeMethodWithReceiver(), indirectUsers)) != null) {
                    this.methodCallsOnInstance.put(user.asInvokeMethodWithReceiver(), inliningInfo);
                    continue;
                }
                if (user.isInvokeMethod() && this.isExtraMethodCallEligible(defaultOracle, user.asInvokeMethod(), invocationContext)) continue;
                if (user.isIf()) {
                    If ifInsn = user.asIf();
                    If.Type type = ifInsn.getType();
                    if (ifInsn.isZeroTest() && (type == If.Type.EQ || type == If.Type.NE)) continue;
                }
                return false;
            }
            currentUsers = indirectUsers;
        }
        return true;
    }

    boolean processInlining(IRCode code, ClassInliner.InlinerAction inliner) {
        this.replaceUsagesAsUnusedArgument(code);
        boolean anyInlinedMethods = this.forceInlineExtraMethodInvocations(inliner);
        this.removeMiscUsages(code);
        this.removeFieldReads(code);
        this.removeFieldWrites();
        this.removeInstruction(this.root);
        return anyInlinedMethods |= this.forceInlineDirectMethodInvocations(inliner);
    }

    private void replaceUsagesAsUnusedArgument(IRCode code) {
        for (Pair<InvokeMethod, Integer> unusedArgument : this.unusedArguments) {
            InvokeMethod invoke = unusedArgument.getFirst();
            BasicBlock block = invoke.getBlock();
            ConstNumber nullValue = code.createConstNull();
            nullValue.setPosition(invoke.getPosition());
            LinkedList<Instruction> instructions = block.getInstructions();
            instructions.add(instructions.indexOf(invoke), nullValue);
            nullValue.setBlock(block);
            int argIndex = unusedArgument.getSecond() + (invoke.isInvokeMethodWithReceiver() ? 1 : 0);
            invoke.replaceValue(argIndex, nullValue.outValue());
        }
        this.unusedArguments.clear();
    }

    private boolean forceInlineExtraMethodInvocations(ClassInliner.InlinerAction inliner) {
        if (this.extraMethodCalls.isEmpty()) {
            return false;
        }
        inliner.inline(this.extraMethodCalls);
        this.methodCallsOnInstance.clear();
        this.extraMethodCalls.clear();
        this.unusedArguments.clear();
        this.estimatedCombinedSizeForInlining = 0;
        if (!this.areInstanceUsersEligible(null, () -> {
            throw new Unreachable("Inlining oracle is expected to be needed");
        })) {
            throw new Unreachable("Analysis must succeed after inlining of extra methods");
        }
        assert (this.extraMethodCalls.isEmpty());
        assert (this.unusedArguments.isEmpty());
        return true;
    }

    private boolean forceInlineDirectMethodInvocations(ClassInliner.InlinerAction inliner) {
        if (this.methodCallsOnInstance.isEmpty()) {
            return false;
        }
        inliner.inline(this.methodCallsOnInstance);
        return true;
    }

    private void removeMiscUsages(IRCode code) {
        boolean needToRemoveUnreachableBlocks = false;
        for (Instruction user : this.eligibleInstance.uniqueUsers()) {
            if (this.root.isNewInstance() && user.isInvokeDirect() && this.factory.isConstructor(user.asInvokeDirect().getInvokedMethod()) && user.asInvokeDirect().getInvokedMethod().holder == this.eligibleClassDefinition.superType) {
                this.removeInstruction(user);
                continue;
            }
            if (user.isIf()) {
                BasicBlock blockToRemove;
                If ifInsn = user.asIf();
                assert (ifInsn.isZeroTest()) : "Unexpected usage in non-zero-test IF instruction: " + user;
                BasicBlock block = user.getBlock();
                If.Type type = ifInsn.getType();
                assert (type == If.Type.EQ || type == If.Type.NE) : "Unexpected type in zero-test IF instruction: " + user;
                BasicBlock newBlock = type == If.Type.EQ ? ifInsn.fallthroughBlock() : ifInsn.getTrueTarget();
                BasicBlock basicBlock = blockToRemove = type == If.Type.EQ ? ifInsn.getTrueTarget() : ifInsn.fallthroughBlock();
                assert (newBlock != blockToRemove);
                block.replaceSuccessor(blockToRemove, newBlock);
                blockToRemove.removePredecessor(block);
                assert (block.exit().isGoto());
                assert (block.exit().asGoto().getTarget() == newBlock);
                needToRemoveUnreachableBlocks = true;
                continue;
            }
            if (user.isInstanceGet() || user.isInstancePut()) continue;
            throw new Unreachable("Unexpected usage left after method inlining: " + user);
        }
        if (needToRemoveUnreachableBlocks) {
            code.removeUnreachableBlocks();
        }
    }

    private void removeFieldReads(IRCode code) {
        IdentityHashMap<DexField, FieldValueHelper> fieldHelpers = new IdentityHashMap<DexField, FieldValueHelper>();
        for (Instruction user : this.eligibleInstance.uniqueUsers()) {
            if (user.isInstanceGet()) {
                this.replaceFieldRead(code, user.asInstanceGet(), fieldHelpers);
                continue;
            }
            if (user.isInstancePut()) continue;
            throw new Unreachable("Unexpected usage left after method inlining: " + user);
        }
    }

    private void replaceFieldRead(IRCode code, InstanceGet fieldRead, Map<DexField, FieldValueHelper> fieldHelpers) {
        Value value = fieldRead.outValue();
        if (value != null) {
            FieldValueHelper helper = fieldHelpers.computeIfAbsent(fieldRead.getField(), field -> new FieldValueHelper((DexField)field, code, this.root, this.appInfo));
            Value newValue = helper.getValueForFieldRead(fieldRead.getBlock(), fieldRead);
            value.replaceUsers(newValue);
            for (FieldValueHelper fieldValueHelper : fieldHelpers.values()) {
                fieldValueHelper.replaceValue(value, newValue);
            }
            assert (value.numberOfAllUsers() == 0);
            new TypeAnalysis(this.appInfo, code.method).widening(code.method, code);
        }
        this.removeInstruction(fieldRead);
    }

    private void removeFieldWrites() {
        for (Instruction user : this.eligibleInstance.uniqueUsers()) {
            if (!user.isInstancePut()) {
                throw new Unreachable("Unexpected usage left after field reads removed: " + user);
            }
            if (user.asInstancePut().getField().clazz != this.eligibleClass) {
                throw new Unreachable("Unexpected field write left after field reads removed: " + user);
            }
            this.removeInstruction(user);
        }
    }

    private Inliner.InliningInfo isEligibleConstructorCall(InvokeDirect initInvoke) {
        DexEncodedMethod.TrivialInitializer info;
        DexMethod init = initInvoke.getInvokedMethod();
        if (!this.factory.isConstructor(init)) {
            return null;
        }
        if (initInvoke.inValues().lastIndexOf(this.eligibleInstance) != 0) {
            return null;
        }
        if (init.holder != this.eligibleClass) {
            return null;
        }
        DexEncodedMethod definition = this.findSingleTarget(init, true);
        if (definition == null || this.isProcessedConcurrently.test(definition)) {
            return null;
        }
        if (initInvoke.getBlock().hasCatchHandlers() && definition.getOptimizationInfo().neverReturnsNormally()) {
            return null;
        }
        if (this.isDesugaredLambda) {
            this.markSizeForInlining(definition);
            return new Inliner.InliningInfo(definition, this.eligibleClass);
        }
        if (this.eligibleClassDefinition.superType != this.factory.objectType && !((info = definition.getOptimizationInfo().getTrivialInitializerInfo()) instanceof DexEncodedMethod.TrivialInitializer.TrivialInstanceInitializer)) {
            return null;
        }
        if (!definition.isInliningCandidate(this.method, Inliner.Reason.SIMPLE, (AppInfoWithSubtyping)this.appInfo)) {
            return null;
        }
        return definition.getOptimizationInfo().getClassInlinerEligibility() != null ? new Inliner.InliningInfo(definition, this.eligibleClass) : null;
    }

    private static boolean isEligibleInvokeWithAllUsersAsReceivers(DexEncodedMethod.ClassInlinerEligibility eligibility, InvokeMethodWithReceiver invoke, Set<Instruction> indirectUsers) {
        if (!eligibility.returnsReceiver || invoke.outValue() == null || invoke.outValue().numberOfAllUsers() == 0) {
            return true;
        }
        if (invoke.outValue().numberOfPhiUsers() > 0) {
            return false;
        }
        for (Instruction instruction : invoke.outValue().uniqueUsers()) {
            if (!instruction.isInvokeMethodWithReceiver()) {
                return false;
            }
            InvokeMethodWithReceiver user = instruction.asInvokeMethodWithReceiver();
            if (user.getReceiver() != invoke.outValue()) {
                return false;
            }
            int uses = 0;
            for (Value value : user.inValues()) {
                if (value != invoke.outValue() || ++uses <= 1) continue;
                return false;
            }
        }
        indirectUsers.addAll(invoke.outValue().uniqueUsers());
        return true;
    }

    private Inliner.InliningInfo isEligibleDirectVirtualMethodCall(InvokeMethodWithReceiver invoke, Set<Instruction> indirectUsers) {
        if (invoke.inValues().lastIndexOf(this.eligibleInstance) > 0) {
            return null;
        }
        return this.isEligibleVirtualMethodCall(!invoke.getBlock().hasCatchHandlers(), invoke.getInvokedMethod(), eligibility -> InlineCandidateProcessor.isEligibleInvokeWithAllUsersAsReceivers(eligibility, invoke, indirectUsers));
    }

    private Inliner.InliningInfo isEligibleIndirectVirtualMethodCall(DexMethod callee) {
        return this.isEligibleVirtualMethodCall(false, callee, eligibility -> !eligibility.returnsReceiver);
    }

    private Inliner.InliningInfo isEligibleVirtualMethodCall(boolean allowMethodsWithoutNormalReturns, DexMethod callee, Predicate<DexEncodedMethod.ClassInlinerEligibility> eligibilityAcceptanceCheck) {
        AppInfo.ResolutionResult resolutionResult = this.appInfo.resolveMethod(callee.holder, callee);
        if (resolutionResult.hasSingleTarget() && !resolutionResult.asSingleTarget().isVirtualMethod()) {
            return null;
        }
        DexEncodedMethod singleTarget = this.findSingleTarget(callee, false);
        if (singleTarget == null || !singleTarget.isVirtualMethod() || this.isProcessedConcurrently.test(singleTarget)) {
            return null;
        }
        if (this.method == singleTarget) {
            return null;
        }
        if (this.isDesugaredLambda) {
            if (singleTarget.accessFlags.isBridge()) {
                return null;
            }
            this.markSizeForInlining(singleTarget);
            return new Inliner.InliningInfo(singleTarget, this.eligibleClass);
        }
        DexEncodedMethod.OptimizationInfo optimizationInfo = singleTarget.getOptimizationInfo();
        DexEncodedMethod.ClassInlinerEligibility eligibility = optimizationInfo.getClassInlinerEligibility();
        if (eligibility == null) {
            return null;
        }
        if (!eligibilityAcceptanceCheck.test(eligibility)) {
            return null;
        }
        if (!allowMethodsWithoutNormalReturns && optimizationInfo.neverReturnsNormally()) {
            return null;
        }
        if (!singleTarget.isInliningCandidate(this.method, Inliner.Reason.SIMPLE, (AppInfoWithSubtyping)this.appInfo)) {
            return null;
        }
        this.markSizeForInlining(singleTarget);
        return new Inliner.InliningInfo(singleTarget, this.eligibleClass);
    }

    private boolean isExtraMethodCallEligible(Supplier<InliningOracle> defaultOracle, InvokeMethod invokeMethod, DexType invocationContext) {
        DexEncodedMethod singleTarget;
        ArrayList<Value> arguments = Lists.newArrayList(invokeMethod.inValues());
        if (invokeMethod.isInvokeSuper() || invokeMethod.isInvokeDirect() && this.factory.isConstructor(invokeMethod.getInvokedMethod())) {
            return false;
        }
        if (invokeMethod.isInvokeMethodWithReceiver()) {
            if (arguments.get(0) == this.eligibleInstance) {
                return false;
            }
            arguments.remove(0);
        }
        if ((singleTarget = invokeMethod.lookupSingleTarget(this.appInfo, invocationContext)) == null || this.isProcessedConcurrently.test(singleTarget)) {
            return false;
        }
        DexEncodedMethod.OptimizationInfo optimizationInfo = singleTarget.getOptimizationInfo();
        if (invokeMethod.getBlock().hasCatchHandlers() && optimizationInfo.neverReturnsNormally()) {
            return false;
        }
        for (int argIndex = 0; argIndex < arguments.size(); ++argIndex) {
            Value argument = (Value)arguments.get(argIndex);
            if (argument != this.eligibleInstance) continue;
            ParameterUsagesInfo.ParameterUsage parameterUsage = optimizationInfo.getParameterUsages(argIndex);
            if (parameterUsage == null) {
                return false;
            }
            if (parameterUsage.notUsed()) {
                this.unusedArguments.add(new Pair<InvokeMethod, Integer>(invokeMethod, argIndex));
                continue;
            }
            if (parameterUsage.returnValue && invokeMethod.outValue() != null && invokeMethod.outValue().numberOfAllUsers() != 0) {
                return false;
            }
            if (!Sets.difference(parameterUsage.ifZeroTest, ALLOWED_ZERO_TEST_TYPES).isEmpty()) {
                return false;
            }
            for (Pair<Invoke.Type, DexMethod> call : parameterUsage.callsReceiver) {
                if (call.getFirst() != Invoke.Type.VIRTUAL && call.getFirst() != Invoke.Type.INTERFACE) {
                    return false;
                }
                Inliner.InliningInfo potentialInliningInfo = this.isEligibleIndirectVirtualMethodCall(call.getSecond());
                if (potentialInliningInfo == null) {
                    return false;
                }
                Inliner.InlineAction inlineAction = invokeMethod.computeInlining(defaultOracle.get(), this.method.method.holder);
                if (inlineAction != null) continue;
                return false;
            }
            this.extraMethodCalls.put(invokeMethod, new Inliner.InliningInfo(singleTarget, null));
        }
        this.markSizeForInlining(singleTarget);
        return true;
    }

    private boolean exemptFromInstructionLimit(DexEncodedMethod inlinee) {
        DexType inlineeHolder = inlinee.method.holder;
        if (this.isDesugaredLambda && inlineeHolder == this.eligibleClass) {
            return true;
        }
        if (this.appInfo.isPinned(inlineeHolder)) {
            return false;
        }
        DexClass inlineeClass = this.appInfo.definitionFor(inlineeHolder);
        assert (inlineeClass != null);
        KotlinInfo kotlinInfo = inlineeClass.getKotlinInfo();
        return kotlinInfo != null && kotlinInfo.isSyntheticClass() && kotlinInfo.asSyntheticClass().isLambda();
    }

    private void markSizeForInlining(DexEncodedMethod inlinee) {
        if (!this.exemptFromInstructionLimit(inlinee)) {
            this.estimatedCombinedSizeForInlining += inlinee.getCode().estimatedSizeForInlining();
        }
    }

    private boolean isNewInstance() {
        return this.root.isNewInstance();
    }

    private DexEncodedMethod findSingleTarget(DexMethod callee, boolean isDirect) {
        return isDirect ? this.eligibleClassDefinition.lookupDirectMethod(callee) : this.eligibleClassDefinition.lookupVirtualMethod(callee);
    }

    private void removeInstruction(Instruction instruction) {
        instruction.inValues().forEach(v -> v.removeUser(instruction));
        instruction.getBlock().removeInstruction(instruction);
    }
}

