/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.peepholes;

import com.android.tools.r8.ir.code.Dup;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Load;
import com.android.tools.r8.ir.code.StackValue;
import com.android.tools.r8.ir.optimize.peepholes.BasicBlockPeephole;
import com.android.tools.r8.ir.optimize.peepholes.Match;
import com.android.tools.r8.ir.optimize.peepholes.PeepholeHelper;
import com.android.tools.r8.ir.optimize.peepholes.PeepholeLayout;
import com.android.tools.r8.ir.optimize.peepholes.Point;

public class LoadLoadDupPeephole
implements BasicBlockPeephole {
    private final Point lastLoadExp = new Point(PeepholeHelper.withoutLocalInfo(Instruction::isLoad));
    private final Point firstLoadExp = new Point(PeepholeHelper.withoutLocalInfo(Instruction::isLoad));
    private final PeepholeLayout layout = PeepholeLayout.lookBackward(this.lastLoadExp, this.firstLoadExp);

    @Override
    public boolean match(InstructionListIterator it) {
        Match match = this.layout.test(it);
        if (match == null) {
            return false;
        }
        Load lastLoad = this.lastLoadExp.get(match).asLoad();
        Load firstLoad = this.firstLoadExp.get(match).asLoad();
        if (firstLoad.src() != lastLoad.src()) {
            return false;
        }
        assert (!firstLoad.src().hasLocalInfo());
        assert (!lastLoad.src().hasLocalInfo());
        StackValue src = (StackValue)firstLoad.outValue();
        src.removeUser(lastLoad);
        int height = src.getHeight();
        StackValue newFirstLoadOut = src.duplicate(height);
        StackValue newLastLoadOut = src.duplicate(height + 1);
        firstLoad.outValue().replaceUsers(newFirstLoadOut);
        lastLoad.outValue().replaceUsers(newLastLoadOut);
        it.replaceCurrentInstruction(new Dup(newFirstLoadOut, newLastLoadOut, src));
        return true;
    }
}

