/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCacheTable<R, C, V>
extends LinkedHashMap<R, Map<C, V>> {
    private static final float LOAD_FACTOR = 0.75f;
    private final int rowCapacity;
    private final int columnCapacity;

    private LRUCacheTable(int rowCapacity, int columnCapacity, float loadFactor) {
        super(rowCapacity, loadFactor);
        this.rowCapacity = rowCapacity;
        this.columnCapacity = columnCapacity;
    }

    public static <R, C, V> LRUCacheTable<R, C, V> create(int rowCapacity, int columnCapacity) {
        return new LRUCacheTable<R, C, V>(rowCapacity, columnCapacity, 0.75f);
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<R, Map<C, V>> eldest) {
        return this.size() > this.rowCapacity;
    }

    public V put(R rowKey, C columnKey, V value) {
        Map row = this.computeIfAbsent(rowKey, k -> new LRUCacheRow(this.columnCapacity, 0.75f));
        return row.putIfAbsent(columnKey, value);
    }

    public boolean contains(R rowKey, C columnKey) {
        return ((Map)this.getOrDefault(rowKey, ImmutableMap.of())).containsKey(columnKey);
    }

    public V get(R rowKey, C columnKey) {
        return ((Map)this.getOrDefault(rowKey, ImmutableMap.of())).get(columnKey);
    }

    public V getOrDefault(R rowKey, C columnKey, V defaultValue) {
        return ((Map)this.getOrDefault(rowKey, ImmutableMap.of())).getOrDefault(columnKey, defaultValue);
    }

    static class LRUCacheRow<C, V>
    extends LinkedHashMap<C, V> {
        private final int columnCapacity;

        public LRUCacheRow(int columnCapacity, float loadFactor) {
            super(columnCapacity, loadFactor);
            this.columnCapacity = columnCapacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<C, V> eldest) {
            return this.size() > this.columnCapacity;
        }
    }
}

